/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.oa.util.OAUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushSupplierDataFromOADbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushSupplierDataFromOADbImpl.class);
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private ElsEnterpriseInfoRpcService enterpriseInfoService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO supplierMasterData = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        if (!"3".equals(supplierMasterData.getReturnState())) {
            supplierMasterData.setReturnState("0");
            return true;
        }
        return false;
    }

    public JSONObject before(JSONObject obj, Object custom) {
        String elsAccount = obj.getString("bus_account");
        obj.put("body", (Object)this.getSupplierVo(custom, elsAccount));
        return obj;
    }

    public JSONObject after(JSONObject object, JSONObject paramObj, Object custom) {
        JSONObject customJson = (JSONObject)custom;
        String elsAccount = customJson.getString("elsAccount");
        log.info(JSON.toJSONString((Object)object));
        JSONObject customObj = (JSONObject)custom;
        String result = OAUtil.getResult((JSONObject)object);
        SupplierMasterDataVO masterData = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)masterData, (Object)supplierMasterData);
        supplierMasterData.setReturnState("1");
        supplierMasterData.setInterfaceMsg(result);
        this.supplierMasterDataService.updateById((Object)supplierMasterData);
        return object;
    }

    private JSONObject getSupplierVo(Object custom, String elsAccount) {
        SupplierMasterDataVO supplierVo = this.getSupplierVo(custom);
        Object dataSource = ThirdUtil.newConvertMapping((String)elsAccount, (String)"pushSupplierData", (Object)JSON.toJSONString((Object)supplierVo), null);
        return OAUtil.getDoCreateWorkflowRequest((JSONObject)JSON.parseObject((String)dataSource.toString()));
    }

    private SupplierMasterDataVO getSupplierVo(Object custom) {
        JSONObject result = (JSONObject)custom;
        log.info("PushSupplierDataFromXcDbImpl\u300bgetSupplierVo->" + JSON.toJSONString((Object)result));
        SupplierMasterDataVO supplierMasterData = (SupplierMasterDataVO)result.get((Object)"supplierMasterDataVO");
        supplierMasterData.setSupplierAddressInfoList(this.supplierAddressInfoService.getByAccount(supplierMasterData.getToElsAccount(), supplierMasterData.getElsAccount()));
        supplierMasterData.setSupplierContactsInfoList(this.supplierContactsInfoService.getByAccount(supplierMasterData.getToElsAccount(), supplierMasterData.getElsAccount()));
        supplierMasterData.setSupplierBankInfoList(this.supplierBankInfoService.selectByMainId(supplierMasterData.getId()));
        supplierMasterData.setElsEnterpriseInfo(this.enterpriseInfoService.getByElsAccount(supplierMasterData.getToElsAccount()));
        return supplierMasterData;
    }
}

