/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.api;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import com.els.modules.third.jdyxc.util.XcApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetSupplierDataFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetSupplierDataFromXcDbImpl.class);
    private static final String SUPPLIER_LIST = "/jdy/v2/bd/supplier";
    private static final String SUPPLIER_DETAIL = "/jdy/v2/bd/supplier_detail";
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Resource(name="srmPoolExecutor")
    private Executor executor;
    @Autowired
    private SupplierMasterDataService masterDataService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private ElsEnterpriseInfoRpcService enterpriseInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, SUPPLIER_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String elsAccount = customObj.getString("bus_account");
        log.info("GetSupplierDataFromXcV2DbImpl -> elsAccount\u3010{}\u3011 result \u3010{}\u3011", (Object)elsAccount, (Object)JSON.toJSONString((Object)obj));
        List resultData = JSON.parseArray((String)JSONArray.toJSONString((Object)this.handlerHeadResultListInfoV2(obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        if (CollUtil.isEmpty((Collection)resultData)) {
            obj.put("message", (Object)"\u6682\u65e0\u4f9b\u5e94\u5546\u6570\u636e\u9700\u8981\u540c\u6b65");
            return obj;
        }
        Map returnMap = resultData.stream().collect(Collectors.toMap(o -> o.get("id").toString(), Function.identity()));
        Set<String> sourceIds = returnMap.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String sourceId : sourceIds) {
            JSONObject jsonObject = XcApiUtil.findInterfaceById((String)elsAccount, (String)"getSupplierDetailById", (String)sourceId, (String)SUPPLIER_DETAIL);
            this.merge((Map)returnMap.get(sourceId), jsonObject);
            jsonArray.add((Object)jsonObject);
        }
        Object dataSource = ThirdUtil.newConvertMapping((String)elsAccount, (String)"getSupplierMainData", (Object)jsonArray, null);
        List dataSouceList = JSON.parseArray((String)dataSource.toString(), SupplierMasterDataVO.class);
        this.masterDataService.batchSupplierMasterData(dataSouceList, new ArrayList(), ThirdTypeEnum.THIRD_JD_XC.getValue());
        return obj;
    }

    private List<SupplierMasterData> getSupplierMasterData(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, SupplierMasterData::getToElsAccount, SupplierMasterData::getSupplierName}).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return this.supplierMasterDataService.list((Wrapper)wrapper);
    }

    private void merge(Map source, JSONObject target) {
        if (target != null && source != null) {
            Set keys = source.keySet();
            for (String key : keys) {
                Object sourceObject = source.get(key);
                if (sourceObject == null) continue;
                if (sourceObject instanceof String && target.get((Object)key) == null) {
                    target.put(key, sourceObject);
                    continue;
                }
                if (!(sourceObject instanceof JSONArray) || ((JSONArray)sourceObject).size() == 0) continue;
                target.put(key, sourceObject);
            }
        }
    }

    private SupplierAddressInfo handlerSupplierAddressInfo(List<SupplierAddressInfo> addressInfoList, SupplierMasterData data) {
        SupplierAddressInfo supplierAddressInfo = addressInfoList.get(0);
        supplierAddressInfo.setElsAccount(data.getToElsAccount());
        supplierAddressInfo.setHeadId(data.getId());
        supplierAddressInfo.setCreateBy(data.getCreateBy());
        supplierAddressInfo.setCreateTime(data.getCreateTime());
        supplierAddressInfo.setDeleted(Integer.valueOf(0));
        return supplierAddressInfo;
    }

    private SupplierContactsInfo handlerSupplierContactsInfo(List<SupplierContactsInfo> contactsInfoList, SupplierMasterData data) {
        SupplierContactsInfo supplierContactsInfo = contactsInfoList.get(0);
        supplierContactsInfo.setElsAccount(data.getToElsAccount());
        supplierContactsInfo.setHeadId(data.getId());
        supplierContactsInfo.setCreateBy(data.getCreateBy());
        supplierContactsInfo.setCreateTime(data.getCreateTime());
        supplierContactsInfo.setDeleted(Integer.valueOf(0));
        return supplierContactsInfo;
    }

    private SupplierBankInfo handlerSupplierBankInfo(List<SupplierBankInfo> bankInfoList, SupplierMasterData data) {
        SupplierBankInfo supplierBankInfo = bankInfoList.get(0);
        supplierBankInfo.setElsAccount(data.getToElsAccount());
        supplierBankInfo.setHeadId(data.getId());
        supplierBankInfo.setCreateBy(data.getCreateBy());
        supplierBankInfo.setCreateTime(data.getCreateTime());
        supplierBankInfo.setDeleted(Integer.valueOf(0));
        return supplierBankInfo;
    }

    public List<SupplierMasterData> getSupplierMasterDataBySupplierName(List<String> supplierName) {
        LambdaQueryWrapper sw = Wrappers.lambdaQuery();
        sw.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, SupplierMasterData::getSupplierCode, SupplierMasterData::getToElsAccount, SupplierMasterData::getSupplierName, SupplierMasterData::getAccountGroup, SupplierMasterData::getCompany});
        ((LambdaQueryWrapper)sw.in(SupplierMasterData::getSupplierName, supplierName)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return this.supplierMasterDataService.list((Wrapper)sw);
    }
}

