/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.jdyxc.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.third.base.util.ThirdUtil;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushSupplierDataFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushSupplierDataFromXcDbImpl.class);
    private static final String SAVA_SUPPLIER = "/jdy/v2/bd/supplier";
    @Autowired
    private AccountRpcService accountRpcService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private ElsEnterpriseInfoRpcService enterpriseInfoService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoService;
    @Autowired
    private BaseRpcService baseRpcService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO supplierMasterData = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        if (!"3".equals(supplierMasterData.getReturnState())) {
            supplierMasterData.setReturnState("0");
            return true;
        }
        return false;
    }

    public JSONObject before(JSONObject obj, Object custom) {
        String elsAccount = obj.getString("bus_account");
        obj.put("body", (Object)this.getSupplierVo(custom, elsAccount));
        return this.getSendJSON(obj, obj, "POST", SAVA_SUPPLIER);
    }

    public JSONObject after(JSONObject object, JSONObject paramObj, Object custom) {
        JSONObject customJson = (JSONObject)custom;
        String elsAccount = customJson.getString("elsAccount");
        String tenant = TenantContext.getTenant();
        TenantContext.setTenant((String)elsAccount);
        log.info(JSON.toJSONString((Object)object));
        JSONObject result = object.getJSONObject("result");
        JSONObject jsonResult = result.getJSONObject("data");
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO masterData = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)masterData, (Object)supplierMasterData);
        String message = "";
        String partyState = "";
        if (!"200".equals(object.getString("code"))) {
            supplierMasterData.setReturnState("2");
            supplierMasterData.setInterfaceMsg(object.getString("message"));
            this.supplierMasterDataService.updateById((Object)supplierMasterData);
            return object;
        }
        if (result.containsKey((Object)"success") && !result.getBoolean("success").booleanValue()) {
            supplierMasterData.setReturnState("2");
            supplierMasterData.setInterfaceMsg(result.getString("message"));
            this.supplierMasterDataService.updateById((Object)supplierMasterData);
            return object;
        }
        if (result.containsKey((Object)"errcode") && 0 != result.getInteger("errcode")) {
            supplierMasterData.setReturnState("2");
            supplierMasterData.setInterfaceMsg(result.getString("message"));
            this.supplierMasterDataService.updateById((Object)supplierMasterData);
            return object;
        }
        if (result.containsKey((Object)"data")) {
            JSONObject data = result.getJSONObject("data");
            if (result.containsKey((Object)"success") && !data.getBoolean("success").booleanValue()) {
                supplierMasterData.setReturnState("2");
                supplierMasterData.setInterfaceMsg(data.getString("message"));
                this.supplierMasterDataService.updateById((Object)supplierMasterData);
                return object;
            }
        }
        JSONArray successPkIds = jsonResult.getJSONArray("ids");
        JSONObject idNumberMap = jsonResult.getJSONObject("id_number_map");
        if (successPkIds.size() > 0) {
            String sourceId = successPkIds.getString(0);
            String erpCode = idNumberMap.getString(sourceId);
            supplierMasterData.setReturnState("1");
            supplierMasterData.setInterfaceMsg(result.getString("message"));
            supplierMasterData.setSourceId(sourceId);
            supplierMasterData.setSupplierCode(erpCode);
            this.supplierMasterDataService.updateById((Object)supplierMasterData);
        }
        TenantContext.clear();
        TenantContext.setTenant((String)tenant);
        return object;
    }

    private SupplierMasterDataVO getSupplierVo(Object custom) {
        JSONObject result = (JSONObject)custom;
        log.info("PushSupplierDataFromXcDbImpl\u300bgetSupplierVo->" + JSON.toJSONString((Object)result));
        SupplierMasterDataVO supplierMasterData = (SupplierMasterDataVO)result.get((Object)"supplierMasterDataVO");
        supplierMasterData.setSupplierAddressInfoList(this.supplierAddressInfoService.getByAccount(supplierMasterData.getToElsAccount(), supplierMasterData.getElsAccount()));
        supplierMasterData.setSupplierContactsInfoList(this.supplierContactsInfoService.getByAccount(supplierMasterData.getToElsAccount(), supplierMasterData.getElsAccount()));
        supplierMasterData.setSupplierBankInfoList(this.supplierBankInfoService.selectByMainId(supplierMasterData.getId()));
        supplierMasterData.setElsEnterpriseInfo(this.enterpriseInfoService.getByElsAccount(supplierMasterData.getToElsAccount()));
        return supplierMasterData;
    }

    private JSONObject getSupplierVo(Object custom, String elsAccount) {
        SupplierMasterDataVO supplierVo = this.getSupplierVo(custom);
        Object dataSource = ThirdUtil.newConvertMapping((String)elsAccount, (String)"pushSupplierData", (Object)JSON.toJSONString((Object)supplierVo), null);
        return JSON.parseObject((String)dataSource.toString());
    }
}

