/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceNormHead;
import com.els.modules.performance.enumerate.PerformanceNormStatusEnum;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormHeadMapper;
import com.els.modules.performance.service.PurchasePerformanceNormHeadService;
import com.els.modules.performance.vo.ComputeScoreVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePerformanceNormHeadServiceImpl
extends ServiceImpl<PurchasePerformanceNormHeadMapper, PurchasePerformanceNormHead>
implements PurchasePerformanceNormHeadService {
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).insert((Object)normHead);
        this.insertData(normHead, normGradList, normFormulaList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).updateById((Object)normHead);
        this.purchasePerformanceNormGradMapper.deleteByMainId(normHead.getId());
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(normHead.getId());
        this.insertData(normHead, normGradList, normFormulaList);
    }

    private void insertData(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        if (CollectionUtil.isNotEmpty(normGradList)) {
            for (PurchasePerformanceNormGrad normGrad : normGradList) {
                normGrad.setId(null);
                normGrad.setHeadId(normHead.getId());
                SysUtil.setSysParam((BaseEntity)normGrad, (BaseEntity)normHead);
            }
            this.purchasePerformanceNormGradMapper.insertBatchSomeColumn(normGradList);
        }
        if (CollectionUtil.isNotEmpty(normFormulaList)) {
            int itemNumber = 1;
            for (PurchasePerformanceNormFormula normFormula : normFormulaList) {
                normFormula.setId(null);
                normFormula.setItemNumber(String.valueOf(itemNumber++));
                normFormula.setHeadId(normHead.getId());
                normFormula.setNormNumber(normHead.getNormNumber());
                SysUtil.setSysParam((BaseEntity)normFormula, (BaseEntity)normHead);
            }
            this.purchasePerformanceNormFormulaMapper.insertBatchSomeColumn(normFormulaList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceNormGradMapper.deleteByMainId(id);
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(id);
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePerformanceNormGradMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceNormFormulaMapper.deleteByMainId(serializable.toString());
            ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public Map<String, String> computeScore(ComputeScoreVO scoreVO) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String id = scoreVO.getNormId();
        PurchasePerformanceNormHead normHead = (PurchasePerformanceNormHead)((Object)((PurchasePerformanceNormHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (ScoreMethodEnum.SYS_COMPUTE.getValue().equals(normHead.getScoringMethod())) {
            List<PurchasePerformanceNormFormula> formulaList = this.purchasePerformanceNormFormulaMapper.selectByMainId(id);
            Assert.notEmpty(formulaList, (String)I18nUtil.translate((String)"i18n_alert_YxuRBWWWWWWWWWWIdjHetdtXRBRK_5a9cd6c3", (String)"\u627e\u4e0d\u5230\u6307\u6807id[ ${0} ]\u5bf9\u5e94\u7684\u7cfb\u7edf\u8ba1\u7b97\u7ee9\u6548\u6307\u6807\u516c\u5f0f", (String[])new String[]{id}));
            HashMap<String, String> params = new HashMap<String, String>();
            for (PurchasePerformanceNormFormula formula : formulaList) {
                String sql = this.appendSql(formula, scoreVO);
                String value = ((PurchasePerformanceNormHeadMapper)this.baseMapper).getNormBaseVale(sql);
                params.put(formula.getNormBase(), value);
            }
            String computeValue = FormulaUtil.convertToFormula((String)normHead.getFormula(), params);
            resultMap.put("computeValue", computeValue);
            if (StrUtil.isNotBlank((CharSequence)computeValue)) {
                BigDecimal compute = new BigDecimal(computeValue);
                List<PurchasePerformanceNormGrad> gradList = this.purchasePerformanceNormGradMapper.selectByMainId(id);
                for (PurchasePerformanceNormGrad grad : gradList) {
                    BigDecimal startInterval = grad.getStartInterval();
                    BigDecimal endInterval = grad.getEndInterval();
                    if (compute.compareTo(startInterval) < 0 || compute.compareTo(endInterval) >= 0) continue;
                    resultMap.put("score", grad.getGradingScore().toString());
                    return resultMap;
                }
                return resultMap;
            }
        }
        return resultMap;
    }

    private String appendSql(PurchasePerformanceNormFormula formula, ComputeScoreVO scoreVO) {
        StringBuilder sql = new StringBuilder("select ");
        String table = formula.getSourceTable();
        String field = formula.getSourceField();
        String normSql = formula.getNormSql();
        sql.append(field).append(" from ").append(table).append(" where 1=1 ");
        if (StrUtil.isNotBlank((CharSequence)normSql)) {
            sql.append("and ").append(normSql);
        }
        if ("1".equals(formula.getSupplierCondition())) {
            sql.append("and to_els_account='").append(scoreVO.getToElsAccount()).append("' ");
        }
        if ("1".equals(formula.getAccountGroupCondition())) {
            sql.append("and account_group='").append(scoreVO.getAccountGroup()).append("' ");
        }
        if ("1".equals(formula.getFactoryCondition())) {
            sql.append("and factory='").append(scoreVO.getFactor()).append("' ");
        }
        return sql.toString();
    }
}

