/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.enumerate.PerformanceTemplateEffectiveStatusEnum;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.modules.performance.vo.PurchasePerformanceTemplateHeadVO;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceTemplateAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchasePerformanceTemplateHeadVO headVO = (PurchasePerformanceTemplateHeadVO)((Object)JSON.parseObject((String)params, PurchasePerformanceTemplateHeadVO.class));
        PurchasePerformanceTemplateHead purchasePerformanceTemplateHead = new PurchasePerformanceTemplateHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchasePerformanceTemplateHead));
        purchasePerformanceTemplateHead.setAuditStatus(outputParamVO.getAuditStatus());
        purchasePerformanceTemplateHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchasePerformanceTemplateHeadService.updateMain(purchasePerformanceTemplateHead, headVO.getPurchasePerformanceTemplateItemList(), headVO.getPurchasePerformanceTemplateGradList());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)this.purchasePerformanceTemplateHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (head.getEffectiveDate().before((Date)DateUtil.date())) {
            head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
        }
        this.updateTemplate(head, inputParamVO, outputParamVO);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateTemplate(null, inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateTemplate(null, inputParamVO, outputParamVO);
    }

    private void updateTemplate(PurchasePerformanceTemplateHead head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        head = (PurchasePerformanceTemplateHead)((Object)ObjectUtil.defaultIfNull((Object)((Object)head), (Object)((Object)new PurchasePerformanceTemplateHead())));
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchasePerformanceTemplateHeadService.updateById((Object)head);
    }
}

