/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportItemGrad;
import com.els.modules.performance.entity.SalePerformanceReportGrad;
import com.els.modules.performance.entity.SalePerformanceReportHead;
import com.els.modules.performance.entity.SalePerformanceReportItem;
import com.els.modules.performance.entity.SalePerformanceReportItemGrad;
import com.els.modules.performance.mapper.PurchasePerformanceReportGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemGradMapper;
import com.els.modules.performance.mapper.SalePerformanceReportGradMapper;
import com.els.modules.performance.mapper.SalePerformanceReportHeadMapper;
import com.els.modules.performance.mapper.SalePerformanceReportItemGradMapper;
import com.els.modules.performance.mapper.SalePerformanceReportItemMapper;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SalePerformanceReportHeadServiceImpl
extends ServiceImpl<SalePerformanceReportHeadMapper, SalePerformanceReportHead>
implements SalePerformanceReportHeadService {
    @Resource
    private SalePerformanceReportHeadMapper salePerformanceReportHeadMapper;
    @Resource
    private SalePerformanceReportItemMapper salePerformanceReportItemMapper;
    @Resource
    private SalePerformanceReportItemGradMapper salePerformanceReportItemGradMapper;
    @Resource
    private SalePerformanceReportGradMapper salePerformanceReportGradMapper;
    @Resource
    private PurchasePerformanceReportItemGradMapper purchasePerformanceReportItemGradMapper;
    @Resource
    private PurchasePerformanceReportGradMapper purchasePerformanceReportGradMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SalePerformanceReportHead salePerformanceReportHead, List<SalePerformanceReportItem> salePerformanceReportItemList) {
        this.salePerformanceReportHeadMapper.insert((Object)salePerformanceReportHead);
        this.insertData(salePerformanceReportHead, salePerformanceReportItemList);
    }

    private void insertData(SalePerformanceReportHead saleHead, List<SalePerformanceReportItem> salePerformanceReportItemList) {
        BaseEntity saleItem;
        String itemId;
        if (CollectionUtils.isNotEmpty(salePerformanceReportItemList)) {
            for (SalePerformanceReportItem entity : salePerformanceReportItemList) {
                entity.setHeadId(saleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleHead);
            }
            this.salePerformanceReportItemMapper.insertBatchSomeColumn(salePerformanceReportItemList);
        }
        Map<String, String> idMap = salePerformanceReportItemList.stream().collect(Collectors.toMap(SalePerformanceReportItem::getRelationId, BaseEntity::getId));
        List<PurchasePerformanceReportGrad> reportGrads = this.purchasePerformanceReportGradMapper.selectByMainId(saleHead.getRelationId());
        List<PurchasePerformanceReportItemGrad> itemGradList = this.purchasePerformanceReportItemGradMapper.selectByMainId(saleHead.getRelationId());
        ArrayList<BaseEntity> salePerformanceReportGrads = new ArrayList<BaseEntity>();
        ArrayList<BaseEntity> salePerformanceReportItemGradList = new ArrayList<BaseEntity>();
        for (PurchasePerformanceReportGrad purchasePerformanceReportGrad : reportGrads) {
            itemId = purchasePerformanceReportGrad.getId();
            saleItem = new SalePerformanceReportGrad();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportGrad), (Object)saleItem);
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(itemId);
            salePerformanceReportGrads.add(saleItem);
        }
        for (PurchasePerformanceReportItemGrad purchasePerformanceReportItemGrad : itemGradList) {
            itemId = purchasePerformanceReportItemGrad.getId();
            saleItem = new SalePerformanceReportItemGrad();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportItemGrad), (Object)saleItem);
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(itemId);
            saleItem.setPerformanceReportItemId(idMap.get(purchasePerformanceReportItemGrad.getPerformanceReportItemId()));
            salePerformanceReportItemGradList.add(saleItem);
        }
        this.salePerformanceReportItemGradMapper.insertBatchSomeColumn(salePerformanceReportItemGradList);
        this.salePerformanceReportGradMapper.insertBatchSomeColumn(salePerformanceReportGrads);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.salePerformanceReportItemMapper.deleteByMainId(id);
        this.salePerformanceReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.salePerformanceReportItemMapper.deleteByMainId(serializable.toString());
            this.salePerformanceReportHeadMapper.deleteById(serializable);
        }
    }
}

