/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierAccessPolicy;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.service.SupplierAccessPolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165\u7b56\u7565"})
@RestController
@RequestMapping(value={"/supplier/supplierAccessPolicy"})
public class SupplierAccessPolicyController
extends BaseController<SupplierAccessPolicy, SupplierAccessPolicyService> {
    @Autowired
    private SupplierAccessPolicyService supplierAccessPolicyService;
    @Autowired
    private SupplierAccessHeadMapper supplierAccessHeadMapper;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SupplierAccessPolicy supplierAccessPolicy, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessPolicy), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.orderByDesc((Object)"update_time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierAccessPolicyService.page((IPage)page, (Wrapper)queryWrapper);
        List accessPolicies = pageList.getRecords();
        if (accessPolicies != null) {
            for (SupplierAccessPolicy policy : accessPolicies) {
                List<SupplierAccessHead> accessHeads = this.supplierAccessHeadMapper.getByRelationId(policy.getId());
                if (accessHeads == null || accessHeads.size() <= 0) continue;
                policy.setUsed("1");
            }
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u7b56\u7565", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SupplierAccessPolicy supplierAccessPolicy) {
        this.supplierAccessPolicyService.saveSupplierAccessPolicy(supplierAccessPolicy);
        return Result.ok((Object)((Object)supplierAccessPolicy));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u7b56\u7565", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SupplierAccessPolicy supplierAccessPolicy) {
        List<SupplierAccessHead> accessHeads = this.supplierAccessHeadMapper.getByRelationId(supplierAccessPolicy.getId());
        if (accessHeads != null && accessHeads.size() > 0) {
            return Result.error((String)"\u5df2\u88ab\u4f7f\u7528\u7684\u51c6\u5165\u7b56\u7565\u4e0d\u80fd\u88ab\u4fee\u6539");
        }
        this.supplierAccessPolicyService.updateSupplierAccessPolicy(supplierAccessPolicy);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        List<SupplierAccessHead> accessHeads = this.supplierAccessHeadMapper.getByRelationId(id);
        if (accessHeads != null && accessHeads.size() > 0) {
            return Result.error((String)"\u5df2\u88ab\u4f7f\u7528\u7684\u51c6\u5165\u7b56\u7565\u4e0d\u80fd\u5220\u9664");
        }
        this.supplierAccessPolicyService.delSupplierAccessPolicy(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u7b56\u7565", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.supplierAccessPolicyService.delBatchSupplierAccessPolicy(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SupplierAccessPolicy supplierAccessPolicy = (SupplierAccessPolicy)((Object)this.supplierAccessPolicyService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)supplierAccessPolicy));
    }

    @ApiOperation(value="\u662f\u5426\u88ab\u4f7f\u7528\u8fc7", notes="\u662f\u5426\u88ab\u4f7f\u7528\u8fc7")
    @GetMapping(value={"/isUsed"})
    public Result<?> isUsed(@RequestParam(name="id", required=true) String id) {
        List<SupplierAccessHead> accessHeads = this.supplierAccessHeadMapper.getByRelationId(id);
        if (accessHeads != null && accessHeads.size() > 0) {
            return Result.error((String)"\u5df2\u88ab\u4f7f\u7528\u7684\u51c6\u5165\u7b56\u7565\u4e0d\u80fd\u518d\u6b21\u88ab\u7f16\u8f91/\u5220\u9664");
        }
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u67e5\u8be2\u552f\u4e00", notes="\u67e5\u8be2\u552f\u4e00")
    @PostMapping(value={"/queryUnique"})
    public Result<?> queryUnique(@RequestBody SupplierAccessPolicy supplierAccessPolicy) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"cate_code", (Object)supplierAccessPolicy.getCateCode());
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"purchase_org", (Object)supplierAccessPolicy.getPurchaseOrg());
        wrapper.eq((Object)"access_type", (Object)supplierAccessPolicy.getAccessType());
        List accessPolicies = this.supplierAccessPolicyService.list((Wrapper)wrapper);
        if (!accessPolicies.isEmpty() && !((SupplierAccessPolicy)((Object)accessPolicies.get(0))).getId().equals(supplierAccessPolicy.getId())) {
            return Result.error((String)((supplierAccessPolicy.getAccessType().equals("0") ? "\u65b0\u5efa" : "\u62d3\u5c55") + "\u7c7b\u578b\u4e0b" + supplierAccessPolicy.getPurchaseOrg() + "\u7684" + supplierAccessPolicy.getCateCode() + "_" + supplierAccessPolicy.getCateName() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u6b21\u4fdd\u5b58"));
        }
        return Result.ok();
    }
}

