/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierCertificatedInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.service.SupplierAccessHeadService;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierCertificatedInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.service.SupplierOrgInfoService;
import com.els.modules.supplier.vo.EnterpriseInfoVo;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.modules.supplier.vo.RiskVO;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.supplier.vo.SupplierSearchVO;
import com.els.modules.supplier.vo.SupplyExtendVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierMaster"})
@Api(tags={"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e"})
public class SupplierMasterDataController
extends BaseController<SupplierMasterData, SupplierMasterDataService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataController.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierCertificatedInfoService supplierCertificatedInfoService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private SupplierOrgInfoService supplierOrgInfoService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierInvokeEnterpriseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SupplierAccessHeadService supplierAccessHeadService;
    @Autowired
    private RiskService riskService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String frozenFunctionValue = null;
        for (String string : keys) {
            if (!"frozenFunctionValue".equals(string) || parameters.get(string) == null) continue;
            frozenFunctionValue = ((String[])parameters.get(string))[0];
        }
        System.out.println("19:55");
        System.out.println(123141);
        if (StringUtils.isNotBlank(frozenFunctionValue)) {
            queryWrapper.notLike((Object)"frozen_function", frozenFunctionValue);
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryMasterDataList"})
    public Result<?> queryMasterDataList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataPage), (Object)((Object)supplierMasterData));
        this.supplierMasterDataService.saveMain(supplierMasterData, supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterData));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataPage), (Object)((Object)supplierMasterData));
        this.supplierMasterDataService.updateMain(supplierMasterData, supplierMasterDataPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierMasterDataService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierMasterDataService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierMasterDataService.getDataById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/querySupplierAddressInfoByMainId"})
    public Result<?> querySupplierAddressInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAddressInfo> supplierAddressInfoList = this.supplierAddressInfoService.selectByMainId(id);
        return Result.ok(supplierAddressInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/querySupplierBankInfoByMainId"})
    public Result<?> querySupplierBankInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierBankInfo> supplierBankInfoList = this.supplierBankInfoService.selectByMainId(id);
        return Result.ok(supplierBankInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f")
    @GetMapping(value={"/querySupplierCertificatedInfoByMainId"})
    public Result<?> querySupplierCertificatedInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierCertificatedInfo> supplierCertificatedInfoList = this.supplierCertificatedInfoService.selectByMainId(id);
        return Result.ok(supplierCertificatedInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/querySupplierContactsInfoByMainId"})
    public Result<?> querySupplierContactsInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierContactsInfo> supplierContactsInfoList = this.supplierContactsInfoService.selectByMainId(id);
        return Result.ok(supplierContactsInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/querySupplierOrgInfoByMainId"})
    public Result<?> querySupplierOrgInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierOrgInfo> supplierOrgInfoList = this.supplierOrgInfoService.selectByMainId(id);
        return Result.ok(supplierOrgInfoList);
    }

    public SupplierMasterDataVO queryByElsAccount(String elsAccount) {
        String currentAccount = TenantContext.getTenant();
        if (StringUtils.isBlank((CharSequence)elsAccount)) {
            elsAccount = currentAccount;
        }
        SupplierMasterDataVO supplierMasterDataVO = new SupplierMasterDataVO();
        if (!currentAccount.equals("100000") && !currentAccount.equals(elsAccount)) {
            SupplierMasterData supplierMasterData = this.supplierMasterDataService.getByAccount(currentAccount, elsAccount);
            BeanUtils.copyProperties((Object)((Object)supplierMasterData), (Object)((Object)supplierMasterDataVO));
        }
        String toELsAccount = null;
        if (!currentAccount.equals(elsAccount) && !currentAccount.equals("100000")) {
            toELsAccount = currentAccount;
        }
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierAddressInfoList(addressInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierBankInfoList(bankInfo);
        List<SupplierOrgInfo> orgInfo = this.supplierOrgInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierOrgInfoList(orgInfo);
        return supplierMasterDataVO;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryByEnterpriseId"})
    public Result<?> queryByEnterpriseId(@RequestParam(name="id") String id) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getById(id);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        String elsAccount = elsEnterpriseInfo.getElsAccount();
        SupplierMasterDataVO supplierMasterDataVO = this.queryByElsAccount(elsAccount);
        if (supplierMasterDataVO != null) {
            enterpriseInfoVo.setSupplierAddressInfoList(supplierMasterDataVO.getSupplierAddressInfoList());
            enterpriseInfoVo.setSupplierBankInfoList(supplierMasterDataVO.getSupplierBankInfoList());
            enterpriseInfoVo.setSupplierOrgInfoList(supplierMasterDataVO.getSupplierOrgInfoList());
            enterpriseInfoVo.setSupplierContactsInfoList(supplierMasterDataVO.getSupplierContactsInfoList());
        }
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @AutoLog(value="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f-\u66f4\u65b0\u4f01\u4e1a\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u4f01\u4e1a\u4fe1\u606f", notes="\u66f4\u65b0\u4f01\u4e1a\u4fe1\u606f")
    @PostMapping(value={"/updateEnterpriseInfoVO"})
    public Result<?> updateEnterpriseInfoVO(@RequestBody EnterpriseInfoVo enterpriseInfoVo) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = new ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)elsEnterpriseInfo);
        this.supplierMasterDataService.updateMainByEnterprise(elsEnterpriseInfo, enterpriseInfoVo.getSupplierAddressInfoList(), enterpriseInfoVo.getSupplierBankInfoList(), enterpriseInfoVo.getSupplierCertificatedInfoList(), enterpriseInfoVo.getSupplierContactsInfoList(), enterpriseInfoVo.getSupplierOrgInfoList());
        return Result.ok((Object)elsEnterpriseInfo);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u4ee3\u6ce8\u518c")
    @ApiOperation(value="\u4ee3\u6ce8\u518c", notes="\u4ee3\u6ce8\u518c")
    @PostMapping(value={"/replaceRegister"})
    public Result<?> replaceRegister(@RequestBody RegisterVO registerVO) {
        if (StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)registerVO.getContactsName())) {
            registerVO.setContactsName(registerVO.getCompanyName());
        }
        if (StringUtils.isBlank((CharSequence)registerVO.getPassword())) {
            registerVO.setPassword("123456");
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryCurrentEnterprise"})
    public Result<?> queryCurrentEnterprise() {
        String currentAccount = TenantContext.getTenant();
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(currentAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierAddressInfoList(addressInfo);
        List<SupplierCertificatedInfo> certificatedInfo = this.supplierCertificatedInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierCertificatedInfoList(certificatedInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierBankInfoList(bankInfo);
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/supplierlist"})
    public Result<?> supplierlist(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f")
    @GetMapping(value={"/querySupplierData"})
    public Result<?> querySupplierData(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        IPage<SupplierMasterData> pageList = this.supplierMasterDataService.pageSupplierDataByToElsAccount(pageNo, pageSize, TenantContext.getTenant());
        List records = pageList.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return Result.ok(pageList);
        }
        List<String> account = records.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> dtos = this.supplierInvokeEnterpriseRpcService.queryByElsAccountList(account);
        if (CollUtil.isNotEmpty(dtos)) {
            Map<String, String> map = dtos.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsEnterpriseInfoDTO::getName, (v1, v2) -> v2));
            for (SupplierMasterData data : pageList.getRecords()) {
                data.setName(map.get(data.getElsAccount()));
            }
        }
        return Result.ok(pageList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6ce8\u518c")
    @ApiOperation(value="\u6ce8\u518c", notes="\u6ce8\u518c")
    @PostMapping(value={"/register"})
    public Result<?> register(@RequestBody RegisterVO registerVO) {
        if (StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)registerVO.getPhoneNumber())) {
            return Result.error((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)registerVO.getNoteCode())) {
            return Result.error((String)"\u624b\u673a\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Object code = this.redisUtil.get(registerVO.getPhoneNumber());
        if (!registerVO.getNoteCode().equals(code)) {
            return Result.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0", notes="\u4f9b\u5e94\u5546\u53d1\u73b0")
    @GetMapping(value={"/searchSupplier"})
    public Result<?> searchSupplier(SupplierSearchVO searchVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.searchSupplier(searchVO, pageNo, pageSize));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6", notes="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6")
    @GetMapping(value={"/search"})
    public Result<?> search(SupplierSearchVO searchVO) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.search(searchVO));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/queryEnterprise"})
    public Result<?> queryEnterprise(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="name") String name) {
        return Result.ok((Object)this.supplierMasterDataService.queryEnterprise(elsAccount, name));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u8f6c\u6f5c")
    @ApiOperation(value="\u8f6c\u6f5c", notes="\u8f6c\u6f5c")
    @PostMapping(value={"/unfamiliarToPotential"})
    public Result<?> unfamiliarToPotential(@RequestBody RegisterVO registerVO) {
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        return this.supplierMasterDataService.unfamiliarToPotential(registerVO);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599")
    @GetMapping(value={"/certificatedInfo"})
    public Result<?> certificatedInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            result.setResult(this.supplierCertificatedInfoService.selectByMainId(masterData.getId()));
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/baseInfo"})
    public Result<?> baseInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        return this.queryEnterprise(toElsAccount, null);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4")
    @GetMapping(value={"/supplyExtend"})
    public Result<?> supplyExtend(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            SupplyExtendVO extendVO = new SupplyExtendVO();
            extendVO.setOrgInfos(this.supplierOrgInfoService.selectByMainId(masterData.getId()));
            if (StringUtils.isNotBlank((CharSequence)masterData.getAccessCategory())) {
                extendVO.setAccessCategroy(masterData.getAccessCategory().split(";"));
            }
            result.setResult((Object)extendVO);
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getContractInfo"})
    public Result<?> getContractInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)elsAccount);
        });
        IPage pageList = this.supplierContactsInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5730\u5740\u4fe1\u606f", notes="\u83b7\u53d6\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/getAddressInfo"})
    public Result<?> getAddressInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)elsAccount);
        });
        IPage pageList = this.supplierAddressInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f", notes="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/getBankInfo"})
    public Result<?> getBankInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)elsAccount);
        });
        IPage pageList = this.supplierBankInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u98ce\u9669\u67e5\u8be2", notes="\u98ce\u9669\u67e5\u8be2")
    @PostMapping(value={"/queryRisk"})
    public Result<?> queryRisk(@RequestBody RiskVO riskVO) {
        return this.riskService.queryRisk(riskVO);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f", notes="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/updateBaseInfo"})
    public Result<?> updateBaseInfo(@RequestBody SupplierMasterData supplierMasterData) {
        return this.supplierMasterDataService.updateBaseInfo(supplierMasterData);
    }
}

