/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierAddressDataExcelHandler")
public class SupplierAddressDataExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;

    public void importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierAddressInfo> addressInfos = new ArrayList<SupplierAddressInfo>();
        for (Map<String, Object> data : dataList) {
            ElsEnterpriseInfoDTO enterpriseInfo;
            SupplierAddressInfo entity = (SupplierAddressInfo)((Object)JSON.parseObject((String)JSON.toJSONString(data), SupplierAddressInfo.class));
            if (StringUtils.isBlank((CharSequence)entity.getElsAccount()) || (enterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(entity.getElsAccount())) == null) continue;
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            addressInfos.add(entity);
        }
        this.supplierAddressInfoService.saveBatch(addressInfos);
    }
}

