/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierContactsExcelHandler")
public class SupplierContactsExcelHandler
implements ExcelImportRpcService {
    private static final Pattern CHINA_PATTERN = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");
    private static final String DEFUALT_PASSWORD = "123456";
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;
    @Resource
    private ImGroupInvokeRpcService imGroupInvokeRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierContactsInfo> contactsInfos = new ArrayList<SupplierContactsInfo>();
        HashMap<String, SupplierContactsInfo> map = new HashMap<String, SupplierContactsInfo>();
        HashMap<String, Map<String, String>> roleMaps = new HashMap<String, Map<String, String>>();
        int i = 1;
        for (Map<String, Object> data : dataList) {
            ElsSubAccountDTO subAccount;
            ElsEnterpriseInfoDTO enterpriseInfo;
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)JSON.parseObject((String)JSON.toJSONString(data), SupplierContactsInfo.class));
            if (StringUtils.isBlank((CharSequence)entity.getElsAccount()) || (enterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(entity.getElsAccount())) == null || StringUtils.isBlank((CharSequence)entity.getSubAccount()) || StringUtils.isBlank((CharSequence)entity.getName())) continue;
            if (StringUtils.isNotBlank((CharSequence)entity.getTelphone())) {
                Assert.isTrue((boolean)CHINA_PATTERN.matcher(entity.getTelphone()).matches(), (String)I18nUtil.translate((String)"", (String)("\u7b2c" + i + "\u884c\u6570\u636e\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef")));
            }
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            contactsInfos.add(entity);
            if (!map.containsKey(entity.getElsAccount() + "_" + entity.getSubAccount()) && (subAccount = this.supplierInvokeAccountRpcService.getAccount(entity.getElsAccount(), entity.getSubAccount())) == null) {
                map.put(entity.getElsAccount() + "_" + entity.getSubAccount(), entity);
            }
            if (!roleMaps.containsKey(entity.getElsAccount())) {
                TenantContext.setTenant((String)entity.getElsAccount());
                List<RoleDTO> roleList = this.supplierInvokeAccountRpcService.getAllRole();
                Map<String, String> roleMap = roleList.stream().collect(Collectors.toMap(RoleDTO::getRoleCode, RoleDTO::getId));
                roleMaps.put(entity.getElsAccount(), roleMap);
            }
            ++i;
        }
        ArrayList<ElsSubAccountDTO> elsSubAccounts = new ArrayList<ElsSubAccountDTO>();
        for (String sub : map.keySet()) {
            String elsAccount = sub.split("_")[0];
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)map.get(sub));
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(entity.getElsAccount());
            account.setSubAccount(entity.getSubAccount());
            account.setRealname(entity.getName());
            account.setPhone(entity.getTelphone());
            account.setEmail(entity.getEmail());
            account.setStatus(Integer.valueOf(1));
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)(entity.getElsAccount() + "_" + account.getSubAccount()), (String)(StringUtils.isNotBlank((CharSequence)account.getPhone()) ? account.getPhone() : DEFUALT_PASSWORD), (String)salt);
            account.setPassword(passwordEncode);
            account.setDeleted(CommonConstant.DEL_FLAG_0);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()))), (String)I18nUtil.translate((String)"", (String)(entity.getElsAccount() + "\u4f9b\u5e94\u5546\u7684" + entity.getSubAccount() + "\u7684\u89d2\u8272\u7f16\u7801\u4e0d\u6b63\u786e")));
            account = this.supplierInvokeAccountRpcService.addUserWithRole(account, (String)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()));
            elsSubAccounts.add(account);
        }
        this.supplierContactsInfoService.saveBatch(contactsInfos);
        List userIdList = elsSubAccounts.stream().map(BaseDTO::getId).collect(Collectors.toList());
        this.imGroupInvokeRpcService.initGroupBatch(userIdList);
    }
}

