/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.SaleCertificatedInfo;
import com.els.modules.supplier.mapper.PurchaseCertificatedInfoMapper;
import com.els.modules.supplier.mapper.PurchaseStandardHeadMapper;
import com.els.modules.supplier.mapper.SaleCertificatedInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCertificatedInfoServiceImpl
extends BaseServiceImpl<PurchaseCertificatedInfoMapper, PurchaseCertificatedInfo>
implements PurchaseCertificatedInfoService {
    @Autowired
    private PurchaseCertificatedInfoMapper purchaseCertificatedInfoMapper;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private SaleCertificatedInfoMapper saleCertificatedInfoMapper;
    @Autowired
    private PurchaseStandardHeadMapper purchaseStandardHeadMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        purchaseCertificatedInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseCertificatedInfo.setSendStatus("0");
        purchaseCertificatedInfo.setFail("0");
        purchaseCertificatedInfo.setCreateAccount(TenantContext.getTenant());
        if (StringUtils.isBlank((CharSequence)purchaseCertificatedInfo.getPurchaseName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            purchaseCertificatedInfo.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)purchaseCertificatedInfo.getSupplierName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(purchaseCertificatedInfo.getToElsAccount())) != null) {
            purchaseCertificatedInfo.setSupplierName(enterpriseInfo.getName());
        }
        this.purchaseCertificatedInfoMapper.insert((Object)purchaseCertificatedInfo);
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseCertificatedInfo.getId());
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    private void insertData(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseCertificatedInfo.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseCertificatedInfo);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseStandardHead standardHead;
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)certificatedInfo.getShiftToId()) && (standardHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadMapper.selectById((Serializable)((Object)certificatedInfo.getShiftToId())))) != null) {
            standardHead.setShiftTo("0");
            this.purchaseStandardHeadMapper.updateById((Object)standardHead);
        }
        this.invokeBaseRpcService.deletePurchaseAttachment(id);
        this.purchaseCertificatedInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachment(serializable.toString());
            this.purchaseCertificatedInfoMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> certificatedInfo(String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        List<PurchaseCertificatedInfo> certificatedInfos = this.purchaseCertificatedInfoMapper.getByAccount(elsAccount, toElsAccount);
        Result result = new Result();
        result.setResult(certificatedInfos);
        result.setSuccess(true);
        return result;
    }

    @Override
    public void send(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseCertificatedInfo.setSendStatus("1");
        SaleCertificatedInfo certificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)certificatedInfo));
        certificatedInfo.setElsAccount(purchaseCertificatedInfo.getToElsAccount());
        certificatedInfo.setToElsAccount(purchaseCertificatedInfo.getElsAccount());
        certificatedInfo.setRelationId(purchaseCertificatedInfo.getId());
        this.saleCertificatedInfoMapper.insert((Object)certificatedInfo);
        purchaseCertificatedInfo.setRelationId(certificatedInfo.getId());
        this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        if (purchaseAttachmentList != null) {
            AttachmentSendDTO sendDTO = new AttachmentSendDTO();
            sendDTO.setHeadId(purchaseCertificatedInfo.getId());
            sendDTO.setElsAccount(purchaseCertificatedInfo.getElsAccount());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(certificatedInfo.getId(), certificatedInfo.getElsAccount());
            sendDTO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendDTO, true);
        }
    }

    @Override
    public void loseEfficacy(String id) {
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoMapper.selectById((Serializable)((Object)id)));
        if (certificatedInfo != null) {
            certificatedInfo.setFail("1");
            this.purchaseCertificatedInfoMapper.updateById((Object)certificatedInfo);
            SaleCertificatedInfo saleCertificatedInfo = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)certificatedInfo.getRelationId())));
            saleCertificatedInfo.setFail(certificatedInfo.getFail());
            this.saleCertificatedInfoMapper.updateById((Object)saleCertificatedInfo);
        }
    }
}

