/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.config.mybatis.TenantContext;
import com.els.modules.appreciation.api.dto.ElsAppreciationServiceDTO;
import com.els.modules.appreciation.api.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.supplier.entity.SupplierAbnormal;
import com.els.modules.supplier.entity.SupplierActualControl;
import com.els.modules.supplier.entity.SupplierBankruptcy;
import com.els.modules.supplier.entity.SupplierCompanyHolding;
import com.els.modules.supplier.entity.SupplierCustomer;
import com.els.modules.supplier.entity.SupplierDishonest;
import com.els.modules.supplier.entity.SupplierHumanHolding;
import com.els.modules.supplier.entity.SupplierInvesttree;
import com.els.modules.supplier.entity.SupplierJingpin;
import com.els.modules.supplier.entity.SupplierJudicial;
import com.els.modules.supplier.entity.SupplierLawsuit;
import com.els.modules.supplier.entity.SupplierPunishment;
import com.els.modules.supplier.entity.SupplierPunishmentInfo;
import com.els.modules.supplier.entity.SupplierSupply;
import com.els.modules.supplier.entity.SupplierZhixinginfo;
import com.els.modules.supplier.enumerate.RiskTypeEnum;
import com.els.modules.supplier.mapper.SupplierAbnormalMapper;
import com.els.modules.supplier.mapper.SupplierActualControlMapper;
import com.els.modules.supplier.mapper.SupplierBankruptcyMapper;
import com.els.modules.supplier.mapper.SupplierCompanyHoldingMapper;
import com.els.modules.supplier.mapper.SupplierCustomerMapper;
import com.els.modules.supplier.mapper.SupplierDishonestMapper;
import com.els.modules.supplier.mapper.SupplierHumanHoldingMapper;
import com.els.modules.supplier.mapper.SupplierInvesttreeMapper;
import com.els.modules.supplier.mapper.SupplierJingpinMapper;
import com.els.modules.supplier.mapper.SupplierJudicialMapper;
import com.els.modules.supplier.mapper.SupplierLawsuitMapper;
import com.els.modules.supplier.mapper.SupplierPunishmentInfoMapper;
import com.els.modules.supplier.mapper.SupplierPunishmentMapper;
import com.els.modules.supplier.mapper.SupplierSupplyMapper;
import com.els.modules.supplier.mapper.SupplierZhixinginfoMapper;
import com.els.modules.supplier.rpc.service.SupplierCallInterfaceRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokceAppreciationRpcService;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.vo.EnterpriseRiskVO;
import com.els.modules.supplier.vo.RiskVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskServiceImpl
implements RiskService {
    private static final String NEW = "0";
    private static final String OLD = "1";
    @Autowired
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoService;
    @Autowired
    private SupplierCallInterfaceRpcService callInterfaceService;
    @Autowired
    private SupplierLawsuitMapper supplierLawsuitMapper;
    @Autowired
    private SupplierJudicialMapper supplierJudicialMapper;
    @Autowired
    private SupplierBankruptcyMapper supplierBankruptcyMapper;
    @Autowired
    private SupplierAbnormalMapper supplierAbnormalMapper;
    @Autowired
    private SupplierPunishmentMapper supplierPunishmentMapper;
    @Autowired
    private SupplierPunishmentInfoMapper supplierPunishmentInfoMapper;
    @Autowired
    private SupplierDishonestMapper supplierDishonestMapper;
    @Autowired
    private SupplierCustomerMapper supplierCustomerMapper;
    @Autowired
    private SupplierSupplyMapper supplierSupplyMapper;
    @Autowired
    private SupplierJingpinMapper supplierJingpinMapper;
    @Autowired
    private SupplierInvesttreeMapper supplierInvesttreeMapper;
    @Autowired
    private SupplierHumanHoldingMapper supplierHumanHoldingMapper;
    @Autowired
    private SupplierCompanyHoldingMapper supplierCompanyHoldingMapper;
    @Autowired
    private SupplierActualControlMapper supplierActualControlMapper;
    @Autowired
    private SupplierZhixinginfoMapper supplierZhixinginfoMapper;
    @Autowired
    private SupplierInvokceAppreciationRpcService elsAppreciationServiceService;

    @Override
    public Result<?> queryRisk(RiskVO riskVO) {
        ElsAppreciationServiceDTO appreciationService = this.elsAppreciationServiceService.getByElsAccountAndServiceType(TenantContext.getTenant(), AppreciationServiceTypeEnum.TIANYANCHA.getValue());
        if (appreciationService == null) {
            return Result.error((String)"\u98ce\u9669\u670d\u52a1\u672a\u5f00\u901a");
        }
        String consumAccount = appreciationService.getConsumAccount();
        String projectId = appreciationService.getProjectId();
        String projectKey = appreciationService.getProjectKey();
        String consumSubAccount = appreciationService.getConsumSubAccount();
        String appId = appreciationService.getAppId();
        String appSerect = appreciationService.getAppSerect();
        if (StringUtils.isBlank((CharSequence)riskVO.getRiskType())) {
            return Result.error((String)"\u98ce\u9669\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(riskVO.getElsAccount());
        if (enterpriseInfo == null) {
            return Result.error((String)"\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u98ce\u9669\u6570\u636e\u67e5\u8be2");
        }
        EnterpriseRiskVO enterpriseRiskVO = new EnterpriseRiskVO();
        BeanUtils.copyProperties((Object)enterpriseInfo, (Object)((Object)enterpriseRiskVO));
        if (RiskTypeEnum.LEGAL_RISK.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierLawsuitList(this.queryLawsuit(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setOldSupplierLawsuitList(this.queryLawsuit(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierJudicialList(this.queryJudicial(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setOldSupplierJudicialList(this.queryJudicial(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierBankruptcyList(this.queryBankruptcy(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierZhixinginfoList(this.queryZhixing(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierZhixinginfoList(this.queryZhixing(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierDishonestList(this.queryDishonest(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setOldSupplierDishonestList(this.queryDishonest(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
        }
        if (RiskTypeEnum.INDUSTRY_POSTION.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierCustomerList(this.queryCustomer(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierSupplyList(this.querySupply(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierJingpinList(this.queryJingpin(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
        }
        if (RiskTypeEnum.MANAGE_RISK.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierPunishmentInfoList(this.queryPunishmentInfo(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setOldSupplierPunishmentInfoList(this.queryPunishmentInfo(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierPunishmentList(this.queryPunishment(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierPunishmentList(this.queryPunishment(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierAbnormalList(this.queryAbnormal(riskVO, enterpriseInfo, NEW, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierAbnormalList(this.queryAbnormal(riskVO, enterpriseInfo, OLD, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
        }
        if (RiskTypeEnum.RELATION_FIND.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierInvesttreeList(this.queryInvesttree(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierHumanHoldingList(this.queryhumanHolding(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierCompanyHoldingList(this.queryCompanyHolding(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
            enterpriseRiskVO.setSupplierActualControlList(this.queryActualControl(riskVO, enterpriseInfo, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect));
        }
        return Result.ok((Object)((Object)enterpriseRiskVO));
    }

    public List<SupplierInvesttree> queryInvesttree(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> investtrees = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (investtrees = this.supplierInvesttreeMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return investtrees;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_investtree");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            investtrees = JSON.parseArray((String)jsonObject.getString("result"), SupplierInvesttree.class);
            for (SupplierInvesttree supplierInvesttree : investtrees) {
                supplierInvesttree.setElsAccount(enterpriseInfo.getElsAccount());
                supplierInvesttree.setHeadId(enterpriseInfo.getId());
                supplierInvesttree.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierInvesttree.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierInvesttreeMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierInvesttreeMapper.insertBatchSomeColumn(investtrees);
        }
        return investtrees;
    }

    public List<SupplierActualControl> queryActualControl(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> actualControls = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (actualControls = this.supplierActualControlMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return actualControls;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_actualControl_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            SupplierActualControl actualControl = (SupplierActualControl)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierActualControl.class));
            actualControl.setElsAccount(enterpriseInfo.getElsAccount());
            actualControl.setHeadId(enterpriseInfo.getId());
            actualControl.setDeleted(CommonConstant.DEL_FLAG_0);
            actualControl.setSupplierName(enterpriseInfo.getName());
            actualControls.add((Object)actualControl);
        }
        if (!actualControls.isEmpty()) {
            this.supplierActualControlMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierActualControlMapper.insertBatchSomeColumn(actualControls);
        }
        return actualControls;
    }

    public List<SupplierCompanyHolding> queryCompanyHolding(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> companyHoldings = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (companyHoldings = this.supplierCompanyHoldingMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return companyHoldings;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_companyholding");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            companyHoldings = JSON.parseArray((String)response.getResult().toString(), SupplierCompanyHolding.class);
            for (SupplierCompanyHolding supplierCompanyHolding : companyHoldings) {
                supplierCompanyHolding.setElsAccount(enterpriseInfo.getElsAccount());
                supplierCompanyHolding.setHeadId(enterpriseInfo.getId());
                supplierCompanyHolding.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierCompanyHolding.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierCompanyHoldingMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierCompanyHoldingMapper.insertBatchSomeColumn(companyHoldings);
        }
        return companyHoldings;
    }

    public List<SupplierHumanHolding> queryhumanHolding(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> holdings = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (holdings = this.supplierHumanHoldingMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return holdings;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_humanholding_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            holdings = JSON.parseArray((String)response.getResult().toString(), SupplierHumanHolding.class);
            for (SupplierHumanHolding supplierHumanHolding : holdings) {
                supplierHumanHolding.setElsAccount(enterpriseInfo.getElsAccount());
                supplierHumanHolding.setHeadId(enterpriseInfo.getId());
                supplierHumanHolding.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierHumanHolding.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierHumanHoldingMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierHumanHoldingMapper.insertBatchSomeColumn(holdings);
        }
        return holdings;
    }

    public List<SupplierJingpin> queryJingpin(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> jingpins = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (jingpins = this.supplierJingpinMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return jingpins;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_findJingpin_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jingpins = JSON.parseArray((String)response.getResult().toString(), SupplierJingpin.class);
            for (SupplierJingpin supplierJingpin : jingpins) {
                supplierJingpin.setElsAccount(enterpriseInfo.getElsAccount());
                supplierJingpin.setHeadId(enterpriseInfo.getId());
                supplierJingpin.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierJingpin.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierJingpinMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierJingpinMapper.insertBatchSomeColumn(jingpins);
        }
        return jingpins;
    }

    public List<SupplierSupply> querySupply(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        SupplierSupply supply;
        JSONObject jsonObject;
        List<Object> supplies = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (supplies = this.supplierSupplyMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return supplies;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        Calendar rightNow = Calendar.getInstance();
        object.put("year", (Object)(rightNow.get(1) - 1));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_supply_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 1));
            supplies.add((Object)supply);
        }
        object.put("year", (Object)(rightNow.get(1) - 2));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_supply_2.0");
        response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 2));
            supplies.add((Object)supply);
        }
        object.put("year", (Object)(rightNow.get(1) - 3));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_supply_2.0");
        response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 3));
            supplies.add((Object)supply);
        }
        if (!supplies.isEmpty()) {
            this.supplierSupplyMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierSupplyMapper.insertBatchSomeColumn(supplies);
        }
        return supplies;
    }

    public List<SupplierCustomer> queryCustomer(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        SupplierCustomer customer;
        JSONObject jsonObject;
        List<Object> customers = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (customers = this.supplierCustomerMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return customers;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        Calendar rightNow = Calendar.getInstance();
        object.put("year", (Object)(rightNow.get(1) - 1));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_customer_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 1));
            customers.add((Object)customer);
        }
        object.put("year", (Object)(rightNow.get(1) - 2));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_customer_2.0");
        response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 2));
            customers.add((Object)customer);
        }
        object.put("year", (Object)(rightNow.get(1) - 3));
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_customer_2.0");
        response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.getString("result"), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 3));
            customers.add((Object)customer);
        }
        if (!customers.isEmpty()) {
            this.supplierCustomerMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierCustomerMapper.insertBatchSomeColumn(customers);
        }
        return customers;
    }

    public List<SupplierDishonest> queryDishonest(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List dishonests = this.supplierDishonestMapper.selectList((Wrapper)wrapper);
            if (dishonests.size() > 0) {
                return dishonests;
            }
        }
        return this.updateDishonest(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierDishonest> updateDishonest(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierDishonest> dishonests = new ArrayList<SupplierDishonest>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyan_dishonest");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_dishonest_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            dishonests = JSON.parseArray((String)response.getResult().toString(), SupplierDishonest.class);
            for (SupplierDishonest dishonest : dishonests) {
                dishonest.setElsAccount(elsAccount);
                dishonest.setHeadId(enterpriseId);
                dishonest.setDeleted(CommonConstant.DEL_FLAG_0);
                dishonest.setDistinction(version);
                dishonest.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierDishonestMapper.delete((Wrapper)wrapper);
            this.supplierDishonestMapper.insertBatchSomeColumn(dishonests);
        }
        return dishonests;
    }

    public List<SupplierPunishmentInfo> queryPunishmentInfo(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List punishmentInfos = this.supplierPunishmentInfoMapper.selectList((Wrapper)wrapper);
            if (punishmentInfos.size() > 0) {
                return punishmentInfos;
            }
        }
        return this.updatePunishmentInfo(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierPunishmentInfo> updatePunishmentInfo(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierPunishmentInfo> punishmentInfos = new ArrayList<SupplierPunishmentInfo>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyanCheck_punishmentInfo_2.0");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_punishment_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            punishmentInfos = JSON.parseArray((String)response.getResult().toString(), SupplierPunishmentInfo.class);
            for (SupplierPunishmentInfo punishmentInfo : punishmentInfos) {
                punishmentInfo.setElsAccount(elsAccount);
                punishmentInfo.setHeadId(enterpriseId);
                punishmentInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                punishmentInfo.setDistinction(version);
                punishmentInfo.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierPunishmentInfoMapper.delete((Wrapper)wrapper);
            this.supplierPunishmentInfoMapper.insertBatchSomeColumn(punishmentInfos);
        }
        return punishmentInfos;
    }

    public List<SupplierPunishment> queryPunishment(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List punishments = this.supplierPunishmentMapper.selectList((Wrapper)wrapper);
            if (punishments.size() > 0) {
                return punishments;
            }
        }
        return this.updatePunishment(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierPunishment> updatePunishment(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierPunishment> punishments = new ArrayList<SupplierPunishment>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyanCheck_history_creditChina_2.0");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_other_creditChina_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            punishments = JSON.parseArray((String)response.getResult().toString(), SupplierPunishment.class);
            for (SupplierPunishment punishment : punishments) {
                punishment.setElsAccount(elsAccount);
                punishment.setHeadId(enterpriseId);
                punishment.setDeleted(CommonConstant.DEL_FLAG_0);
                punishment.setDistinction(version);
                punishment.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierPunishmentMapper.delete((Wrapper)wrapper);
            this.supplierPunishmentMapper.insertBatchSomeColumn(punishments);
        }
        return punishments;
    }

    public List<SupplierAbnormal> queryAbnormal(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List abnormals = this.supplierAbnormalMapper.selectList((Wrapper)wrapper);
            if (abnormals.size() > 0) {
                return abnormals;
            }
        }
        return this.updateAbnromal(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierAbnormal> updateAbnromal(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierAbnormal> abnormals = new ArrayList<SupplierAbnormal>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyan_abnormal_2.0");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_abnormal_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            abnormals = JSON.parseArray((String)response.getResult().toString(), SupplierAbnormal.class);
            for (SupplierAbnormal abnormal : abnormals) {
                abnormal.setElsAccount(elsAccount);
                abnormal.setHeadId(enterpriseId);
                abnormal.setDeleted(CommonConstant.DEL_FLAG_0);
                abnormal.setDistinction(version);
                abnormal.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierAbnormalMapper.delete((Wrapper)wrapper);
            this.supplierAbnormalMapper.insertBatchSomeColumn(abnormals);
        }
        return abnormals;
    }

    public List<SupplierBankruptcy> queryBankruptcy(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<Object> bankruptcies = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (bankruptcies = this.supplierBankruptcyMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return bankruptcies;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("urlMap", (Object)object);
        requestObject.put("code", (Object)"tianyanCheck_bankruptcy_2.0");
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            bankruptcies = JSON.parseArray((String)response.getResult().toString(), SupplierBankruptcy.class);
            for (SupplierBankruptcy supplierBankruptcy : bankruptcies) {
                supplierBankruptcy.setElsAccount(enterpriseInfo.getElsAccount());
                supplierBankruptcy.setHeadId(enterpriseInfo.getId());
                supplierBankruptcy.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierBankruptcy.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierBankruptcyMapper.deleteByMainId(enterpriseInfo.getId());
            this.supplierBankruptcyMapper.insertBatchSomeColumn(bankruptcies);
        }
        return bankruptcies;
    }

    public List<SupplierZhixinginfo> queryZhixing(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List zhixinginfos = this.supplierZhixinginfoMapper.selectList((Wrapper)wrapper);
            if (zhixinginfos.size() > 0) {
                return zhixinginfos;
            }
        }
        return this.updateZhixing(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierZhixinginfo> updateZhixing(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierZhixinginfo> zhixinginfos = new ArrayList<SupplierZhixinginfo>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyan_zhixinginfo");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_zhixing_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            zhixinginfos = JSON.parseArray((String)response.getResult().toString(), SupplierZhixinginfo.class);
            for (SupplierZhixinginfo zhixinginfo : zhixinginfos) {
                zhixinginfo.setElsAccount(elsAccount);
                zhixinginfo.setHeadId(enterpriseId);
                zhixinginfo.setDeleted(CommonConstant.DEL_FLAG_0);
                zhixinginfo.setDistinction(version);
                zhixinginfo.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierZhixinginfoMapper.delete((Wrapper)wrapper);
            this.supplierZhixinginfoMapper.insertBatchSomeColumn(zhixinginfos);
        }
        return zhixinginfos;
    }

    public List<SupplierJudicial> queryJudicial(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List judicials = this.supplierJudicialMapper.selectList((Wrapper)wrapper);
            if (judicials.size() > 0) {
                return judicials;
            }
        }
        return this.updateJudicials(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierJudicial> updateJudicials(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierJudicial> judicials = new ArrayList<SupplierJudicial>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyanCheck_judicial");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_judicial_2.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            judicials = JSON.parseArray((String)response.getResult().toString(), SupplierJudicial.class);
            for (SupplierJudicial judicial : judicials) {
                judicial.setElsAccount(elsAccount);
                judicial.setHeadId(enterpriseId);
                judicial.setDeleted(CommonConstant.DEL_FLAG_0);
                judicial.setDistinction(version);
                judicial.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierJudicialMapper.delete((Wrapper)wrapper);
            this.supplierJudicialMapper.insertBatchSomeColumn(judicials);
        }
        return judicials;
    }

    public List<SupplierLawsuit> queryLawsuit(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List lawsuits = this.supplierLawsuitMapper.selectList((Wrapper)wrapper);
            if (lawsuits.size() > 0) {
                return lawsuits;
            }
        }
        return this.updateLawsuit(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
    }

    public List<SupplierLawsuit> updateLawsuit(String companyName, String enterpriseId, String elsAccount, String version, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        List<SupplierLawsuit> lawsuits = new ArrayList<SupplierLawsuit>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("urlMap", (Object)object);
        if (NEW.equals(version)) {
            requestObject.put("code", (Object)"tianyanCheck_lawSuit_3.0");
        } else {
            requestObject.put("code", (Object)"tianyanCheck_history_lawSuit_3.0");
        }
        Result<?> response = this.callInterfaceService.callTianYanCommonPost(requestObject, consumAccount, projectId, projectKey, consumSubAccount, appId, appSerect);
        if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage())) {
            lawsuits = JSON.parseArray((String)response.getResult().toString(), SupplierLawsuit.class);
            for (SupplierLawsuit supplierLawsuit : lawsuits) {
                supplierLawsuit.setElsAccount(elsAccount);
                supplierLawsuit.setHeadId(enterpriseId);
                supplierLawsuit.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierLawsuit.setDistinction(version);
                supplierLawsuit.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierLawsuitMapper.delete((Wrapper)wrapper);
            this.supplierLawsuitMapper.insertBatchSomeColumn(lawsuits);
        }
        return lawsuits;
    }
}

