/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierAccessItem;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.mapper.SupplierAccessItemMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SupplierAccessHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierAccessHeadServiceImpl
extends ServiceImpl<SupplierAccessHeadMapper, SupplierAccessHead>
implements SupplierAccessHeadService {
    @Autowired
    private SupplierAccessHeadMapper supplierAccessHeadMapper;
    @Autowired
    private SupplierAccessItemMapper supplierAccessItemMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        supplierAccessHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        supplierAccessHead.setAccessNumber(this.invokeBaseRpcService.getNextCode("access", (Object)supplierAccessHead));
        supplierAccessHead.setDeleted(0);
        this.supplierAccessHeadMapper.insert((Object)supplierAccessHead);
        this.insertData(supplierAccessHead, supplierAccessItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(supplierAccessHead.getAuditStatus())) {
            supplierAccessHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.supplierAccessHeadMapper.updateById((Object)supplierAccessHead);
        this.supplierAccessItemMapper.deleteByMainId(supplierAccessHead.getId());
        this.insertData(supplierAccessHead, supplierAccessItemList);
    }

    private void insertData(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        if (supplierAccessItemList != null) {
            for (SupplierAccessItem entity : supplierAccessItemList) {
                entity.setHeadId(supplierAccessHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierAccessHead);
                entity.setAccessName(supplierAccessHead.getAccessName());
                entity.setAccessNumber(supplierAccessHead.getAccessNumber());
            }
            if (!supplierAccessItemList.isEmpty()) {
                this.supplierAccessItemMapper.insertBatchSomeColumn(supplierAccessItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierAccessItemMapper.deleteByMainId(id);
        this.supplierAccessHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierAccessItemMapper.deleteByMainId(serializable.toString());
            this.supplierAccessHeadMapper.deleteById(serializable);
        }
    }
}

