/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.extra.mail.MailUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.modules.supplier.entity.SupplierInvitationCode;
import com.els.modules.supplier.enumerate.SupplierInvitationCodeStatusEnum;
import com.els.modules.supplier.mapper.SupplierInvitationCodeMapper;
import com.els.modules.supplier.service.SupplierInvitationCodeService;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SupplierInvitationCodeServiceImpl
extends ServiceImpl<SupplierInvitationCodeMapper, SupplierInvitationCode>
implements SupplierInvitationCodeService {
    @Autowired
    private SupplierInvitationCodeMapper supplierInvitationCodeMapper;
    @Value(value="${invitation.url}")
    private String url;
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveSupplierInvitationCode(SupplierInvitationCode supplierInvitationCode) {
        String invitationCode = this.getCode(ConvertUtils.randomGen((int)10));
        supplierInvitationCode.setInvitationCode(invitationCode);
        supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.UNCLAIMED.getValue());
        supplierInvitationCode.setDeleted(0);
        ((SupplierInvitationCodeMapper)this.baseMapper).insert((Object)supplierInvitationCode);
    }

    public String getCode(String code) {
        SupplierInvitationCode invitationCode = this.supplierInvitationCodeMapper.getByCode(code);
        if (invitationCode == null) {
            return code;
        }
        return this.getCode(ConvertUtils.randomGen((int)10));
    }

    @Override
    public void updateSupplierInvitationCode(SupplierInvitationCode supplierInvitationCode) {
        ((SupplierInvitationCodeMapper)this.baseMapper).updateById((Object)supplierInvitationCode);
    }

    @Override
    public void delSupplierInvitationCode(String id) {
        ((SupplierInvitationCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSupplierInvitationCode(List<String> idList) {
        ((SupplierInvitationCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> handleLock(SupplierInvitationCode supplierInvitationCode) {
        SupplierInvitationCode code = (SupplierInvitationCode)((Object)this.getById((Serializable)((Object)supplierInvitationCode.getId())));
        if (code != null) {
            if (SupplierInvitationCodeStatusEnum.UNCLAIMED.getValue() != code.getStatus().intValue()) {
                return Result.error((String)("\u8be5\u9080\u8bf7\u7801 " + SupplierInvitationCodeStatusEnum.getDesc(code.getStatus()) + "\uff0c\u4e0d\u80fd\u88ab\u9886\u53d6"));
            }
            SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
            String currentTime = dateStr.format(new Date());
            try {
                Date date = dateStr.parse(currentTime);
                if (date.getTime() > code.getEffectiveDate().getTime()) {
                    supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.LOSE_EFFICACY.getValue());
                    this.updateSupplierInvitationCode(supplierInvitationCode);
                    return Result.error((String)"\u8be5\u9080\u8bf7\u7801\u5df2\u8fc7\u6709\u6548\u671f\uff01");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            return Result.error((String)"\u8be5\u6761\u9080\u8bf7\u7801\u5df2\u88ab\u5220\u9664\uff01");
        }
        supplierInvitationCode.setStatus(SupplierInvitationCodeStatusEnum.RECEIVED.getValue());
        if (this.address.endsWith("/")) {
            MailUtil.send((String)code.getEmail(), (String)"\u9080\u8bf7\u7801\u9886\u53d6\u6210\u529f", (String)("\u9080\u8bf7\u6ce8\u518c\u94fe\u63a5\u4e3a\uff1a" + this.address + this.url + code.getInvitationCode()), (boolean)true, (File[])new File[0]);
        } else {
            MailUtil.send((String)code.getEmail(), (String)"\u9080\u8bf7\u7801\u9886\u53d6\u6210\u529f", (String)("\u9080\u8bf7\u6ce8\u518c\u94fe\u63a5\u4e3a\uff1a" + this.address + "/" + this.url + code.getInvitationCode()), (boolean)true, (File[])new File[0]);
        }
        this.updateSupplierInvitationCode(supplierInvitationCode);
        return Result.ok((String)("\u9080\u8bf7\u7801\u9886\u53d6\u5e76\u53d1\u9001" + code.getEmail() + "\u90ae\u7bb1\u9001\u6210\u529f\uff01"));
    }

    @Override
    public SupplierInvitationCode getByCode(String code) {
        return this.supplierInvitationCodeMapper.getByCode(code);
    }
}

