/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateEffectiveStatusEnum;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchasePerformanceTemplateImportServiceImpl")
public class PurchasePerformanceTemplateImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("performanceTemplate");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERtXIrESIr_e116aff4", (String)"\u8bf7\u5148\u914d\u7f6e\u7ee9\u6548\u6a21\u677f\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchasePerformanceTemplateHead> entityList = new ArrayList<PurchasePerformanceTemplateHead>();
        for (Map<String, Object> data : dataList) {
            PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchasePerformanceTemplateHead.class));
            head.setElsAccount(TenantContext.getTenant());
            head.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            head.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            head.setTemplateVersion(Integer.toString(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion()));
            head.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            head.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            head.setId(null);
            if ("0".equals(head.getTemplateRequiredAudit())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                if (null != head.getEffectiveDate() && head.getEffectiveDate().before((Date)DateUtil.date()) && !PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
                } else {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
                }
            } else {
                head.setTemplateRequiredAudit("1");
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                if (!PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                    head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
                }
            }
            entityList.add(head);
        }
        if (CollUtil.isEmpty(entityList)) {
            return;
        }
        PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)entityList.get(0));
        long size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("assessTemplateNumber", (Object)head, (int)size);
        int codeIndex = 0;
        for (PurchasePerformanceTemplateHead e : entityList) {
            e.setTemplateNumber((String)nextCodes.get(codeIndex++));
        }
        this.purchasePerformanceTemplateHeadService.saveBatch(entityList);
    }
}

