/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceNormHead;
import com.els.modules.performance.enumerate.PerformanceNormStatusEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormHeadMapper;
import com.els.modules.performance.service.PurchasePerformanceNormFormulaService;
import com.els.modules.performance.service.PurchasePerformanceNormGradService;
import com.els.modules.performance.service.PurchasePerformanceNormHeadService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceNormHeadServiceImpl
extends ServiceImpl<PurchasePerformanceNormHeadMapper, PurchasePerformanceNormHead>
implements PurchasePerformanceNormHeadService {
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).insert((Object)normHead);
        this.insertData(normHead, normGradList, normFormulaList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        normHead.setNormStatus(PerformanceNormStatusEnum.VALID.getValue());
        int count = ((PurchasePerformanceNormHeadMapper)this.baseMapper).updateById((Object)normHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchasePerformanceNormGradMapper.deleteByMainId(normHead.getId());
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(normHead.getId());
        this.insertData(normHead, normGradList, normFormulaList);
    }

    private void insertData(PurchasePerformanceNormHead normHead, List<PurchasePerformanceNormGrad> normGradList, List<PurchasePerformanceNormFormula> normFormulaList) {
        if (CollectionUtil.isNotEmpty(normGradList)) {
            for (PurchasePerformanceNormGrad normGrad : normGradList) {
                normGrad.setId(null);
                normGrad.setHeadId(normHead.getId());
                SysUtil.setSysParam((BaseEntity)normGrad, (BaseEntity)normHead);
            }
            ((PurchasePerformanceNormGradService)SpringContextUtils.getBean(PurchasePerformanceNormGradService.class)).saveBatch(normGradList);
        }
        if (CollectionUtil.isNotEmpty(normFormulaList)) {
            int itemNumber = 1;
            for (PurchasePerformanceNormFormula normFormula : normFormulaList) {
                normFormula.setId(null);
                normFormula.setItemNumber(String.valueOf(itemNumber++));
                normFormula.setHeadId(normHead.getId());
                normFormula.setNormNumber(normHead.getNormNumber());
                SysUtil.setSysParam((BaseEntity)normFormula, (BaseEntity)normHead);
            }
            ((PurchasePerformanceNormFormulaService)SpringContextUtils.getBean(PurchasePerformanceNormFormulaService.class)).saveBatch(normFormulaList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceNormGradMapper.deleteByMainId(id);
        this.purchasePerformanceNormFormulaMapper.deleteByMainId(id);
        ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePerformanceNormGradMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceNormFormulaMapper.deleteByMainId(serializable.toString());
            ((PurchasePerformanceNormHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

