/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.SqlRunnerExecuteService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.DateUtils;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportItemFormula;
import com.els.modules.performance.entity.PurchasePerformanceReportItemGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportTemplateHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateGrad;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemFormula;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemGrad;
import com.els.modules.performance.entity.SalePerformanceReportHead;
import com.els.modules.performance.entity.SalePerformanceReportItem;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceEvaluationTypeEnum;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.enumerate.PerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateStatusEnum;
import com.els.modules.performance.enumerate.PurchasePerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportTemplateHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemGradMapper;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemFormulaService;
import com.els.modules.performance.service.PurchasePerformanceReportItemGradService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.performance.vo.ReportComputeScoreVO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePerformanceReportHeadServiceImpl
extends BaseServiceImpl<PurchasePerformanceReportHeadMapper, PurchasePerformanceReportHead>
implements PurchasePerformanceReportHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReportHeadServiceImpl.class);
    @Resource
    private PurchasePerformanceReportHeadMapper purchasePerformanceReportHeadMapper;
    @Resource
    private PurchasePerformanceReportItemMapper purchasePerformanceReportItemMapper;
    @Resource
    private PurchasePerformanceTemplateGradMapper purchasePerformanceTemplateGradMapper;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Resource
    private SalePerformanceReportHeadService salePerformanceReportHeadService;
    @Resource
    private PurchasePerformanceReportGradMapper purchasePerformanceReportGradMapper;
    @Resource
    private PurchasePerformanceReportItemFormulaMapper purchasePerformanceReportItemFormulaMapper;
    @Resource
    private PurchasePerformanceReportItemGradMapper purchasePerformanceReportItemGradMapper;
    @Resource
    private PurchasePerformanceReportTemplateHeadMapper purchasePerformanceReportTemplateHeadMapper;
    @Resource
    private PurchasePerformanceTemplateHeadMapper purchasePerformanceTemplateHeadMapper;
    @Resource
    private PurchasePerformanceTemplateItemGradMapper purchasePerformanceTemplateItemGradMapper;
    @Resource
    private PurchasePerformanceTemplateItemFormulaMapper purchasePerformanceTemplateItemFormulaMapper;
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SqlRunnerExecuteService sqlRunnerExecuteService;
    @Autowired
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;

    private void buildReportTime(PurchasePerformanceReportHead head) {
        DateTime currentYear = DateUtil.beginOfYear((Date)DateUtil.date());
        PerformanceEvaluationTypeEnum cycle = PerformanceEvaluationTypeEnum.builder(head.getAssessmentCycle());
        String assessmentTimeRange = head.getAssessmentTimeRange();
        if (null == cycle || StrUtil.isBlank((CharSequence)assessmentTimeRange)) {
            return;
        }
        switch (cycle) {
            case YEAR: {
                head.setReportStartTime((Date)DateUtil.beginOfYear((Date)currentYear));
                head.setReportEndTime((Date)DateUtil.endOfYear((Date)currentYear));
                break;
            }
            case MONTH: {
                DateTime dateTime = DateUtil.offsetMonth((Date)currentYear, (int)Integer.parseInt(assessmentTimeRange));
                head.setReportStartTime((Date)DateUtil.beginOfMonth((Date)dateTime));
                head.setReportEndTime((Date)DateUtil.endOfMonth((Date)dateTime));
                break;
            }
            case QUARTER: {
                String[] dates = StrUtil.split((CharSequence)assessmentTimeRange, (CharSequence)"-");
                head.setReportStartTime((Date)DateUtil.beginOfMonth((Date)DateUtil.parse((CharSequence)dates[0], (String)"yyyy/MM")));
                head.setReportEndTime((Date)DateUtil.endOfMonth((Date)DateUtil.parse((CharSequence)dates[1], (String)"yyyy/MM")));
                break;
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        this.buildReportTime(head);
        this.purchasePerformanceReportHeadMapper.insert((Object)head);
        this.insertData(head, purchasePerformanceReportItemList);
        this.insertItemData(head, purchasePerformanceReportItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        this.buildReportTime(head);
        int count = this.purchasePerformanceReportHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        List<String> existItemIds = purchasePerformanceReportItemList.stream().map(BaseEntity::getId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.purchasePerformanceReportItemMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportItemGradMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceReportItemFormulaMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceReportGradMapper.deleteByMainId(head.getId());
        this.insertData(head, purchasePerformanceReportItemList);
        purchasePerformanceReportItemList = purchasePerformanceReportItemList.stream().filter(x -> !existItemIds.contains(x.getId())).collect(Collectors.toList());
        this.insertItemData(head, purchasePerformanceReportItemList);
    }

    private void insertItemData(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> reportItemList) {
        String performanceTemplateId = head.getPerformanceTemplateId();
        PurchasePerformanceTemplateHead templateHead = (PurchasePerformanceTemplateHead)((Object)this.purchasePerformanceTemplateHeadMapper.selectById((Serializable)((Object)performanceTemplateId)));
        if (null == templateHead) {
            return;
        }
        PurchasePerformanceReportTemplateHead reportTemplateHead = (PurchasePerformanceReportTemplateHead)((Object)Convert.convert(PurchasePerformanceReportTemplateHead.class, (Object)((Object)templateHead)));
        reportTemplateHead.setId(null);
        reportTemplateHead.setHeadId(head.getId());
        SysUtil.setSysParam((BaseEntity)reportTemplateHead, (BaseEntity)head);
        Map<String, List<PurchasePerformanceReportItemDto>> sourceItemMap = reportItemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItemDto::getSourceType));
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        List<PurchasePerformanceReportItemDto> normItemList = sourceItemMap.get("1");
        this.buildNormItemData(itemGradList, itemFormulaList, normItemList);
        List<PurchasePerformanceReportItemDto> templateItemList = sourceItemMap.get("2");
        this.buildTemplateItemData(itemGradList, itemFormulaList, templateItemList, performanceTemplateId);
        List<PurchasePerformanceTemplateGrad> templateGradList = this.purchasePerformanceTemplateGradMapper.selectByMainId(performanceTemplateId);
        List<PurchasePerformanceReportGrad> gradList = this.buildGradData(head, templateGradList);
        this.purchasePerformanceReportTemplateHeadMapper.insert((Object)reportTemplateHead);
        if (CollUtil.isNotEmpty(gradList)) {
            ((PurchasePerformanceReportGradService)SpringContextUtils.getBean(PurchasePerformanceReportGradService.class)).saveBatch(gradList);
        }
        if (CollUtil.isNotEmpty(itemGradList)) {
            ((PurchasePerformanceReportItemGradService)SpringContextUtils.getBean(PurchasePerformanceReportItemGradService.class)).saveBatch(itemGradList);
        }
        if (CollUtil.isNotEmpty(itemFormulaList)) {
            ((PurchasePerformanceReportItemFormulaService)SpringContextUtils.getBean(PurchasePerformanceReportItemFormulaService.class)).saveBatch(itemFormulaList);
        }
    }

    private List<PurchasePerformanceReportGrad> buildGradData(PurchasePerformanceReportHead head, List<PurchasePerformanceTemplateGrad> templateGradList) {
        if (CollUtil.isEmpty(templateGradList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportGrad> gradList = new ArrayList<PurchasePerformanceReportGrad>();
        for (PurchasePerformanceTemplateGrad grad : templateGradList) {
            PurchasePerformanceReportGrad tem = (PurchasePerformanceReportGrad)((Object)Convert.convert(PurchasePerformanceReportGrad.class, (Object)((Object)grad)));
            tem.setHeadId(head.getId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)head);
            tem.setId(null);
            gradList.add(tem);
        }
        return gradList;
    }

    private void buildNormItemData(List<PurchasePerformanceReportItemGrad> gradList, List<PurchasePerformanceReportItemFormula> formulaList, List<PurchasePerformanceReportItemDto> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<String> normIds = itemList.stream().map(PurchasePerformanceReportItem::getNormId).collect(Collectors.toList());
        if (CollUtil.isEmpty(normIds)) {
            return;
        }
        Map<String, List<PurchasePerformanceNormGrad>> normGradMap = this.queryNormGradMap(normIds);
        Map<String, List<PurchasePerformanceNormFormula>> normFormulaMap = this.queryNormFormulaMap(normIds);
        for (PurchasePerformanceReportItemDto entity : itemList) {
            List<PurchasePerformanceNormFormula> formulas;
            List<PurchasePerformanceNormGrad> grads = normGradMap.get(entity.getNormId());
            if (CollUtil.isNotEmpty(grads)) {
                List<PurchasePerformanceReportItemGrad> itemGrads = this.normConvertToItemGrad(grads, entity);
                gradList.addAll(itemGrads);
            }
            if (!CollUtil.isNotEmpty(formulas = normFormulaMap.get(entity.getNormId()))) continue;
            List<PurchasePerformanceReportItemFormula> itemGrads = this.normConvertToItemFormula(formulas, entity);
            formulaList.addAll(itemGrads);
        }
    }

    private void buildTemplateItemData(List<PurchasePerformanceReportItemGrad> gradList, List<PurchasePerformanceReportItemFormula> formulaList, List<PurchasePerformanceReportItemDto> itemList, String performanceTemplateId) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<String> templateItemIds = itemList.stream().map(PurchasePerformanceReportItemDto::getTemplateItemId).collect(Collectors.toList());
        if (CollUtil.isEmpty(templateItemIds)) {
            return;
        }
        Map<String, List<PurchasePerformanceTemplateItemGrad>> templateItemGradMap = this.queryTemplateGradMap(templateItemIds, performanceTemplateId);
        Map<String, List<PurchasePerformanceTemplateItemFormula>> templateIteFormulaMap = this.queryTemplateFormulaMap(templateItemIds, performanceTemplateId);
        for (PurchasePerformanceReportItemDto entity : itemList) {
            List<PurchasePerformanceTemplateItemFormula> formulas;
            List<PurchasePerformanceTemplateItemGrad> grads = templateItemGradMap.get(entity.getTemplateItemId());
            if (CollUtil.isNotEmpty(grads)) {
                List<PurchasePerformanceReportItemGrad> itemGrads = this.templateConvertToItemGrad(grads, entity);
                gradList.addAll(itemGrads);
            }
            if (!CollUtil.isNotEmpty(formulas = templateIteFormulaMap.get(entity.getTemplateItemId()))) continue;
            List<PurchasePerformanceReportItemFormula> itemGrads = this.templateConvertToItemFormula(formulas, entity);
            formulaList.addAll(itemGrads);
        }
    }

    private List<PurchasePerformanceReportItemGrad> normConvertToItemGrad(List<PurchasePerformanceNormGrad> grads, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(grads)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        for (PurchasePerformanceNormGrad grad : grads) {
            PurchasePerformanceReportItemGrad tem = (PurchasePerformanceReportItemGrad)((Object)Convert.convert(PurchasePerformanceReportItemGrad.class, (Object)((Object)grad)));
            tem.setPerformanceTemplateId(item.getTemplateItemId());
            tem.setPerformanceReportItemId(item.getId());
            tem.setHeadId(item.getHeadId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)item);
            tem.setId(null);
            itemGradList.add(tem);
        }
        return itemGradList;
    }

    private List<PurchasePerformanceReportItemFormula> normConvertToItemFormula(List<PurchasePerformanceNormFormula> formulaList, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(formulaList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        for (PurchasePerformanceNormFormula formula : formulaList) {
            PurchasePerformanceReportItemFormula tem = (PurchasePerformanceReportItemFormula)((Object)Convert.convert(PurchasePerformanceReportItemFormula.class, (Object)((Object)formula)));
            tem.setPerformanceTemplateId(item.getTemplateItemId());
            tem.setHeadId(item.getHeadId());
            tem.setPerformanceReportItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)formula, (BaseEntity)item);
            tem.setId(null);
            itemFormulaList.add(tem);
        }
        return itemFormulaList;
    }

    private Map<String, List<PurchasePerformanceNormGrad>> queryNormGradMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormGrad::getHeadId, normIds);
        List list = this.purchasePerformanceNormGradMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormGrad::getHeadId));
    }

    private Map<String, List<PurchasePerformanceNormFormula>> queryNormFormulaMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormFormula::getHeadId, normIds);
        List list = this.purchasePerformanceNormFormulaMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormFormula::getHeadId));
    }

    private List<PurchasePerformanceReportItemGrad> templateConvertToItemGrad(List<PurchasePerformanceTemplateItemGrad> grads, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(grads)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        for (PurchasePerformanceTemplateItemGrad grad : grads) {
            PurchasePerformanceReportItemGrad tem = (PurchasePerformanceReportItemGrad)((Object)Convert.convert(PurchasePerformanceReportItemGrad.class, (Object)((Object)grad)));
            tem.setPerformanceReportItemId(item.getId());
            tem.setHeadId(item.getHeadId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)item);
            tem.setId(null);
            itemGradList.add(tem);
        }
        return itemGradList;
    }

    private List<PurchasePerformanceReportItemFormula> templateConvertToItemFormula(List<PurchasePerformanceTemplateItemFormula> formulaList, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(formulaList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        for (PurchasePerformanceTemplateItemFormula formula : formulaList) {
            PurchasePerformanceReportItemFormula tem = (PurchasePerformanceReportItemFormula)((Object)Convert.convert(PurchasePerformanceReportItemFormula.class, (Object)((Object)formula)));
            tem.setHeadId(item.getHeadId());
            tem.setPerformanceReportItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)formula, (BaseEntity)item);
            tem.setId(null);
            itemFormulaList.add(tem);
        }
        return itemFormulaList;
    }

    private Map<String, List<PurchasePerformanceTemplateItemGrad>> queryTemplateGradMap(List<String> templateItemIds, String performanceTemplateId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateItemId, templateItemIds)).eq(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateId, (Object)performanceTemplateId);
        List list = this.purchasePerformanceTemplateItemGradMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateItemId));
    }

    private Map<String, List<PurchasePerformanceTemplateItemFormula>> queryTemplateFormulaMap(List<String> templateItemIds, String performanceTemplateId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateItemId, templateItemIds)).eq(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateId, (Object)performanceTemplateId);
        List list = this.purchasePerformanceTemplateItemFormulaMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateItemId));
    }

    private void insertData(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            int itemNumber = 1;
            for (PurchasePerformanceReportItemDto entity : dtoList) {
                entity.setHeadId(purchasePerformanceReportHead.getId());
                entity.setItemNumber(String.valueOf(itemNumber++));
                entity.setId(StrUtil.isEmpty((CharSequence)entity.getId()) ? IdWorker.getIdStr() : entity.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePerformanceReportHead);
            }
            List purchasePerformanceReportItemList = Convert.toList(PurchasePerformanceReportItem.class, dtoList);
            ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).saveBatch(purchasePerformanceReportItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceReportItemMapper.deleteByMainId(id);
        this.purchasePerformanceReportGradMapper.deleteByMainId(id);
        this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(id);
        this.purchasePerformanceReportItemFormulaMapper.deleteByMainId(id);
        this.purchasePerformanceReportItemGradMapper.deleteByMainId(id);
        this.purchasePerformanceReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.purchasePerformanceReportItemMapper.deleteByMainId(id);
            this.purchasePerformanceReportGradMapper.deleteByMainId(id);
            this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(id);
            this.purchasePerformanceReportItemFormulaMapper.deleteByMainId(id);
            this.purchasePerformanceReportItemGradMapper.deleteByMainId(id);
            this.purchasePerformanceReportHeadMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishReport(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        com.els.common.util.Assert.isNotEmpty(purchasePerformanceReportItemList, (String)"\u8bf7\u586b\u5199\u62a5\u8868\u884c\u6570\u636e");
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.EVA.getValue());
        String toElsAccount = purchasePerformanceReportHead.getToElsAccount();
        String accountGroup = purchasePerformanceReportHead.getAccountGroup();
        String orgType = purchasePerformanceReportHead.getOrgType();
        String orgCode = purchasePerformanceReportHead.getOrgCode();
        BigDecimal performanceScore = BigDecimal.ZERO;
        List<PurchasePerformanceReportItem> itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod())).collect(Collectors.toList());
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            if (!ScoreMethodEnum.isScoreBySystem(purchasePerformanceReportItem.getScoringMethod())) continue;
            ReportComputeScoreVO scoreVO = new ReportComputeScoreVO();
            scoreVO.setReportItemId(purchasePerformanceReportItem.getId());
            scoreVO.setAccountGroup(accountGroup);
            scoreVO.setHeadId(purchasePerformanceReportItem.getHeadId());
            scoreVO.setToElsAccount(toElsAccount);
            scoreVO.setAssessmentCycle(purchasePerformanceReportHead.getAssessmentCycle());
            scoreVO.setAssessmentTimeRange(purchasePerformanceReportHead.getAssessmentTimeRange());
            if ("factory".equals(orgType)) {
                scoreVO.setFactor(orgCode);
            } else if ("purchaseGroup".equals(orgType)) {
                scoreVO.setPurchaseOrg(orgCode);
            } else if ("purchaseOrganization".equals(orgType)) {
                scoreVO.setPurchaseGroup(orgCode);
            }
            Map<String, String> map = this.computeScore(scoreVO);
            String computeValue = map.get("computeValue");
            String score = map.get("score");
            if (StrUtil.isNotBlank((CharSequence)computeValue)) {
                purchasePerformanceReportItem.setNormValue(new BigDecimal(computeValue));
            } else {
                purchasePerformanceReportItem.setNormValue(BigDecimal.ZERO);
            }
            purchasePerformanceReportItem.setScoreTime(new Date());
            purchasePerformanceReportItem.setSubAccount(null);
            if (StrUtil.isNotBlank((CharSequence)score)) {
                purchasePerformanceReportItem.setScore(new BigDecimal(score));
            } else {
                purchasePerformanceReportItem.setScore(BigDecimal.ZERO);
            }
            purchasePerformanceReportItem.setSubAccount("system");
            purchasePerformanceReportItem.setScorer("system");
            if (!itemList.isEmpty()) continue;
            BigDecimal itemScore = StringUtils.isNotBlank((CharSequence)score) ? new BigDecimal(score) : BigDecimal.ZERO;
            BigDecimal fullScore = null == purchasePerformanceReportItem.getFullScore() ? BigDecimal.ONE : purchasePerformanceReportItem.getFullScore();
            BigDecimal result = itemScore.divide(fullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
            performanceScore = performanceScore.add(result);
            purchasePerformanceReportHead.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
        }
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            if (CharSequenceUtil.isBlank((CharSequence)purchasePerformanceReportItem.getScorer()) && ScoreMethodEnum.isScoreByManual(purchasePerformanceReportItem.getScoringMethod())) {
                purchasePerformanceReportItem.setScorer(purchasePerformanceReportItem.getSubAccount().split("_")[0]);
            }
            this.purchasePerformanceReportItemMapper.updateById((Object)purchasePerformanceReportItem);
        }
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)purchasePerformanceReportHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (itemList.isEmpty()) {
            PurchasePerformanceReportGrad maxGrad;
            Object var10_14 = null;
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(purchasePerformanceReportHead.getId());
            Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
            if (max.isPresent() && performanceScore.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                String string = maxGrad.getGradingScore();
                purchasePerformanceReportHead.setPerformanceRate(string);
                this.reportPerformanceResultToSupplier(purchasePerformanceReportHead);
                return;
            }
            purchasePerformanceReportHead.setPerformanceScore(performanceScore);
            if (CollUtil.isNotEmpty(gradList)) {
                BigDecimal finalPerformanceScore = performanceScore;
                Optional<PurchasePerformanceReportGrad> any = gradList.stream().filter(x -> finalPerformanceScore.compareTo(x.getStartInterval()) >= 0 && finalPerformanceScore.compareTo(x.getEndInterval()) < 0).findAny();
                any.ifPresent(x -> purchasePerformanceReportHead.setPerformanceRate(x.getGradingScore()));
            }
            this.reportPerformanceResultToSupplier(purchasePerformanceReportHead);
        } else {
            this.sendScoreMsg(itemList, purchasePerformanceReportHead);
        }
    }

    private void sendScoreMsg(List<PurchasePerformanceReportItem> itemList, PurchasePerformanceReportHead purchasePerformanceReportHead) {
        List scorerSubAccount = itemList.stream().map(x -> x.getScorer().split("_")[0]).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(scorerSubAccount)) {
            return;
        }
        HashMap subAccountMap = new HashMap();
        subAccountMap.put(TenantContext.getTenant(), scorerSubAccount);
        this.sendMsgToSubAccount(TenantContext.getTenant(), subAccountMap, (Object)purchasePerformanceReportHead, "pageShow=true&id=" + purchasePerformanceReportHead.getId(), "performanceReport", "performanceScoreNotify");
    }

    private Map<String, String> computeScore(ReportComputeScoreVO scoreVO) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String reportItemId = scoreVO.getReportItemId();
        PurchasePerformanceReportItem normHead = (PurchasePerformanceReportItem)((Object)this.purchasePerformanceReportItemMapper.selectById((Serializable)((Object)reportItemId)));
        if (ScoreMethodEnum.isScoreBySystem(normHead.getScoringMethod())) {
            List<PurchasePerformanceReportItemFormula> formulaList = this.purchasePerformanceReportItemFormulaMapper.selectByHeadIdAndItemId(scoreVO.getHeadId(), reportItemId);
            Assert.notEmpty(formulaList, (String)I18nUtil.translate((String)"i18n_alert_YxutXsBcWWWWWWWWWWIdjHetdtXRBRK_5caae9db", (String)"\u627e\u4e0d\u5230\u7ee9\u6548\u62a5\u8868\u884cid[ ${0} ]\u5bf9\u5e94\u7684\u7cfb\u7edf\u8ba1\u7b97\u7ee9\u6548\u6307\u6807\u516c\u5f0f", (String[])new String[]{reportItemId}));
            HashMap<String, String> params = new HashMap<String, String>();
            for (PurchasePerformanceReportItemFormula formula : formulaList) {
                String sql = this.appendSql(formula, scoreVO);
                String value = this.sqlRunnerExecuteService.getSqlRunnerRpcService(formula.getSourceTable()).runSql(sql + " limit 1");
                params.put(formula.getNormBase(), value);
            }
            String computeValue = FormulaUtil.convertToFormula((String)normHead.getFormula(), params);
            resultMap.put("computeValue", computeValue);
            if (CharSequenceUtil.isNotBlank((CharSequence)computeValue)) {
                PurchasePerformanceReportItemGrad maxGrad;
                BigDecimal compute = new BigDecimal(computeValue);
                BigDecimal fullScore = (BigDecimal)ObjectUtil.defaultIfNull((Object)normHead.getFullScore(), (Object)BigDecimal.ZERO);
                if (ScoreMethodEnum.SYS_COMPUTE.getValue().equals(normHead.getScoringMethod())) {
                    if (compute.compareTo(fullScore) > 0) {
                        compute = fullScore;
                    }
                    resultMap.put("score", compute.toString());
                    return resultMap;
                }
                List<PurchasePerformanceReportItemGrad> gradList = this.purchasePerformanceReportItemGradMapper.selectByHeadIdAndItemId(scoreVO.getHeadId(), reportItemId);
                Optional<PurchasePerformanceReportItemGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportItemGrad::getEndInterval));
                if (max.isPresent() && compute.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                    resultMap.put("score", StrUtil.toString((Object)maxGrad.getGradingScore()));
                }
                if (!resultMap.containsKey("score")) {
                    for (PurchasePerformanceReportItemGrad grad : gradList) {
                        BigDecimal startInterval = grad.getStartInterval();
                        BigDecimal endInterval = grad.getEndInterval();
                        if (compute.compareTo(startInterval) < 0 || compute.compareTo(endInterval) >= 0) continue;
                        resultMap.put("score", StrUtil.toString((Object)grad.getGradingScore()));
                        return resultMap;
                    }
                }
                return resultMap;
            }
        }
        return resultMap;
    }

    private String appendSql(PurchasePerformanceReportItemFormula formula, ReportComputeScoreVO scoreVO) {
        StringBuilder sql = new StringBuilder("select ");
        String table = formula.getSourceTable();
        String field = formula.getSourceField();
        String normSql = formula.getNormSql();
        sql.append(field).append(" from ").append(table).append(" where 1=1 ");
        if (StrUtil.isNotBlank((CharSequence)normSql)) {
            sql.append("and (").append(normSql).append(") ");
        }
        sql.append("and to_els_account='").append(scoreVO.getToElsAccount()).append("' ");
        PerformanceEvaluationTypeEnum typeEnum = PerformanceEvaluationTypeEnum.builder(scoreVO.getAssessmentCycle());
        if (null != typeEnum && CharSequenceUtil.isNotBlank((CharSequence)scoreVO.getAssessmentTimeRange()) && CharSequenceUtil.isNotBlank((CharSequence)formula.getAssessmentCycleField())) {
            switch (typeEnum) {
                case MONTH: {
                    String value = DateUtils.formatDate((Date)new Date(), (String)"yyyy") + this.buildMonth(scoreVO.getAssessmentTimeRange());
                    sql.append(String.format("and date_format(%s,'%s') = '%s'", formula.getAssessmentCycleField(), "%Y%m", value));
                    break;
                }
                case QUARTER: {
                    String[] range = scoreVO.getAssessmentTimeRange().split("-");
                    DateTime start = DateUtil.parse((CharSequence)range[0], (String)"yyyy/MM");
                    DateTime end = DateUtil.endOfMonth((Date)DateUtil.parse((CharSequence)range[1], (String)"yyyy/MM"));
                    sql.append(String.format("and %s between '%s' and '%s'", formula.getAssessmentCycleField(), start, end));
                    break;
                }
                case YEAR: {
                    sql.append(String.format("and date_format(%s,'%s') = '%s'", formula.getAssessmentCycleField(), "%Y", scoreVO.getAssessmentTimeRange()));
                    break;
                }
            }
        }
        return sql.toString();
    }

    private String buildMonth(String month) {
        try {
            return Integer.parseInt(month) < 10 ? "0" + month : month;
        }
        catch (Exception e) {
            throw new ELSBootException("\u7ee9\u6548\u62a5\u8868\u8003\u6838\u8303\u56f4\u5f02\u5e38:{}", new String[]{month});
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void reportPerformanceResultToSupplier(PurchasePerformanceReportHead head) {
        boolean requiredSend;
        boolean syncSource;
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        if (!PerformanceReportStatusEnum.EVA_COMPLETED.getValue().equals(head.getReportStatus())) {
            return;
        }
        boolean bl = syncSource = "0".equals(head.getRequiredAudit()) || "1".equals(head.getRequiredAudit()) && AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus());
        if (!syncSource) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SupplierMasterData::getToElsAccount, (Object)head.getToElsAccount())).eq(StrUtil.isNotEmpty((CharSequence)head.getSupplierCode()), SupplierMasterData::getSupplierCode, (Object)head.getSupplierCode())).eq(BaseEntity::getElsAccount, (Object)head.getElsAccount());
        SupplierMasterData supplierMasterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectOne((Wrapper)wrapper));
        if (null == supplierMasterData) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXdWFWWWWWWWWEdxMK_4fa81317", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e[ ${0} ]\u753b\u50cf\u4e0d\u5b58\u5728", (String[])new String[]{head.getToElsAccount()}));
        }
        supplierMasterData.setPerformanceLevel(head.getPerformanceRate());
        this.supplierMasterDataMapper.updateById((Object)supplierMasterData);
        boolean bl2 = requiredSend = "1".equals(head.getRequiredSend()) && PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue().equals(head.getSendStatus());
        if (requiredSend) {
            head.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = this.purchasePerformanceReportItemMapper.selectItemByMainId(head.getId());
            int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
            this.sendReport(head, purchasePerformanceReportItemList);
            return;
        }
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    private void beforeUpdate(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        if ("1".equals(purchasePerformanceReportHead.getRequiredAudit())) {
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePerformanceReportHead.setRequiredAudit("0");
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setPerformanceRate(null);
        purchasePerformanceReportHead.setPerformanceScore(null);
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            purchasePerformanceReportItem.setScoreTime(null);
            purchasePerformanceReportItem.setScore(null);
            purchasePerformanceReportItem.setNormValue(null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void performancePublish(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        PurchasePerformanceTemplateHead head = new PurchasePerformanceTemplateHead();
        head.setId(purchasePerformanceReportHead.getPerformanceTemplateId());
        head.setPerformanceTemplateStatus(PerformanceTemplateStatusEnum.USED.getValue());
        int count = this.purchasePerformanceTemplateHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)purchasePerformanceReportHead.getId())) {
            if (StringUtils.isBlank((CharSequence)purchasePerformanceReportHead.getReportNumber())) {
                purchasePerformanceReportHead.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)purchasePerformanceReportHead));
            }
            purchasePerformanceReportHead.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            purchasePerformanceReportHead.setRequiredSend("0");
            purchasePerformanceReportHead.setRequiredAudit("1");
            purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
            purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            this.saveMain(purchasePerformanceReportHead, purchasePerformanceReportItemList);
        } else {
            this.beforeUpdate(purchasePerformanceReportHead, purchasePerformanceReportItemList);
            this.updateMain(purchasePerformanceReportHead, purchasePerformanceReportItemList);
        }
        this.publishReport(purchasePerformanceReportHead, purchasePerformanceReportItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sendReportToSale(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.sendReport(head, purchasePerformanceReportItemList);
    }

    @Override
    public void sendReport(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        String id = purchasePerformanceReportHead.getId();
        String elsAccount = purchasePerformanceReportHead.getElsAccount();
        String toElsAccount = purchasePerformanceReportHead.getToElsAccount();
        SalePerformanceReportHead salePerformanceReportHead = new SalePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)salePerformanceReportHead));
        salePerformanceReportHead.setId(IdWorker.getIdStr());
        salePerformanceReportHead.setRelationId(id);
        salePerformanceReportHead.setElsAccount(toElsAccount);
        salePerformanceReportHead.setToElsAccount(elsAccount);
        salePerformanceReportHead.setBusAccount(elsAccount);
        ArrayList<SalePerformanceReportItem> salePerformanceReportItemList = new ArrayList<SalePerformanceReportItem>();
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            String itemId = purchasePerformanceReportItem.getId();
            SalePerformanceReportItem saleItem = new SalePerformanceReportItem();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(toElsAccount);
            saleItem.setHeadId(purchasePerformanceReportHead.getId());
            saleItem.setRelationId(itemId);
            salePerformanceReportItemList.add(saleItem);
        }
        this.salePerformanceReportHeadService.saveMain(salePerformanceReportHead, salePerformanceReportItemList);
        this.sendAsyncReportResultMsg(salePerformanceReportHead);
    }

    @Override
    public void sendAsyncReportResultMsg(SalePerformanceReportHead head) {
        this.sendMsg(head.getToElsAccount(), head.getElsAccount(), Lists.newArrayList((Object[])new String[]{"1001"}), (Object)head, "id=" + head.getId(), "performanceReport", "performanceSendNotify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgParamsVO sendReportParameterAssemble(SalePerformanceReportHead head) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        HashMap<String, ArrayList> receiverMap = new HashMap<String, ArrayList>();
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)head.getElsAccount());
            ElsSubAccountDTO account = this.supplierInvokeAccountRpcService.getAccount(head.getElsAccount(), "1001");
            receiverMap.put(TenantContext.getTenant(), Lists.newArrayList((Object[])new ElsSubAccountDTO[]{account}));
            msgParamsVO.setReceiverMap(receiverMap);
            msgParamsVO.setParams((Object)head);
            MsgParamsVO msgParamsVO2 = msgParamsVO;
            return msgParamsVO2;
        }
        finally {
            TenantContext.setTenant((String)tenant);
        }
    }

    @Override
    public List<PurchasePerformanceReportItem> getSupplierScore(String toElsAccount) {
        LambdaQueryWrapper reportQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)reportQueryWrapper.eq(PurchasePerformanceReportHead::getReportStatus, (Object)PerformanceReportStatusEnum.EVA_COMPLETED.getValue())).eq(PurchasePerformanceReportHead::getToElsAccount, (Object)toElsAccount)).orderByDesc(BaseEntity::getUpdateTime)).last("limit 1");
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadMapper.selectOne((Wrapper)reportQueryWrapper));
        if (null == head) {
            return Lists.newArrayList();
        }
        return this.purchasePerformanceReportItemMapper.selectByMainId(head.getId());
    }

    public BigDecimal getScore(String headId, String itemId, BigDecimal compute) {
        PurchasePerformanceReportItemGrad maxGrad;
        List<PurchasePerformanceReportItemGrad> gradList = this.purchasePerformanceReportItemGradMapper.selectByHeadIdAndItemId(headId, itemId);
        Optional<PurchasePerformanceReportItemGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportItemGrad::getEndInterval));
        if (max.isPresent() && compute.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
            return maxGrad.getGradingScore();
        }
        for (PurchasePerformanceReportItemGrad grad : gradList) {
            BigDecimal startInterval = grad.getStartInterval();
            BigDecimal endInterval = grad.getEndInterval();
            if (compute.compareTo(startInterval) < 0 || compute.compareTo(endInterval) >= 0) continue;
            return grad.getGradingScore();
        }
        return BigDecimal.ZERO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void evaOpt(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemList) {
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : itemList) {
            if (purchasePerformanceReportItem.getNormValue() == null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RBRxOLVW_57ad7015", (String)"\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (purchasePerformanceReportItem.getScore() == null && ScoreMethodEnum.MANUAL_SCORE.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                purchasePerformanceReportItem.setScore(this.getScore(purchasePerformanceReportItem.getHeadId(), purchasePerformanceReportItem.getId(), purchasePerformanceReportItem.getNormValue()));
            }
            purchasePerformanceReportItem.setScoreTime(new Date());
            this.purchasePerformanceReportItemMapper.updateById((Object)purchasePerformanceReportItem);
        }
        List<PurchasePerformanceReportItem> items = this.purchasePerformanceReportItemMapper.selectByMainId(head.getId());
        List list = items.stream().filter(o -> o.getScoreTime() == null).collect(Collectors.toList());
        if (list.isEmpty()) {
            int count;
            Optional<PurchasePerformanceReportGrad> any;
            PurchasePerformanceReportGrad maxGrad;
            BigDecimal totalSocre = BigDecimal.ZERO;
            BigDecimal totalFullScore = BigDecimal.ZERO;
            for (PurchasePerformanceReportItem item : items) {
                BigDecimal itemScore = item.getScore();
                BigDecimal fullScore = null == item.getFullScore() ? BigDecimal.ONE : item.getFullScore();
                totalFullScore = totalFullScore.add(fullScore);
                totalSocre = totalSocre.add(itemScore);
            }
            BigDecimal resultSocre = totalSocre.divide(totalFullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
            head.setId(head.getId());
            head.setPerformanceScore(resultSocre);
            head.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
            String level = null;
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(head.getId());
            Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
            if (max.isPresent() && resultSocre.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                level = maxGrad.getGradingScore();
            }
            if (CharSequenceUtil.isBlank(level) && (any = gradList.stream().filter(x -> resultSocre.compareTo(x.getStartInterval()) >= 0 && resultSocre.compareTo(x.getEndInterval()) < 0).findAny()).isPresent()) {
                level = any.get().getGradingScore();
            }
            head.setPerformanceRate(level);
            this.reportPerformanceResultToSupplier(head);
            if ("1".equals(head.getRequiredAudit())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if ((count = this.purchasePerformanceReportHeadMapper.updateById((Object)head)) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
        }
    }
}

