/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.vo.PurchaseCertificatedInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/supplier/purchaseCertificatedInfo"})
@Api(tags={"\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599"})
public class PurchaseCertificatedInfoController
extends BaseController<PurchaseCertificatedInfo, PurchaseCertificatedInfoService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseCertificatedInfoController.class);
    @Autowired
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseCertificatedInfo purchaseCertificatedInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseCertificatedInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseCertificatedInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoPage) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoPage), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.saveMain(purchaseCertificatedInfo, purchaseCertificatedInfoPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseCertificatedInfo));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoPage) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoPage), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.updateMain(purchaseCertificatedInfo, purchaseCertificatedInfoPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseCertificatedInfoService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseCertificatedInfoService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoService.getById((Serializable)((Object)id)));
        PurchaseCertificatedInfoVO purchaseCertificatedInfoVO = new PurchaseCertificatedInfoVO();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)purchaseCertificatedInfoVO));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseCertificatedInfoVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseCertificatedInfoVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599id\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        return Result.ok(purchaseAttachmentList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, PurchaseCertificatedInfo purchaseCertificatedInfo) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseCertificatedInfo), (Map)request.getParameterMap());
        LoginUser sysUser = SysUtil.getLoginUser();
        ArrayList<PurchaseCertificatedInfoVO> pageList = new ArrayList<PurchaseCertificatedInfoVO>();
        List purchaseCertificatedInfoList = this.purchaseCertificatedInfoService.list((Wrapper)queryWrapper);
        for (PurchaseCertificatedInfo temp : purchaseCertificatedInfoList) {
            PurchaseCertificatedInfoVO vo = new PurchaseCertificatedInfoVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(temp.getId());
            vo.setPurchaseAttachmentList(purchaseAttachmentList);
            pageList.add(vo);
        }
        return null;
    }

    @ApiOperation(value="\u8ba4\u8bc1\u8d44\u6599\u83b7\u53d6", notes="\u8ba4\u8bc1\u8d44\u6599\u83b7\u53d6")
    @GetMapping(value={"/certificatedInfo"})
    public Result<?> certificatedInfo(@RequestParam(name="toElsAccount", required=true) String toElsAccount) {
        return this.purchaseCertificatedInfoService.certificatedInfo(toElsAccount);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u53d1\u9001")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody PurchaseCertificatedInfoVO purchaseCertificatedInfoVO) {
        PurchaseCertificatedInfo purchaseCertificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfoVO), (Object)((Object)purchaseCertificatedInfo));
        this.purchaseCertificatedInfoService.send(purchaseCertificatedInfo, purchaseCertificatedInfoVO.getPurchaseAttachmentList());
        return Result.ok();
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8ba4\u8bc1\u8d44\u6599", value="\u5931\u6548")
    @ApiOperation(value="\u5931\u6548", notes="\u5931\u6548")
    @GetMapping(value={"/loseEfficacy"})
    public Result<?> loseEfficacy(@RequestParam(name="id", required=true) String id) {
        this.purchaseCertificatedInfoService.loseEfficacy(id);
        return Result.ok();
    }
}

