/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.entity.SaleStandardItem;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.els.modules.supplier.service.SaleStandardItemService;
import com.els.modules.supplier.vo.SaleStandardHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/supplier/supplierStandardHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165\u5934"})
public class SaleStandardHeadController
extends BaseController<SaleStandardHead, SaleStandardHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleStandardHeadController.class);
    @Autowired
    private SaleStandardHeadService supplierStandardHeadService;
    @Autowired
    private SaleStandardItemService supplierStandardItemService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleStandardHead supplierStandardHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierStandardHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierStandardHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SaleStandardHeadVO supplierStandardHeadPage) {
        SaleStandardHead supplierStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHeadPage), (Object)((Object)supplierStandardHead));
        this.supplierStandardHeadService.saveMain(supplierStandardHead, supplierStandardHeadPage.getSupplierStandardItemList());
        return Result.ok((Object)((Object)supplierStandardHead));
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SaleStandardHeadVO supplierStandardHeadPage) {
        SaleStandardHead supplierStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHeadPage), (Object)((Object)supplierStandardHead));
        this.supplierStandardHeadService.updateMain(supplierStandardHead, supplierStandardHeadPage.getSupplierStandardItemList(), supplierStandardHeadPage.getSaleAttachments());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.supplierStandardHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.supplierStandardHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleStandardHead supplierStandardHead = (SaleStandardHead)((Object)this.supplierStandardHeadService.getById((Serializable)((Object)id)));
        SaleStandardHeadVO supplierStandardHeadVO = new SaleStandardHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierStandardHead), (Object)((Object)supplierStandardHeadVO));
        List<SaleStandardItem> supplierStandardItemList = this.supplierStandardItemService.selectByMainId(id);
        supplierStandardHeadVO.setSupplierStandardItemList(supplierStandardItemList);
        List<SaleAttachmentDTO> saleAttachments = this.supplierInvokeBaseRpcService.saleSelectByMainId(id);
        supplierStandardHeadVO.setSaleAttachments(saleAttachments);
        ArrayList<PurchaseAttachmentDTO> modelList = null;
        if (supplierStandardItemList != null) {
            modelList = new ArrayList<PurchaseAttachmentDTO>();
            for (SaleStandardItem item : supplierStandardItemList) {
                List<PurchaseAttachmentDTO> attachments = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(item.getStandardId());
                modelList.addAll(attachments);
            }
            supplierStandardHeadVO.setModelAttachmentList(modelList);
        }
        return Result.ok((Object)((Object)supplierStandardHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c")
    @GetMapping(value={"/querysupplierStandardItemByMainId"})
    public Result<?> querysupplierStandardItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleStandardItem> supplierStandardItemList = this.supplierStandardItemService.selectByMainId(id);
        return Result.ok(supplierStandardItemList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SaleStandardHead supplierStandardHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierStandardHead), (Map)request.getParameterMap());
        LoginUser sysUser = SysUtil.getLoginUser();
        ArrayList<SaleStandardHeadVO> pageList = new ArrayList<SaleStandardHeadVO>();
        List supplierStandardHeadList = this.supplierStandardHeadService.list((Wrapper)queryWrapper);
        for (SaleStandardHead temp : supplierStandardHeadList) {
            SaleStandardHeadVO vo = new SaleStandardHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<SaleStandardItem> supplierStandardItemList = this.supplierStandardItemService.selectByMainId(temp.getId());
            vo.setSupplierStandardItemList(supplierStandardItemList);
            pageList.add(vo);
        }
        return null;
    }

    @AutoLog(busModule="\u5206\u9879\u7b54\u9898", value="\u7b54\u9898\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody SaleStandardHeadVO saleStandardHeadVO) {
        SaleStandardHead saleStandardHead = new SaleStandardHead();
        BeanUtils.copyProperties((Object)((Object)saleStandardHeadVO), (Object)((Object)saleStandardHead));
        this.supplierStandardHeadService.submit(saleStandardHead, saleStandardHeadVO.getSupplierStandardItemList(), saleStandardHeadVO.getSaleAttachments());
        return this.commonSuccessResult(3);
    }
}

