/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierMasterDataExcelHandler")
public class SupplierMasterDataExcelHandler
implements ExcelImportRpcService {
    @Resource
    private InvokeBaseRpcService templateHeadService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;

    public void importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        List templateList = this.templateHeadService.getDefaultTemplateByType("supplierMasterData");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3011\u4e1a\u52a1\u3010\u9ed8\u8ba4\u3011\u6a21\u677f\u3002"));
        ArrayList<SupplierMasterData> entityList = new ArrayList<SupplierMasterData>();
        for (Map<String, Object> data : dataList) {
            SupplierMasterData entity = (SupplierMasterData)((Object)JSON.parseObject((String)JSON.toJSONString(data), SupplierMasterData.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion() + "");
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entityList.add(entity);
        }
        List stringList = entityList.stream().map(SupplierMasterData::getSupplierName).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        Assert.isTrue((count == (long)stringList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u4f9b\u5e94\u5546\u540d\u79f0"));
        this.supplierMasterDataService.saveImportData(entityList);
    }
}

