/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.supplier.entity.SupplierAbnormal;
import com.els.modules.supplier.entity.SupplierActualControl;
import com.els.modules.supplier.entity.SupplierBankruptcy;
import com.els.modules.supplier.entity.SupplierCompanyHolding;
import com.els.modules.supplier.entity.SupplierCustomer;
import com.els.modules.supplier.entity.SupplierDishonest;
import com.els.modules.supplier.entity.SupplierHumanHolding;
import com.els.modules.supplier.entity.SupplierInvesttree;
import com.els.modules.supplier.entity.SupplierJingpin;
import com.els.modules.supplier.entity.SupplierJudicial;
import com.els.modules.supplier.entity.SupplierLawsuit;
import com.els.modules.supplier.entity.SupplierPunishment;
import com.els.modules.supplier.entity.SupplierPunishmentInfo;
import com.els.modules.supplier.entity.SupplierSupply;
import com.els.modules.supplier.entity.SupplierZhixinginfo;
import com.els.modules.supplier.enumerate.RiskTypeEnum;
import com.els.modules.supplier.mapper.SupplierSupplyMapper;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.service.SupplierAbnormalService;
import com.els.modules.supplier.service.SupplierActualControlService;
import com.els.modules.supplier.service.SupplierBankruptcyService;
import com.els.modules.supplier.service.SupplierCompanyHoldingService;
import com.els.modules.supplier.service.SupplierCustomerService;
import com.els.modules.supplier.service.SupplierDishonestService;
import com.els.modules.supplier.service.SupplierHumanHoldingService;
import com.els.modules.supplier.service.SupplierInvesttreeService;
import com.els.modules.supplier.service.SupplierJingpinService;
import com.els.modules.supplier.service.SupplierJudicialService;
import com.els.modules.supplier.service.SupplierLawsuitService;
import com.els.modules.supplier.service.SupplierPunishmentInfoService;
import com.els.modules.supplier.service.SupplierPunishmentService;
import com.els.modules.supplier.service.SupplierSupplyService;
import com.els.modules.supplier.service.SupplierZhixinginfoService;
import com.els.modules.supplier.util.TianyanchaResultAnaLysisUtils;
import com.els.modules.supplier.vo.EnterpriseRiskVO;
import com.els.modules.supplier.vo.RiskVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskServiceImpl
implements RiskService {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private static final String SERVICE = "valueAddedApplication";
    private static final String NEW = "0";
    private static final String OLD = "1";
    @Autowired
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierLawsuitService supplierLawsuitService;
    @Autowired
    private SupplierJudicialService supplierJudicialService;
    @Autowired
    private SupplierBankruptcyService supplierBankruptcyService;
    @Autowired
    private SupplierAbnormalService supplierAbnormalService;
    @Autowired
    private SupplierPunishmentService supplierPunishmentService;
    @Autowired
    private SupplierPunishmentInfoService supplierPunishmentInfoService;
    @Autowired
    private SupplierDishonestService supplierDishonestService;
    @Autowired
    private SupplierCustomerService supplierCustomerService;
    @Autowired
    private SupplierSupplyMapper supplierSupplyMapper;
    @Autowired
    private SupplierJingpinService supplierJingpinService;
    @Autowired
    private SupplierInvesttreeService supplierInvesttreeService;
    @Autowired
    private SupplierHumanHoldingService supplierHumanHoldingService;
    @Autowired
    private SupplierCompanyHoldingService supplierCompanyHoldingService;
    @Autowired
    private SupplierActualControlService supplierActualControlService;
    @Autowired
    private SupplierZhixinginfoService supplierZhixinginfoService;

    @Override
    public EnterpriseRiskVO queryRiskByElsAccount(RiskVO riskVO) {
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(riskVO.getElsAccount());
        if (enterpriseInfo == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u98ce\u9669\u6570\u636e\u67e5\u8be2"));
        }
        EnterpriseRiskVO enterpriseRiskVO = new EnterpriseRiskVO();
        BeanUtils.copyProperties((Object)enterpriseInfo, (Object)((Object)enterpriseRiskVO));
        if (RiskTypeEnum.LEGAL_RISK.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierLawsuitList(this.queryLawsuit(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setOldSupplierLawsuitList(this.queryLawsuit(riskVO, enterpriseInfo, OLD));
            enterpriseRiskVO.setSupplierJudicialList(this.queryJudicial(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setOldSupplierJudicialList(this.queryJudicial(riskVO, enterpriseInfo, OLD));
            enterpriseRiskVO.setSupplierBankruptcyList(this.queryBankruptcy(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierZhixinginfoList(this.queryZhixing(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setSupplierZhixinginfoList(this.queryZhixing(riskVO, enterpriseInfo, OLD));
            enterpriseRiskVO.setSupplierDishonestList(this.queryDishonest(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setOldSupplierDishonestList(this.queryDishonest(riskVO, enterpriseInfo, OLD));
        }
        if (RiskTypeEnum.INDUSTRY_POSTION.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierCustomerList(this.queryCustomer(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierSupplyList(this.querySupply(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierJingpinList(this.queryJingpin(riskVO, enterpriseInfo));
        }
        if (RiskTypeEnum.MANAGE_RISK.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierPunishmentInfoList(this.queryPunishmentInfo(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setOldSupplierPunishmentInfoList(this.queryPunishmentInfo(riskVO, enterpriseInfo, OLD));
            enterpriseRiskVO.setSupplierPunishmentList(this.queryPunishment(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setSupplierPunishmentList(this.queryPunishment(riskVO, enterpriseInfo, OLD));
            enterpriseRiskVO.setSupplierAbnormalList(this.queryAbnormal(riskVO, enterpriseInfo, NEW));
            enterpriseRiskVO.setSupplierAbnormalList(this.queryAbnormal(riskVO, enterpriseInfo, OLD));
        }
        if (RiskTypeEnum.RELATION_FIND.getValue().equals(riskVO.getRiskType())) {
            enterpriseRiskVO.setSupplierInvesttreeList(this.queryInvesttree(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierHumanHoldingList(this.queryhumanHolding(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierCompanyHoldingList(this.queryCompanyHolding(riskVO, enterpriseInfo));
            enterpriseRiskVO.setSupplierActualControlList(this.queryActualControl(riskVO, enterpriseInfo));
        }
        return enterpriseRiskVO;
    }

    @Override
    public Result<?> queryRisk(RiskVO riskVO) {
        EnterpriseRiskVO enterpriseRiskVO = this.queryRiskByElsAccount(riskVO);
        return Result.ok((Object)((Object)enterpriseRiskVO));
    }

    public List<SupplierInvesttree> queryInvesttree(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> investtrees = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (investtrees = this.supplierInvesttreeService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return investtrees;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        String interfaceCode = this.configMap.get("tianyancha.investtre");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            investtrees = JSON.parseArray((String)response.getResult().toString(), SupplierInvesttree.class);
            for (SupplierInvesttree supplierInvesttree : investtrees) {
                supplierInvesttree.setElsAccount(enterpriseInfo.getElsAccount());
                supplierInvesttree.setHeadId(enterpriseInfo.getId());
                supplierInvesttree.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierInvesttree.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierInvesttreeService.deleteByMainId(enterpriseInfo.getId());
            this.supplierInvesttreeService.saveBatch(investtrees);
        }
        return investtrees;
    }

    public List<SupplierActualControl> queryActualControl(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> actualControls = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (actualControls = this.supplierActualControlService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return actualControls;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        String interfaceCode = this.configMap.get("tianyancha.actualControl");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            SupplierActualControl actualControl = (SupplierActualControl)((Object)JSON.parseObject((String)returnData.toString(), SupplierActualControl.class));
            actualControl.setElsAccount(enterpriseInfo.getElsAccount());
            actualControl.setHeadId(enterpriseInfo.getId());
            actualControl.setDeleted(CommonConstant.DEL_FLAG_0);
            actualControl.setSupplierName(enterpriseInfo.getName());
            actualControls.add((Object)actualControl);
        }
        if (!actualControls.isEmpty()) {
            this.supplierActualControlService.deleteByMainId(enterpriseInfo.getId());
            this.supplierActualControlService.saveBatch(actualControls);
        }
        return actualControls;
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplierCompanyHolding> queryCompanyHolding(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> companyHoldings = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (companyHoldings = this.supplierCompanyHoldingService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return companyHoldings;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        String interfaceCode = this.configMap.get("tianyancha.companyHolding");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            companyHoldings = JSON.parseArray((String)returnData.getString("items"), SupplierCompanyHolding.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                void var10_12;
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer n = total / 20;
                if (total % 20 > 0) {
                    Integer n2 = n + 1;
                }
                for (int i = 2; i <= var10_12.intValue(); ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    companyHoldings.addAll(this.companyHoldings(requestObject, interfaceCode));
                }
            }
            for (SupplierCompanyHolding supplierCompanyHolding : companyHoldings) {
                supplierCompanyHolding.setElsAccount(enterpriseInfo.getElsAccount());
                supplierCompanyHolding.setHeadId(enterpriseInfo.getId());
                supplierCompanyHolding.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierCompanyHolding.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierCompanyHoldingService.deleteByMainId(enterpriseInfo.getId());
            this.supplierCompanyHoldingService.saveBatch(companyHoldings, 2000);
        }
        return companyHoldings;
    }

    private List<SupplierCompanyHolding> companyHoldings(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierCompanyHolding.class);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplierHumanHolding> queryhumanHolding(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> holdings = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (holdings = this.supplierHumanHoldingService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return holdings;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        String interfaceCode = this.configMap.get("tianyancha.humanHolding");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            holdings = JSON.parseArray((String)returnData.getString("items"), SupplierHumanHolding.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                void var10_12;
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer n = total / 20;
                if (total % 20 > 0) {
                    Integer n2 = n + 1;
                }
                for (int i = 2; i <= var10_12.intValue(); ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    holdings.addAll(this.holdings(requestObject, interfaceCode));
                }
            }
            for (SupplierHumanHolding supplierHumanHolding : holdings) {
                supplierHumanHolding.setElsAccount(enterpriseInfo.getElsAccount());
                supplierHumanHolding.setHeadId(enterpriseInfo.getId());
                supplierHumanHolding.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierHumanHolding.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierHumanHoldingService.deleteByMainId(enterpriseInfo.getId());
            this.supplierHumanHoldingService.saveBatch(holdings, 2000);
        }
        return holdings;
    }

    private List<SupplierHumanHolding> holdings(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierHumanHolding.class);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplierJingpin> queryJingpin(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> jingpins = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (jingpins = this.supplierJingpinService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return jingpins;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        String interfaceCode = this.configMap.get("tianyancha.jingpin");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            jingpins = JSON.parseArray((String)returnData.getString("items"), SupplierJingpin.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                void var10_12;
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer n = total / 20;
                if (total % 20 > 0) {
                    Integer n2 = n + 1;
                }
                for (int i = 2; i <= var10_12.intValue(); ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    jingpins.addAll(this.jingpins(requestObject, interfaceCode));
                }
            }
            for (SupplierJingpin supplierJingpin : jingpins) {
                supplierJingpin.setElsAccount(enterpriseInfo.getElsAccount());
                supplierJingpin.setHeadId(enterpriseInfo.getId());
                supplierJingpin.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierJingpin.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierJingpinService.deleteByMainId(enterpriseInfo.getId());
            this.supplierJingpinService.saveBatch(jingpins, 2000);
        }
        return jingpins;
    }

    private List<SupplierJingpin> jingpins(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierJingpin.class);
        }
        return null;
    }

    public List<SupplierSupply> querySupply(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        SupplierSupply supply;
        JSONObject jsonObject;
        List<Object> supplies = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (supplies = this.supplierSupplyMapper.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return supplies;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        Calendar rightNow = Calendar.getInstance();
        object.put("year", (Object)(rightNow.get(1) - 1));
        requestObject.put("base", (Object)object);
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.supply"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 1));
            supplies.add((Object)supply);
        }
        object.put("year", (Object)(rightNow.get(1) - 2));
        requestObject.put("base", (Object)object);
        response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.supply"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 2));
            supplies.add((Object)supply);
        }
        object.put("year", (Object)(rightNow.get(1) - 3));
        requestObject.put("base", (Object)object);
        response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.supply"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            supply = (SupplierSupply)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierSupply.class));
            supply.setElsAccount(enterpriseInfo.getElsAccount());
            supply.setHeadId(enterpriseInfo.getId());
            supply.setDeleted(CommonConstant.DEL_FLAG_0);
            supply.setSupplierName(enterpriseInfo.getName());
            supply.setSuppliesYear(String.valueOf(rightNow.get(1) - 3));
            supplies.add((Object)supply);
        }
        if (!supplies.isEmpty()) {
            this.supplierSupplyMapper.deleteByMainId(enterpriseInfo.getId());
            ((SupplierSupplyService)SpringContextUtils.getBean(SupplierSupplyService.class)).saveBatch(supplies);
        }
        return supplies;
    }

    public List<SupplierCustomer> queryCustomer(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        SupplierCustomer customer;
        JSONObject jsonObject;
        List<Object> customers = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (customers = this.supplierCustomerService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return customers;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        Calendar rightNow = Calendar.getInstance();
        object.put("year", (Object)(rightNow.get(1) - 1));
        requestObject.put("base", (Object)object);
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.customer"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 1));
            customers.add((Object)customer);
        }
        object.put("year", (Object)(rightNow.get(1) - 2));
        requestObject.put("base", (Object)object);
        response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.customer"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 2));
            customers.add((Object)customer);
        }
        object.put("year", (Object)(rightNow.get(1) - 3));
        requestObject.put("base", (Object)object);
        response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.customer"));
        if (response.isSuccess()) {
            jsonObject = (JSONObject)response.getResult();
            customer = (SupplierCustomer)((Object)JSON.parseObject((String)jsonObject.toString(), SupplierCustomer.class));
            customer.setElsAccount(enterpriseInfo.getElsAccount());
            customer.setHeadId(enterpriseInfo.getId());
            customer.setDeleted(CommonConstant.DEL_FLAG_0);
            customer.setSupplierName(enterpriseInfo.getName());
            customer.setCustomerYear(String.valueOf(rightNow.get(1) - 3));
            customers.add((Object)customer);
        }
        if (!customers.isEmpty()) {
            this.supplierCustomerService.deleteByMainId(enterpriseInfo.getId());
            this.supplierCustomerService.saveBatch(customers);
        }
        return customers;
    }

    public List<SupplierDishonest> queryDishonest(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List dishonests = this.supplierDishonestService.list((Wrapper)wrapper);
            if (dishonests.size() > 0) {
                return dishonests;
            }
        }
        return this.updateDishonest(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierDishonest> updateDishonest(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierDishonest> dishonests = new ArrayList<SupplierDishonest>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.dishonests") : this.configMap.get("tianyancha.old-dishonests");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            dishonests = JSON.parseArray((String)returnData.getString("items"), SupplierDishonest.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    dishonests.addAll(this.dishonests(requestObject, interfaceCode));
                }
            }
            for (SupplierDishonest dishonest : dishonests) {
                dishonest.setElsAccount(elsAccount);
                dishonest.setHeadId(enterpriseId);
                dishonest.setDeleted(CommonConstant.DEL_FLAG_0);
                dishonest.setDistinction(version);
                dishonest.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierDishonestService.remove((Wrapper)wrapper);
            this.supplierDishonestService.saveBatch(dishonests, 200);
        }
        return dishonests;
    }

    private List<SupplierDishonest> dishonests(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierDishonest.class);
        }
        return null;
    }

    public List<SupplierPunishmentInfo> queryPunishmentInfo(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List punishmentInfos = this.supplierPunishmentInfoService.list((Wrapper)wrapper);
            if (punishmentInfos.size() > 0) {
                return punishmentInfos;
            }
        }
        return this.updatePunishmentInfo(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierPunishmentInfo> updatePunishmentInfo(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierPunishmentInfo> punishmentInfos = new ArrayList<SupplierPunishmentInfo>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.punishmentInfo") : this.configMap.get("tianyancha.old-punishmentInfo");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            punishmentInfos = JSON.parseArray((String)returnData.getString("items"), SupplierPunishmentInfo.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    punishmentInfos.addAll(this.punishmentInfos(requestObject, interfaceCode));
                }
            }
            for (SupplierPunishmentInfo punishmentInfo : punishmentInfos) {
                punishmentInfo.setElsAccount(elsAccount);
                punishmentInfo.setHeadId(enterpriseId);
                punishmentInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                punishmentInfo.setDistinction(version);
                punishmentInfo.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierPunishmentInfoService.remove((Wrapper)wrapper);
            this.supplierPunishmentInfoService.saveBatch(punishmentInfos);
        }
        return punishmentInfos;
    }

    private List<SupplierPunishmentInfo> punishmentInfos(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierPunishmentInfo.class);
        }
        return null;
    }

    public List<SupplierPunishment> queryPunishment(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List punishments = this.supplierPunishmentService.list((Wrapper)wrapper);
            if (punishments.size() > 0) {
                return punishments;
            }
        }
        return this.updatePunishment(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierPunishment> updatePunishment(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierPunishment> punishments = new ArrayList<SupplierPunishment>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.punishment") : this.configMap.get("tianyancha.old-punishment");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            punishments = JSON.parseArray((String)returnData.getString("items"), SupplierPunishment.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    punishments.addAll(this.punishments(requestObject, interfaceCode));
                }
            }
            for (SupplierPunishment punishment : punishments) {
                punishment.setElsAccount(elsAccount);
                punishment.setHeadId(enterpriseId);
                punishment.setDeleted(CommonConstant.DEL_FLAG_0);
                punishment.setDistinction(version);
                punishment.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierPunishmentService.remove((Wrapper)wrapper);
            this.supplierPunishmentService.saveBatch(punishments);
        }
        return punishments;
    }

    private List<SupplierPunishment> punishments(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierPunishment.class);
        }
        return null;
    }

    public List<SupplierAbnormal> queryAbnormal(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List abnormals = this.supplierAbnormalService.list((Wrapper)wrapper);
            if (abnormals.size() > 0) {
                return abnormals;
            }
        }
        return this.updateAbnromal(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierAbnormal> updateAbnromal(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierAbnormal> abnormals = new ArrayList<SupplierAbnormal>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.abnormal") : this.configMap.get("tianyancha.old-abnormal");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            abnormals = JSON.parseArray((String)returnData.getString("items"), SupplierAbnormal.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    abnormals.addAll(this.abnormals(requestObject, interfaceCode));
                }
            }
            for (SupplierAbnormal abnormal : abnormals) {
                abnormal.setElsAccount(elsAccount);
                abnormal.setHeadId(enterpriseId);
                abnormal.setDeleted(CommonConstant.DEL_FLAG_0);
                abnormal.setDistinction(version);
                abnormal.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierAbnormalService.remove((Wrapper)wrapper);
            this.supplierAbnormalService.saveBatch(abnormals);
        }
        return abnormals;
    }

    private List<SupplierAbnormal> abnormals(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierAbnormal.class);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplierBankruptcy> queryBankruptcy(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo) {
        List<Object> bankruptcies = new ArrayList();
        if (!OLD.equals(riskVO.getUpdated()) && (bankruptcies = this.supplierBankruptcyService.selectByMainId(enterpriseInfo.getId())).size() > 0) {
            return bankruptcies;
        }
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)enterpriseInfo.getName());
        requestObject.put("base", (Object)object);
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, this.configMap.get("tianyancha.bankruptcy"));
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            bankruptcies = JSON.parseArray((String)returnData.getString("items"), SupplierBankruptcy.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                void var9_11;
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer n = total / 20;
                if (total % 20 > 0) {
                    Integer n2 = n + 1;
                }
                for (int i = 2; i <= var9_11.intValue(); ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    bankruptcies.addAll(this.bankruptcies(requestObject, this.configMap.get("tianyancha.bankruptcy")));
                }
            }
            for (SupplierBankruptcy supplierBankruptcy : bankruptcies) {
                supplierBankruptcy.setElsAccount(enterpriseInfo.getElsAccount());
                supplierBankruptcy.setHeadId(enterpriseInfo.getId());
                supplierBankruptcy.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierBankruptcy.setSupplierName(enterpriseInfo.getName());
            }
            this.supplierBankruptcyService.deleteByMainId(enterpriseInfo.getId());
            this.supplierBankruptcyService.saveBatch(bankruptcies, 200);
        }
        return bankruptcies;
    }

    private List<SupplierBankruptcy> bankruptcies(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierBankruptcy.class);
        }
        return null;
    }

    public List<SupplierZhixinginfo> queryZhixing(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List zhixinginfos = this.supplierZhixinginfoService.list((Wrapper)wrapper);
            if (zhixinginfos.size() > 0) {
                return zhixinginfos;
            }
        }
        return this.updateZhixing(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierZhixinginfo> updateZhixing(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierZhixinginfo> zhixinginfos = new ArrayList<SupplierZhixinginfo>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.zhixing") : this.configMap.get("tianyancha.old-zhixing");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            zhixinginfos = JSON.parseArray((String)returnData.getString("items"), SupplierZhixinginfo.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    zhixinginfos.addAll(this.zhixinginfos(requestObject, interfaceCode));
                }
            }
            for (SupplierZhixinginfo zhixinginfo : zhixinginfos) {
                zhixinginfo.setElsAccount(elsAccount);
                zhixinginfo.setHeadId(enterpriseId);
                zhixinginfo.setDeleted(CommonConstant.DEL_FLAG_0);
                zhixinginfo.setDistinction(version);
                zhixinginfo.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierZhixinginfoService.remove((Wrapper)wrapper);
            this.supplierZhixinginfoService.saveBatch(zhixinginfos, 2000);
        }
        return zhixinginfos;
    }

    private List<SupplierZhixinginfo> zhixinginfos(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierZhixinginfo.class);
        }
        return null;
    }

    public List<SupplierJudicial> queryJudicial(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List judicials = this.supplierJudicialService.list((Wrapper)wrapper);
            if (judicials.size() > 0) {
                return judicials;
            }
        }
        return this.updateJudicials(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierJudicial> updateJudicials(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierJudicial> judicials = new ArrayList<SupplierJudicial>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.judicials") : this.configMap.get("tianyancha.old-judicials");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            judicials = JSON.parseArray((String)returnData.getString("items"), SupplierJudicial.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    judicials.addAll(this.judicials(requestObject, interfaceCode));
                }
            }
            for (SupplierJudicial judicial : judicials) {
                judicial.setElsAccount(elsAccount);
                judicial.setHeadId(enterpriseId);
                judicial.setDeleted(CommonConstant.DEL_FLAG_0);
                judicial.setDistinction(version);
                judicial.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierJudicialService.remove((Wrapper)wrapper);
            this.supplierJudicialService.saveBatch(judicials, 2000);
        }
        return judicials;
    }

    private List<SupplierJudicial> judicials(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierJudicial.class);
        }
        return null;
    }

    public List<SupplierLawsuit> queryLawsuit(RiskVO riskVO, ElsEnterpriseInfoDTO enterpriseInfo, String version) {
        if (!OLD.equals(riskVO.getUpdated())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseInfo.getId());
            wrapper.eq((Object)"distinction", (Object)version);
            List lawsuits = this.supplierLawsuitService.list((Wrapper)wrapper);
            if (lawsuits.size() > 0) {
                return lawsuits;
            }
        }
        return this.updateLawsuit(enterpriseInfo.getName(), enterpriseInfo.getId(), enterpriseInfo.getElsAccount(), version);
    }

    public List<SupplierLawsuit> updateLawsuit(String companyName, String enterpriseId, String elsAccount, String version) {
        List<SupplierLawsuit> lawsuits = new ArrayList<SupplierLawsuit>();
        JSONObject requestObject = new JSONObject();
        JSONObject object = new JSONObject();
        object.put("keyword", (Object)companyName);
        requestObject.put("base", (Object)object);
        String interfaceCode = null;
        interfaceCode = NEW.equals(version) ? this.configMap.get("tianyancha.lawsuit") : this.configMap.get("tianyancha.old-lawsuit");
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            lawsuits = JSON.parseArray((String)returnData.getString("items"), SupplierLawsuit.class);
            if (StringUtils.isNotBlank((CharSequence)returnData.getString("total")) && Integer.parseInt(returnData.getString("total")) > 20) {
                Integer total = Integer.parseInt(returnData.getString("total"));
                Integer pageCount = total / 20;
                if (total % 20 > 0) {
                    pageCount = pageCount + 1;
                }
                for (int i = 2; i <= pageCount; ++i) {
                    object.put("pageNum", (Object)i);
                    requestObject.put("base", (Object)object);
                    lawsuits.addAll(this.lawsuit(requestObject, interfaceCode));
                }
            }
            for (SupplierLawsuit supplierLawsuit : lawsuits) {
                supplierLawsuit.setElsAccount(elsAccount);
                supplierLawsuit.setHeadId(enterpriseId);
                supplierLawsuit.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierLawsuit.setDistinction(version);
                supplierLawsuit.setSupplierName(companyName);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)enterpriseId);
            wrapper.eq((Object)"distinction", (Object)version);
            this.supplierLawsuitService.remove((Wrapper)wrapper);
            this.supplierLawsuitService.saveBatch(lawsuits, 2000);
        }
        return lawsuits;
    }

    private List<SupplierLawsuit> lawsuit(JSONObject requestObject, String interfaceCode) {
        Result<?> response = TianyanchaResultAnaLysisUtils.callIpaas(this.invokeBaseRpcService, requestObject, SERVICE, interfaceCode);
        if (response.isSuccess()) {
            JSONObject returnData = (JSONObject)response.getResult();
            return JSON.parseArray((String)returnData.getString("items"), SupplierLawsuit.class);
        }
        return null;
    }
}

