/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.vmi.entity.VmiInventory;
import com.els.modules.vmi.rpc.service.VimInvokeMaterialRpcService;
import com.els.modules.vmi.service.VmiInventoryService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VmiInventoryImportImpl
implements ExcelImportRpcService {
    @Autowired
    private VmiInventoryService vmiInventoryService;
    @Resource
    private VimInvokeMaterialRpcService vimInvokeMaterialRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        LoginUser user = SysUtil.getLoginUser();
        HashMap<String, PurchaseMaterialHeadDTO> materialMap = new HashMap<String, PurchaseMaterialHeadDTO>();
        ArrayList<VmiInventory> list = new ArrayList<VmiInventory>();
        for (Map<String, Object> data : dataList) {
            VmiInventory vmiInventory = (VmiInventory)((Object)JSON.parseObject((String)JSON.toJSONString(data), VmiInventory.class));
            vmiInventory.setElsAccount(elsAccount);
            vmiInventory.setDeleted(CommonConstant.DEL_FLAG_0);
            vmiInventory.setCreateTime(new Date());
            vmiInventory.setCreateBy(user.getSubAccount());
            vmiInventory.setUpdateBy(vmiInventory.getCreateBy());
            vmiInventory.setUpdateTime(vmiInventory.getCreateTime());
            String materialNumber = vmiInventory.getMaterialNumber();
            PurchaseMaterialHeadDTO materialHead = null;
            if (materialMap.containsKey(materialNumber)) {
                materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
            } else {
                ArrayList<String> materialNumbers = new ArrayList<String>();
                materialNumbers.add(materialNumber);
                List<PurchaseMaterialHeadDTO> materialList = this.vimInvokeMaterialRpcService.list(materialNumbers);
                if (materialList.isEmpty()) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_material", (String)"\u7269\u6599\u7f16\u53f7\uff1a${0}\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01", (String[])new String[]{materialNumber}));
                }
                materialHead = materialList.get(0);
                materialMap.put(materialNumber, materialHead);
            }
            vmiInventory.setMaterialGroup(materialHead.getMaterialGroup());
            vmiInventory.setMaterialDesc(materialHead.getMaterialDesc());
            vmiInventory.setMaterialName(materialHead.getMaterialName());
            vmiInventory.setMaterialType(materialHead.getMaterialType());
            vmiInventory.setBrand(materialHead.getBrand());
            list.add(vmiInventory);
        }
        if (!list.isEmpty()) {
            this.vmiInventoryService.saveBatch(list, 200);
        }
    }
}

