/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.modules.vmi.entity.VmiBoard;
import com.els.modules.vmi.entity.VmiBoardHis;
import com.els.modules.vmi.entity.VmiInventory;
import com.els.modules.vmi.entity.VmiWaterLine;
import com.els.modules.vmi.mapper.VmiInventoryMapper;
import com.els.modules.vmi.service.VmiBoardHisService;
import com.els.modules.vmi.service.VmiBoardService;
import com.els.modules.vmi.service.VmiInventoryService;
import com.els.modules.vmi.service.VmiWaterLineService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VmiInventoryServiceImpl
extends ServiceImpl<VmiInventoryMapper, VmiInventory>
implements VmiInventoryService {
    @Autowired
    private VmiWaterLineService vmiWaterLineService;
    @Autowired
    private VmiBoardService vmiBoardService;
    @Autowired
    private VmiBoardHisService vmiBoardHisService;

    @Override
    public void saveVmiInventory(VmiInventory vmiInventory) {
        ((VmiInventoryMapper)this.baseMapper).insert((Object)vmiInventory);
    }

    @Override
    public void updateVmiInventory(VmiInventory vmiInventory) {
        ((VmiInventoryMapper)this.baseMapper).updateById((Object)vmiInventory);
    }

    @Override
    public void delVmiInventory(String id) {
        ((VmiInventoryMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchVmiInventory(List<String> idList) {
        ((VmiInventoryMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generateBoard(String elsAccount) {
        List vmiWaterLineList = this.vmiWaterLineService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        List vmiInventorList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
        Map<String, List<VmiInventory>> inventoryMap = vmiInventorList.stream().collect(Collectors.groupingBy(o -> o.getFactory() + o.getStorageLocation() + o.getMaterialNumber()));
        ArrayList<VmiBoard> boardList = new ArrayList<VmiBoard>();
        Date currentTime = new Date();
        for (VmiWaterLine line : vmiWaterLineList) {
            VmiBoard board = new VmiBoard();
            BeanUtil.copyProperties((Object)((Object)line), (Object)((Object)board), (String[])new String[0]);
            board.setId(null);
            board.setCreateBy("sys");
            board.setCreateTime(currentTime);
            board.setUpdateBy("sys");
            board.setUpdateTime(currentTime);
            board.setElsAccount(elsAccount);
            board.setDeleted(CommonConstant.DEL_FLAG_0);
            board.setMaterialType(null);
            board.setCateCode(null);
            board.setBrand(null);
            board.setLeadTime(null);
            board.setReceivingTime(null);
            VmiInventory inventory = null;
            String key = line.getFactory() + line.getStorageLocation() + line.getMaterialNumber();
            if (inventoryMap.containsKey(key)) {
                inventory = inventoryMap.get(key).get(0);
            }
            BigDecimal standingStock = BigDecimal.ZERO;
            if (inventory != null) {
                board.setOnWayQuantity(inventory.getOnWayStock());
                standingStock = inventory.getUrestrictedStock() != null ? inventory.getUrestrictedStock() : BigDecimal.ZERO;
            }
            board.setStandingStock(standingStock);
            BigDecimal onWayQuantity = board.getOnWayQuantity() != null ? board.getOnWayQuantity() : BigDecimal.ZERO;
            String supplySource = line.getSupplySource();
            if ("1".equals(supplySource)) {
                board.setSupplyStock(standingStock);
            } else {
                board.setSupplyStock(standingStock.add(onWayQuantity));
            }
            BigDecimal storageUpper = line.getStorageUpper() != null ? line.getStorageUpper() : BigDecimal.ZERO;
            BigDecimal storageDownline = line.getStorageDownline() != null ? line.getStorageDownline() : BigDecimal.ZERO;
            BigDecimal replenishmentPoints = line.getReplenishmentPoints() != null ? line.getReplenishmentPoints() : BigDecimal.ZERO;
            board.setMaxReplenishmentQuantity(storageUpper.subtract(standingStock).subtract(onWayQuantity));
            board.setMinReplenishmentQuantity(replenishmentPoints.subtract(standingStock).subtract(onWayQuantity));
            String warningStandard = line.getWarningStandard();
            standingStock = standingStock.add(onWayQuantity);
            if ("2".equals(warningStandard)) {
                storageUpper = storageUpper.add(replenishmentPoints);
                storageDownline = storageDownline.add(replenishmentPoints);
            }
            if (standingStock.compareTo(storageUpper) > 0) {
                board.setWarning("\u8d85\u91cf");
            } else if (standingStock.compareTo(storageDownline) < 0) {
                board.setWarning("\u7f3a\u6599");
            } else {
                board.setWarning("\u6b63\u5e38");
            }
            boardList.add(board);
        }
        this.saveHis(elsAccount);
        this.vmiBoardService.deleteByAccount(elsAccount);
        this.vmiBoardService.saveBatch(boardList, 200);
    }

    private void saveHis(String elsAccount) {
        List boardList = this.vmiBoardService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        String versionNumber = DateUtil.formatDateTime((Date)new Date());
        ArrayList<VmiBoardHis> boardHisList = new ArrayList<VmiBoardHis>();
        for (VmiBoard board : boardList) {
            VmiBoardHis his = new VmiBoardHis();
            BeanUtil.copyProperties((Object)((Object)board), (Object)((Object)his), (String[])new String[0]);
            his.setId(null);
            his.setVersionNumber(versionNumber);
            boardHisList.add(his);
        }
        if (!boardHisList.isEmpty()) {
            this.vmiBoardHisService.saveBatch(boardHisList, 200);
        }
    }
}

