/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.enumerate.PerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.excel.PurchasePerformanceReportHeadExportServiceImpl;
import com.els.modules.performance.mapper.PurchasePerformanceReportHeadMapper;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/performance/purchasePerformanceReportHead"})
@Api(tags={"\u91c7\u8d2d\u7ee9\u6548"})
public class PurchasePerformanceReportHeadController
extends BaseController<PurchasePerformanceReportHead, PurchasePerformanceReportHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReportHeadController.class);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;
    @Autowired
    private PurchasePerformanceReportGradService purchasePerformanceReportGradService;
    @Autowired
    private PurchasePerformanceReportHeadMapper purchasePerformanceReportHeadMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="performanceReport")
    public Result<?> queryPageList(PurchasePerformanceReportHead purchasePerformanceReportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceReportHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceReportHeadService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            return Result.ok((Object)pageList);
        }
        List headIds = pageList.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{PurchasePerformanceReportItem::getHeadId, PurchasePerformanceReportItem::getScorer}).in(PurchasePerformanceReportItem::getScoringMethod, (Collection)Lists.newArrayList((Object[])new String[]{ScoreMethodEnum.MANUAL_SCORE_NORM.getValue(), ScoreMethodEnum.MANUAL_SCORE.getValue()}))).in(PurchasePerformanceReportItem::getHeadId, headIds);
        List itemList = this.purchasePerformanceReportItemService.list((Wrapper)wrapper);
        Map groupMap = itemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItem::getHeadId, Collectors.mapping(PurchasePerformanceReportItem::getScorer, Collectors.toList())));
        IPage result = (IPage)Convert.convert(IPage.class, (Object)pageList);
        String subAccount = SysUtil.getLoginUser().getSubAccount() + "_" + SysUtil.getLoginUser().getRealname();
        List voList = Convert.toList(PurchasePerformanceReportHeadVO.class, (Object)pageList.getRecords());
        for (PurchasePerformanceReportHeadVO vo : voList) {
            List list = groupMap.get(vo.getId());
            if (CollUtil.isNotEmpty(list)) {
                List collect = list.stream().filter(CharSequenceUtil::isNotEmpty).map(x -> x.split("_")[0]).collect(Collectors.toList());
                if (list.contains(subAccount) || collect.contains(SysUtil.getLoginUser().getSubAccount())) {
                    vo.setCanScorer(true);
                    continue;
                }
            }
            vo.setCanScorer(false);
        }
        result.setRecords(voList);
        return Result.ok((Object)result);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u6dfb\u52a0", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        purchasePerformanceReportHead.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
        purchasePerformanceReportHead.setRequiredSend(StrUtil.blankToDefault((CharSequence)purchasePerformanceReportHeadPage.getRequiredSend(), (String)"0"));
        purchasePerformanceReportHead.setRequiredAudit(StrUtil.blankToDefault((CharSequence)purchasePerformanceReportHeadPage.getRequiredAudit(), (String)"1"));
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
        purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchasePerformanceReportHeadService.saveMain(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u7f16\u8f91", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"PurchasePerformanceReportHead:edit"})
    public Result<?> edit(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        if (!PerformanceReportStatusEnum.NEW.getValue().equals(purchasePerformanceReportHeadPage.getReportStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXsBIhxWxqAt_1b86d147", (String)"\u7ee9\u6548\u62a5\u8868\u5df2\u53d1\u5e03,\u4e0d\u53ef\u7f16\u8f91"));
        }
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        if ("1".equals(purchasePerformanceReportHead.getRequiredAudit())) {
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePerformanceReportHead.setRequiredAudit("0");
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setPerformanceRate(null);
        purchasePerformanceReportHead.setPerformanceScore(null);
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList()) {
            purchasePerformanceReportItem.setScoreTime(null);
            purchasePerformanceReportItem.setScore(null);
            purchasePerformanceReportItem.setNormValue(null);
        }
        this.purchasePerformanceReportHeadService.updateMain(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u8bc4\u5206")
    @ApiOperation(value="\u8bc4\u5206", notes="\u8bc4\u5206")
    @PostMapping(value={"/evaOpt"})
    @RequiresPermissions(value={"PurchasePerformanceReportHead:evaOpt"})
    public Result<?> evaOpt(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        this.purchasePerformanceReportHeadService.evaOpt(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548")
    @ApiOperation(value="\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548", notes="\u62c9\u53d6\u6700\u65b0\u7684\u7ee9\u6548")
    @GetMapping(value={"/getLastPerformance"})
    @PermissionDataView(businessType="performanceReport")
    public Result<?> getLastPerformance(@RequestParam String toElsAccount) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchasePerformanceReportHead::getToElsAccount, (Object)toElsAccount);
        lambdaQueryWrapper.eq(PurchasePerformanceReportHead::getReportStatus, (Object)PerformanceReportStatusEnum.EVA_COMPLETED.getValue());
        lambdaQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        lambdaQueryWrapper.last("limit 1");
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadMapper.selectOne((Wrapper)lambdaQueryWrapper));
        return Result.ok((Object)((Object)purchasePerformanceReportHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u53d1\u5e03", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        if (!PerformanceReportStatusEnum.NEW.getValue().equals(purchasePerformanceReportHeadPage.getReportStatus())) {
            throw new ELSBootException("\u7ee9\u6548\u62a5\u8868\u5df2\u53d1\u5e03");
        }
        this.purchasePerformanceReportHeadService.performancePublish(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u53d1\u9001", logType=2, busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody PurchasePerformanceReportHeadVO purchasePerformanceReportHeadPage) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHeadPage), (Object)((Object)purchasePerformanceReportHead));
        purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
        this.purchasePerformanceReportHeadService.sendReportToSale(purchasePerformanceReportHead, purchasePerformanceReportHeadPage.getPurchasePerformanceReportItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u901a\u8fc7id\u5220\u9664", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"PurchasePerformanceReportHead:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchasePerformanceReportHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u6279\u91cf\u5220\u9664", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchasePerformanceReportHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u901a\u8fc7id\u67e5\u8be2", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)id)));
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectItemByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(purchasePerformanceReportItemList);
        if (CharSequenceUtil.isNotBlank((CharSequence)purchasePerformanceReportHead.getPerformanceTemplateId())) {
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradService.selectByMainId(purchasePerformanceReportHead.getId());
            purchasePerformanceReportHeadVO.setPurchasePerformanceNormGradList(gradList);
        }
        return Result.ok((Object)((Object)purchasePerformanceReportHeadVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548-\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868", notes="\u901a\u8fc7id\u67e5\u8be2\u8bc4\u5206\u5217\u8868")
    @GetMapping(value={"/queryEvaById"})
    public Result<?> queryEvaById(@RequestParam(name="id", required=true) String id) {
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)id)));
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItem> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectByMainId(id);
        String subAccount = this.getCurrentUser().getSubAccount();
        List itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod()) && CharSequenceUtil.isNotBlank((CharSequence)o.getSubAccount()) && o.getSubAccount().split("_")[0].equals(subAccount)).collect(Collectors.toList());
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(Convert.toList(PurchasePerformanceReportItemDto.class, itemList));
        return Result.ok((Object)((Object)purchasePerformanceReportHeadVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ee9\u6548\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf", busModule="\u7ee9\u6548\u7ba1\u7406")
    @ApiOperation(value="\u91c7\u8d2d\u7ee9\u6548\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf", notes="\u91c7\u8d2d\u7ee9\u6548\u62a5\u8868-\u4f9b\u5e94\u5546\u753b\u50cf")
    @GetMapping(value={"/getSupplierScore"})
    public Result<?> getSupplierCategoryScore(@RequestParam(name="toElsAccount") String toElsAccount) {
        List<PurchasePerformanceReportItem> list = this.purchasePerformanceReportHeadService.getSupplierScore(toElsAccount);
        return Result.ok(list);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7ee9\u6548id\u67e5\u8be2\u91c7\u8d2d\u7ee9\u6548\u62a5\u8868\u884c\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u7ee9\u6548id\u67e5\u8be2\u91c7\u8d2d\u7ee9\u6548\u62a5\u8868\u884c\u8868")
    @GetMapping(value={"/queryPurchasePerformanceReportItemByMainId"})
    public Result<?> queryPurchasePerformanceReportItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchasePerformanceReportItem> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectByMainId(id);
        return Result.ok(purchasePerformanceReportItemList);
    }

    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"PurchasePerformanceReportHead:export"})
    @PermissionDataView(businessType="performanceReport")
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchasePerformanceReportHeadExportServiceImpl.class);
    }
}

