/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.enums.WorkFlowType;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceResultAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceResultAdapter.class);
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceReportItemService purchasePerformanceReportItemService;
    @Autowired
    private PurchasePerformanceReportGradService purchasePerformanceReportGradService;
    @Autowired
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SalePerformanceReportHeadService salePerformanceReportHeadService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        String operataion = "resultSubmitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "resultSubmitAudit";
        }
        this.sendMsg(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, operataion, SysUtil.getLoginUser());
    }

    private PurchasePerformanceReportHeadVO getReportHeadVo(PurchasePerformanceReportHead head, String id) {
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = this.purchasePerformanceReportItemService.selectItemByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(purchasePerformanceReportItemList);
        if (CharSequenceUtil.isNotBlank((CharSequence)head.getPerformanceTemplateId())) {
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradService.selectByMainId(id);
            purchasePerformanceReportHeadVO.setPurchasePerformanceNormGradList(gradList);
        }
        return purchasePerformanceReportHeadVO;
    }

    private MsgParamsVO parameterAssemble(PurchasePerformanceReportHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.supplierInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        msgParamsVO.setReceiverMap(receiverMap);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)((Object)head)));
        jsonObject.put("auditOpinion", (Object)inputParamVO.getAuditOpinion());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        String[] arrays = account.split("_");
        if (arrays.length > 2) {
            paramObj.put("taskId", (Object)arrays[2]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void sendMsg(PurchasePerformanceReportHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType, LoginUser loginUser) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"performanceReport", (String)optType, (MsgParamsVO)msgParamsVO, (LoginUser)loginUser);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"performanceReport", (String)optType, (MsgParamsVO)msgParamsVO, (LoginUser)loginUser);
            }
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchasePerformanceReportHeadService.reportPerformanceResultToSupplier(head);
        this.sendMsg(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, "resultAuditPass", loginUser);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        MsgParamsVO msgParamsVO = this.parameterAssemble(this.getReportHeadVo(head, inputParamVO.getBusinessId()), inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"performanceReport", (String)"resultAuditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        head.setWorkFlowType(outputParamVO.getBpmnType());
        boolean count = this.purchasePerformanceReportHeadService.updateById((Object)head);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

