/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.enumerate.PerformanceTemplateEffectiveStatusEnum;
import com.els.modules.performance.service.PurchasePerformanceTemplateGradService;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.modules.performance.service.PurchasePerformanceTemplateItemService;
import com.els.modules.performance.vo.PurchasePerformanceTemplateHeadVO;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePerformanceTemplateAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;
    @Autowired
    private PurchasePerformanceTemplateItemService purchasePerformanceTemplateItemService;
    @Autowired
    private PurchasePerformanceTemplateGradService purchasePerformanceTemplateGradService;
    @Autowired
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchasePerformanceTemplateHeadVO headVO = (PurchasePerformanceTemplateHeadVO)((Object)JSON.parseObject((String)params, PurchasePerformanceTemplateHeadVO.class));
        PurchasePerformanceTemplateHead purchasePerformanceTemplateHead = new PurchasePerformanceTemplateHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchasePerformanceTemplateHead));
        purchasePerformanceTemplateHead.setAuditStatus(outputParamVO.getAuditStatus());
        purchasePerformanceTemplateHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchasePerformanceTemplateHeadService.updateMain(purchasePerformanceTemplateHead, headVO.getPurchasePerformanceTemplateItemList(), headVO.getPurchasePerformanceTemplateGradList());
        this.sendMsg(headVO, inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)this.purchasePerformanceTemplateHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (head.getEffectiveDate().before((Date)DateUtil.date())) {
            head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
        }
        this.updateTemplate(head, inputParamVO, outputParamVO);
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchasePerformanceTemplateHeadVO headVO = (PurchasePerformanceTemplateHeadVO)((Object)JSON.parseObject((String)params, PurchasePerformanceTemplateHeadVO.class));
        this.sendMsg(headVO, inputParamVO, outputParamVO, "auditPass");
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateTemplate(null, inputParamVO, outputParamVO);
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchasePerformanceTemplateHeadVO headVO = (PurchasePerformanceTemplateHeadVO)((Object)JSON.parseObject((String)params, PurchasePerformanceTemplateHeadVO.class));
        MsgParamsVO msgParamsVO = this.parameterAssemble(headVO, inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"performanceTemplate", (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateTemplate(null, inputParamVO, outputParamVO);
    }

    private void updateTemplate(PurchasePerformanceTemplateHead head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        head = (PurchasePerformanceTemplateHead)((Object)ObjectUtil.defaultIfNull((Object)((Object)head), (Object)((Object)new PurchasePerformanceTemplateHead())));
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchasePerformanceTemplateHeadService.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(PurchasePerformanceTemplateHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.supplierInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        msgParamsVO.setReceiverMap(receiverMap);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)((Object)head)));
        jsonObject.put("auditOpinion", (Object)inputParamVO.getAuditOpinion());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        String[] arrays = account.split("_");
        if (arrays.length > 2) {
            paramObj.put("taskId", (Object)arrays[2]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void sendMsg(PurchasePerformanceTemplateHeadVO head, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"performanceTemplate", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(head, inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"performanceTemplate", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }
}

