/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.enumerate.SupplierInfoChangStatusEnum;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierInfoChangeItemService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierInfoChangeHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868"})
public class SupplierInfoChangeHeadController
extends BaseController<SupplierInfoChangeHead, SupplierInfoChangeHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SupplierInfoChangeHeadController.class);
    @Autowired
    private SupplierInfoChangeHeadService supplierInfoChangeHeadService;
    @Autowired
    private SupplierInfoChangeItemService supplierInfoChangeItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SupplierInfoChangeHead supplierInfoChangeHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierInfoChangeHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)o.isNull((Object)"publish_status")).or()).ne((Object)"publish_status", (Object)"0");
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierInfoChangeHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    public Result<?> queryTabsCount(SupplierInfoChangeHead supplierInfoChangeHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierInfoChangeHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)o.isNull((Object)"publish_status")).or()).ne((Object)"publish_status", (Object)"0");
        });
        queryWrapper.groupBy((Object)"status");
        List list = ((SupplierInfoChangeHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierInfoChangeHead::getStatus, SupplierInfoChangeHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List<String> statuses = SupplierInfoChangStatusEnum.getAllValue();
        for (String status : statuses) {
            Integer total = countMap.get(status) == null ? Integer.valueOf(0) : countMap.get(status);
            result.add(new CountVO(SupplierInfoChangStatusEnum.getByValue(status), "status", status, total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/supplierList"})
    public Result<?> supplierlist(SupplierInfoChangeHead supplierInfoChangeHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierInfoChangeHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.isNotNull((Object)"publish_status");
        IPage pageList = this.supplierInfoChangeHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2-\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2-\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/supplierCount"})
    public Result<?> supplierQueryTabsCount(SupplierInfoChangeHead supplierInfoChangeHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierInfoChangeHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.isNotNull((Object)"publish_status");
        queryWrapper.groupBy((Object)"status");
        List list = ((SupplierInfoChangeHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierInfoChangeHead::getStatus, SupplierInfoChangeHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List<String> statuses = SupplierInfoChangStatusEnum.getAllValue();
        for (String status : statuses) {
            Integer total = countMap.get(status) == null ? Integer.valueOf(0) : countMap.get(status);
            result.add(new CountVO(SupplierInfoChangStatusEnum.getByValue(status), "status", status, total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        this.supplierInfoChangeHeadService.saveMain(supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterDataPage));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868-\u63d0\u4ea4")
    @ApiOperation(value="\u4fee\u6539", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        this.supplierInfoChangeHeadService.submit(supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterDataPage));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        this.supplierInfoChangeHeadService.saveMain(supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterDataPage));
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierInfoChangeHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        this.supplierInfoChangeHeadService.invalidById(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u901a\u8fc7id\u53d1\u5e03")
    @ApiOperation(value="\u901a\u8fc7id\u53d1\u5e03", notes="\u901a\u8fc7id\u53d1\u5e03")
    @GetMapping(value={"/releaseByIds"})
    public Result<?> releaseByIds(@RequestParam(name="id") String ids) {
        this.supplierInfoChangeHeadService.releaseByIds(ids);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u901a\u8fc7id\u786e\u8ba4")
    @ApiOperation(value="\u901a\u8fc7id\u786e\u8ba4", notes="\u901a\u8fc7id\u786e\u8ba4")
    @GetMapping(value={"/confirm"})
    public Result<?> confirm(@RequestParam(name="id") String id) {
        this.supplierInfoChangeHeadService.confirmById(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u901a\u8fc7id\u9a73\u56de")
    @ApiOperation(value="\u901a\u8fc7id\u9a73\u56de", notes="\u901a\u8fc7id\u9a73\u56de")
    @GetMapping(value={"/rejected"})
    public Result<?> rejected(@RequestParam(name="id") String id) {
        this.supplierInfoChangeHeadService.rejectedById(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierInfoChangeHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u7684\u660e\u7ec6", notes="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u7684\u660e\u7ec6")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.supplierInfoChangeHeadService.getDataById(id));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u7684\u660e\u7ec6", notes="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u7684\u660e\u7ec6")
    @GetMapping(value={"/queryAfterInfoById"})
    public Result<?> queryAfterInfoById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierInfoChangeHeadService.getAfterDataById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2-\u83b7\u53d6\u53d8\u66f4\u4fe1\u606f")
    @GetMapping(value={"/getInfoChangById"})
    public Result<?> getInfoChangById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierInfoChangeHeadService.getInfoChangById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868id\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u884c\u8868", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5934\u8868id\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u884c\u8868")
    @GetMapping(value={"/querySupplierInfoChangeItemByMainId"})
    public Result<?> querySupplierInfoChangeItemListByMainId(@RequestParam(name="id") String id) {
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemService.selectByMainId(id);
        return Result.ok(supplierInfoChangeItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u627e\u662f\u5426\u5b58\u5728\u65b0\u5efa\u548c\u5f85\u786e\u8ba4\u7684\u5355\u636e", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u627e\u662f\u5426\u5b58\u5728\u65b0\u5efa\u548c\u5f85\u786e\u8ba4\u7684\u5355\u636e")
    @GetMapping(value={"/isHaveNewAndWaitConfirm"})
    public Result<?> isHaveNewAndWaitConfirm(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.supplierInfoChangeHeadService.isHaveNewAndWaitConfirm(id));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eID\u83b7\u53d6\u6709\u6548\u7684\u5217\u8868\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eID\u83b7\u53d6\u6709\u6548\u7684\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/getEffectiveListBySupplierId"})
    public Result<?> getEffectiveListBySupplierId(@RequestParam(name="id") String id) {
        return Result.ok(this.supplierInfoChangeHeadService.getEffectiveListBySupplierId(id));
    }
}

