/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierBankDataExcelHandler")
public class SupplierBankDataExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierBankInfo> bankInfos = new ArrayList<SupplierBankInfo>();
        for (Map<String, Object> data : dataList) {
            SupplierBankInfo entity = (SupplierBankInfo)((Object)JSON.parseObject((String)JSON.toJSONString(data), SupplierBankInfo.class));
            if (StringUtils.isBlank((CharSequence)entity.getElsAccount())) continue;
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            bankInfos.add(entity);
        }
        List<String> elsAccountList = bankInfos.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getElsAccount())).map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> accountList = this.elsEnterpriseInfoService.queryByElsAccountList(elsAccountList);
        Map accountMap = accountList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        int size = bankInfos.size();
        for (int i = size - 1; i >= 0; --i) {
            ((SupplierBankInfo)((Object)bankInfos.get(i))).setToElsAccount(SysUtil.getLoginUser().getElsAccount());
            String elsAccount = ((SupplierBankInfo)((Object)bankInfos.get(i))).getElsAccount();
            if (!StrUtil.isEmpty((CharSequence)elsAccount) && null != accountMap.get(elsAccount)) continue;
            bankInfos.remove(i);
        }
        this.supplierBankInfoService.saveBatch(bankInfos);
        return dataList;
    }
}

