/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.message.listener;

import com.alibaba.fastjson.JSON;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataImportVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterDataImportMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataImportMessageConsumer.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;

    @StreamListener(value="inputSupImport")
    public void receive(String msgBody) {
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log:  " + msgBody);
        try {
            SupplierMasterDataImportVo importVo = (SupplierMasterDataImportVo)JSON.parseObject((String)msgBody, SupplierMasterDataImportVo.class);
            this.supplierMasterDataService.importSupplierMasterDataAsynsDo(importVo);
            log.info(msgBody);
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log failed:", (Throwable)e);
        }
    }
}

