/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.SaleCertificatedInfo;
import com.els.modules.supplier.mapper.PurchaseCertificatedInfoMapper;
import com.els.modules.supplier.mapper.SaleCertificatedInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SaleCertificatedInfoService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleCertificatedInfoServiceImpl
extends BaseServiceImpl<SaleCertificatedInfoMapper, SaleCertificatedInfo>
implements SaleCertificatedInfoService {
    @Autowired
    private SaleCertificatedInfoMapper saleCertificatedInfoMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private PurchaseCertificatedInfoMapper purchaseCertificatedInfoMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleCertificatedInfo saleCertificatedInfo, List<SaleAttachmentDTO> saleAttachmentList) {
        TemplateHeadDTO templateHead;
        ElsEnterpriseInfoDTO enterpriseInfo;
        saleCertificatedInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        saleCertificatedInfo.setSendStatus("0");
        saleCertificatedInfo.setFail("0");
        saleCertificatedInfo.setCreateAccount(TenantContext.getTenant());
        saleCertificatedInfo.setBusAccount(saleCertificatedInfo.getToElsAccount());
        if (StringUtils.isBlank((CharSequence)saleCertificatedInfo.getPurchaseName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(saleCertificatedInfo.getToElsAccount())) != null) {
            saleCertificatedInfo.setPurchaseName(enterpriseInfo.getName());
        }
        saleCertificatedInfo.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)saleCertificatedInfo.getTemplateName()) && StringUtils.isNotBlank((CharSequence)saleCertificatedInfo.getTemplateNumber()) && StringUtils.isBlank((CharSequence)saleCertificatedInfo.getTemplateVersion()) && (templateHead = this.invokeBaseRpcService.getById(saleCertificatedInfo.getTemplateNumber())) != null) {
            saleCertificatedInfo.setTemplateName(templateHead.getTemplateName());
            saleCertificatedInfo.setTemplateNumber(templateHead.getTemplateNumber());
            saleCertificatedInfo.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            saleCertificatedInfo.setTemplateAccount(templateHead.getElsAccount());
        }
        this.saleCertificatedInfoMapper.insert((Object)saleCertificatedInfo);
        this.insertData(saleCertificatedInfo, saleAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleCertificatedInfo saleCertificatedInfo, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleCertificatedInfoMapper.updateById((Object)saleCertificatedInfo);
        this.invokeBaseRpcService.deleteSaleAttachment(saleCertificatedInfo.getId());
        this.insertData(saleCertificatedInfo, saleAttachmentList);
    }

    private void insertData(SaleCertificatedInfo saleCertificatedInfo, List<SaleAttachmentDTO> saleAttachmentList) {
        if (saleAttachmentList != null) {
            for (SaleAttachmentDTO entity : saleAttachmentList) {
                entity.setId(null);
                entity.setSendStatus("0");
                entity.setHeadId(saleCertificatedInfo.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)saleCertificatedInfo);
            }
            if (!saleAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleBatchSomeColumn(saleAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deleteSaleAttachment(id);
        this.saleCertificatedInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deleteSaleAttachment(serializable.toString());
            this.saleCertificatedInfoMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void send(SaleCertificatedInfo saleCertificatedInfo, List<SaleAttachmentDTO> saleAttachmentList) {
        saleCertificatedInfo.setSendStatus("1");
        PurchaseCertificatedInfo certificatedInfo = new PurchaseCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)saleCertificatedInfo), (Object)((Object)certificatedInfo));
        certificatedInfo.setElsAccount(saleCertificatedInfo.getToElsAccount());
        certificatedInfo.setToElsAccount(saleCertificatedInfo.getElsAccount());
        certificatedInfo.setRelationId(saleCertificatedInfo.getId());
        this.purchaseCertificatedInfoMapper.insert((Object)certificatedInfo);
        saleCertificatedInfo.setRelationId(certificatedInfo.getId());
        this.saleCertificatedInfoMapper.updateById((Object)saleCertificatedInfo);
        if (saleAttachmentList != null) {
            AttachmentSendDTO sendDTO = new AttachmentSendDTO();
            sendDTO.setHeadId(saleCertificatedInfo.getId());
            sendDTO.setElsAccount(saleCertificatedInfo.getElsAccount());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(certificatedInfo.getId(), certificatedInfo.getElsAccount());
            sendDTO.setToSend(map);
            this.invokeBaseRpcService.sendSaleFile(sendDTO);
        }
    }

    @Override
    public void loseEfficacy(String id) {
        SaleCertificatedInfo certificatedInfo = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)id)));
        if (certificatedInfo != null) {
            certificatedInfo.setFail("1");
            this.saleCertificatedInfoMapper.updateById((Object)certificatedInfo);
            PurchaseCertificatedInfo purchaseCertificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoMapper.selectById((Serializable)((Object)certificatedInfo.getRelationId())));
            purchaseCertificatedInfo.setFail(certificatedInfo.getFail());
            this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        }
    }
}

