/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.entity.SupplierMasterCustom1;
import com.els.modules.supplier.entity.SupplierMasterCustom10;
import com.els.modules.supplier.entity.SupplierMasterCustom2;
import com.els.modules.supplier.entity.SupplierMasterCustom3;
import com.els.modules.supplier.entity.SupplierMasterCustom4;
import com.els.modules.supplier.entity.SupplierMasterCustom5;
import com.els.modules.supplier.entity.SupplierMasterCustom6;
import com.els.modules.supplier.entity.SupplierMasterCustom7;
import com.els.modules.supplier.entity.SupplierMasterCustom8;
import com.els.modules.supplier.entity.SupplierMasterCustom9;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierDictEnum;
import com.els.modules.supplier.mapper.SupplierInfoChangeHeadMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeItemMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.util.BeanComparatorUtils;
import com.els.modules.supplier.util.assist.SupplierFiledJointAssist;
import com.els.modules.supplier.util.assist.SupplierFiledRecordAssist;
import com.els.modules.supplier.vo.FieldRecordVo;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierInfoChangeHeadServiceImpl
extends BaseServiceImpl<SupplierInfoChangeHeadMapper, SupplierInfoChangeHead>
implements SupplierInfoChangeHeadService {
    @Autowired
    private SupplierInfoChangeHeadMapper supplierInfoChangeHeadMapper;
    @Autowired
    private SupplierInfoChangeItemMapper supplierInfoChangeItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private RedisUtil redisUtil;
    private final String INFOCHANGE_KEY = "supplier:supplierinfochange:";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierMasterDataVO supplierMasterDataVO) {
        String optElsAccount = supplierMasterDataVO.getElsAccount();
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataVO), (Object)((Object)masterData));
        String needAudit = StringUtils.isNotBlank((CharSequence)masterData.getNeedAudit()) ? masterData.getNeedAudit() : "0";
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        String changeId = supplierMasterDataVO.getSupplierInfoChangeId();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)changeId)));
        } else {
            String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead);
            supplierInfoChangeHead.setChangeNumber(changeNumber);
        }
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(supplierMasterDataVO.getSupplierInfoChangeAttachmentList()));
        if (!optElsAccount.equals(elsAccount)) {
            supplierInfoChangeHead.setPublishStatus("0");
        }
        if (StringUtils.isBlank((CharSequence)supplierInfoChangeHead.getPublishStatus())) {
            if (needAudit.equals("0")) {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("4");
            } else {
                supplierInfoChangeHead.setNeedAudit(needAudit);
                supplierInfoChangeHead.setAuditStatus("0");
            }
        }
        supplierInfoChangeHead.setStatus("0");
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        } else {
            this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        }
        supplierMasterDataVO.setSupplierInfoChangeId(supplierInfoChangeHead.getId());
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            supplierInfoChangeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeId).get(0);
        }
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeItem.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)supplierMasterDataVO)));
        List<SupplierAddressInfo> addressInfoList = supplierMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = supplierMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = supplierMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = supplierMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = supplierMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = supplierMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = supplierMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = supplierMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = supplierMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = supplierMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = supplierMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = supplierMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = supplierMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = supplierMasterDataVO.getSupplierMasterCustom10List();
        SupplierMasterDataVO oldMasterDataVO = this.supplierMasterDataService.getDataById(supplierMasterDataVO.getId());
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        supplierMasterDataVO.setAccessCategory(accessCategroy);
        Map masterDataMap = BeanComparatorUtils.compareBeanToMap((Object)oldMasterDataVO, (Object)supplierMasterDataVO);
        List<FieldRecordVo> list = this.getComparatorField(masterDataMap, "headData", oldMasterData.getId(), "1");
        list.addAll(SupplierFiledRecordAssist.getSupplierAddressInfoFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierBankInfoFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierContactsInfoFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierOrgInfoFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom1FiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom2FiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom3FiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom4FiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom5FiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom6FiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom7FiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom8FiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom9FiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom10FiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List));
        if (!list.isEmpty() && list.size() > 0) {
            supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        }
        if (StringUtils.isNotBlank((CharSequence)changeId)) {
            this.supplierInfoChangeItemMapper.updateById((Object)supplierInfoChangeItem);
        } else {
            this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        }
    }

    @Override
    public void insertPurchaseInfoChang(List<SupplierMasterDataAndEnterpriseInfoDTO> purchaseList) {
        SupplierMasterDataVO newMasterDataVO = null;
        SupplierMasterDataVO oldMasterDataVO = null;
        ArrayList<String> supplierInfoChangeIds = new ArrayList<String>();
        for (SupplierMasterDataAndEnterpriseInfoDTO infoDTO : purchaseList) {
            newMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            newMasterDataVO = this.setPropertiesByEnterpriseInfo(newMasterDataVO, infoDTO.getElsEnterpriseInfoNew());
            List<SupplierContactsInfo> contactsInfoListNew = newMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListNew(), SupplierContactsInfo.class));
            newMasterDataVO.setSupplierContactsInfoList(contactsInfoListNew);
            List<SupplierAddressInfo> addressInfoListNew = newMasterDataVO.getSupplierAddressInfoList();
            addressInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListNew(), SupplierAddressInfo.class));
            newMasterDataVO.setSupplierAddressInfoList(addressInfoListNew);
            List<SupplierBankInfo> bankInfoListNew = newMasterDataVO.getSupplierBankInfoList();
            bankInfoListNew.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListNew(), SupplierBankInfo.class));
            newMasterDataVO.setSupplierBankInfoList(bankInfoListNew);
            oldMasterDataVO = (SupplierMasterDataVO)((Object)SysUtil.copyProperties((Object)infoDTO, SupplierMasterDataVO.class));
            oldMasterDataVO = this.setPropertiesByEnterpriseInfo(oldMasterDataVO, infoDTO.getElsEnterpriseInfoOld());
            List<SupplierContactsInfo> contactsInfoListOld = oldMasterDataVO.getSupplierContactsInfoList();
            contactsInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierContactsInfoListOld(), SupplierContactsInfo.class));
            oldMasterDataVO.setSupplierContactsInfoList(contactsInfoListOld);
            List<SupplierAddressInfo> addressInfoListOld = oldMasterDataVO.getSupplierAddressInfoList();
            addressInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierAddressInfoListOld(), SupplierAddressInfo.class));
            oldMasterDataVO.setSupplierAddressInfoList(addressInfoListOld);
            List<SupplierBankInfo> bankInfoListOld = oldMasterDataVO.getSupplierBankInfoList();
            bankInfoListOld.addAll(SysUtil.copyProperties((List)infoDTO.getSupplierBankInfoListOld(), SupplierBankInfo.class));
            oldMasterDataVO.setSupplierBankInfoList(bankInfoListOld);
            List purchaseAttachmentDTOList = JSONObject.parseArray((String)infoDTO.getSupplierInfoChangeAttachmentJson(), PurchaseAttachmentDTO.class);
            newMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            oldMasterDataVO.setSupplierInfoChangeAttachmentList(purchaseAttachmentDTOList);
            String infoChangId = this.insertPurchaseInfoChang(newMasterDataVO, oldMasterDataVO);
            supplierInfoChangeIds.add(infoChangId);
        }
        if (!supplierInfoChangeIds.isEmpty() && supplierInfoChangeIds.size() > 0) {
            this.redisUtil.set("supplier:supplierinfochange:purchaseIds", (Object)StringUtils.strip((String)((Object)supplierInfoChangeIds).toString(), (String)"[]"));
        }
    }

    @Override
    public boolean isExistUnconfirmed(String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"to_els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.isNotNull((Object)"publish_status");
        queryWrapper.and(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)o.and(t -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)t.eq((Object)"status", (Object)"0")).eq((Object)"publish_status", (Object)"0");
            })).or(k -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)k.eq((Object)"status", (Object)"3")).eq((Object)"publish_status", (Object)"1");
            });
        });
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(SupplierMasterDataVO supplierMasterDataVO) {
        String supplierInfoChangeId = supplierMasterDataVO.getSupplierInfoChangeId();
        SupplierInfoChangeHead supplierInfoChangeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)supplierInfoChangeId)));
        supplierInfoChangeHead.setNeedAudit("0");
        supplierInfoChangeHead.setAuditStatus("4");
        supplierInfoChangeHead.setStatus("1");
        this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(supplierInfoChangeId);
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierMasterDataVO supplierMasterDataVO) {
    }

    @Override
    public JSONObject getDataById(String id) {
        String elsAccount = TenantContext.getTenant();
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String beforeData = changeItem.getUpdateBeforeData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)beforeData, SupplierMasterDataVO.class));
        List<SupplierAddressInfo> addressInfoList = dataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = dataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = dataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = dataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = dataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = dataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = dataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = dataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = dataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = dataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = dataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = dataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = dataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = dataVO.getSupplierMasterCustom10List();
        String fieldData = changeItem.getUpdateFieldData();
        ArrayList recordVoList = JSONObject.parseArray((String)fieldData, FieldRecordVo.class);
        if (recordVoList == null) {
            recordVoList = new ArrayList();
        }
        List headRecordList = recordVoList.parallelStream().filter(o -> "headData".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> addressRecordList = recordVoList.parallelStream().filter(o -> "supplierAddressInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> bankRecordList = recordVoList.parallelStream().filter(o -> "supplierBankInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> contactsRecordList = recordVoList.parallelStream().filter(o -> "supplierContactsInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> orgRecordList = recordVoList.parallelStream().filter(o -> "supplierOrgInfoList".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom1RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom1List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom2RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom2List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom3RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom3List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom4RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom4List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom5RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom5List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom6RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom6List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom7RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom7List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom8RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom8List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom9RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom9List".equals(o.getGroup())).collect(Collectors.toList());
        List<FieldRecordVo> custom10RecordList = recordVoList.parallelStream().filter(o -> "supplierMasterCustom10List".equals(o.getGroup())).collect(Collectors.toList());
        JSONObject jsonObject = JSONObject.parseObject((String)beforeData);
        jsonObject = this.getDateTypeToString(jsonObject);
        jsonObject.put("infoChangId", (Object)changeHead.getId());
        jsonObject.put("supplierInfoChangeId", (Object)changeHead.getId());
        jsonObject.put("infoChangFlowId", (Object)changeHead.getFlowId());
        jsonObject.put("infoChangWorkFlowType", (Object)changeHead.getWorkFlowType());
        jsonObject.put("infoChangAuditStatus", (Object)changeHead.getAuditStatus());
        jsonObject.put("infoChangStatus", (Object)changeHead.getStatus());
        jsonObject.put("infoChangPublishStatus", (Object)changeHead.getPublishStatus());
        jsonObject.put("infoChangNeedAudit", (Object)changeHead.getNeedAudit());
        for (FieldRecordVo vo : headRecordList) {
            jsonObject.put(vo.getField() + "_new", (Object)vo.getFieldValue());
            if (!StringUtils.isNotBlank((CharSequence)SupplierDictEnum.getByField(vo.getField()))) continue;
            String[] split = vo.getFieldValue().split(",");
            StringBuilder textValue = new StringBuilder();
            List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(SupplierDictEnum.getByField(vo.getField()), elsAccount);
            for (String k : split) {
                if (textValue != null && !"".equals(textValue.toString())) {
                    textValue.append("\uff0c");
                }
                textValue.append(dictDTOS.parallelStream().filter(o -> o.getValue().equals(k)).map(DictDTO::getText).collect(Collectors.joining()));
            }
            jsonObject.put(vo.getField() + "_new_dictText", (Object)textValue.toString());
        }
        jsonObject.put("supplierAddressInfoList", (Object)SupplierFiledJointAssist.getAddressInfoJsonArray(addressInfoList, addressRecordList));
        jsonObject.put("supplierBankInfoList", (Object)SupplierFiledJointAssist.getBankInfoJsonArray(bankInfoList, bankRecordList));
        jsonObject.put("supplierContactsInfoList", (Object)SupplierFiledJointAssist.getContactsInfoJsonArray(contactsInfoList, contactsRecordList));
        jsonObject.put("supplierOrgInfoList", (Object)SupplierFiledJointAssist.getOrgInfoJsonArray(orgInfoList, orgRecordList));
        jsonObject.put("supplierInfoChangeAttachmentList", (Object)JSONObject.parseArray((String)changeHead.getFile(), PurchaseAttachmentDTO.class));
        jsonObject.put("supplierMasterCustom1List", (Object)SupplierFiledJointAssist.getCustom1JsonArray(custom1List, custom1RecordList));
        jsonObject.put("supplierMasterCustom2List", (Object)SupplierFiledJointAssist.getCustom2JsonArray(custom2List, custom2RecordList));
        jsonObject.put("supplierMasterCustom3List", (Object)SupplierFiledJointAssist.getCustom3JsonArray(custom3List, custom3RecordList));
        jsonObject.put("supplierMasterCustom4List", (Object)SupplierFiledJointAssist.getCustom4JsonArray(custom4List, custom4RecordList));
        jsonObject.put("supplierMasterCustom5List", (Object)SupplierFiledJointAssist.getCustom5JsonArray(custom5List, custom5RecordList));
        jsonObject.put("supplierMasterCustom6List", (Object)SupplierFiledJointAssist.getCustom6JsonArray(custom6List, custom6RecordList));
        jsonObject.put("supplierMasterCustom7List", (Object)SupplierFiledJointAssist.getCustom7JsonArray(custom7List, custom7RecordList));
        jsonObject.put("supplierMasterCustom8List", (Object)SupplierFiledJointAssist.getCustom8JsonArray(custom8List, custom8RecordList));
        jsonObject.put("supplierMasterCustom9List", (Object)SupplierFiledJointAssist.getCustom9JsonArray(custom9List, custom9RecordList));
        jsonObject.put("supplierMasterCustom10List", (Object)SupplierFiledJointAssist.getCustom10JsonArray(custom10List, custom10RecordList));
        return jsonObject;
    }

    @Override
    public SupplierMasterDataVO getAfterDataById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        List<SupplierInfoChangeItem> supplierInfoChangeItemList = this.supplierInfoChangeItemMapper.selectByMainId(id);
        SupplierInfoChangeItem changeItem = supplierInfoChangeItemList.get(0);
        String afterData = changeItem.getUpdateAfterData();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        dataVO.setSupplierInfoChangeId(id);
        return dataVO;
    }

    @Override
    public SupplierInfoChangeHead getInfoChangById(String id) {
        return (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierInfoChangeItemMapper.deleteByMainId(id);
        this.supplierInfoChangeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void invalidById(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setId(id);
            supplierInfoChangeHead.setStatus("2");
            this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        }
    }

    @Override
    public void releaseByIds(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List<String> ids = Arrays.asList(id.replace(" ", "").split(","));
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setStatus("3");
            supplierInfoChangeHead.setPublishStatus("1");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", ids);
            this.supplierInfoChangeHeadMapper.update((Object)supplierInfoChangeHead, (Wrapper)queryWrapper);
        }
    }

    @Override
    public void confirmById(String id) {
        SupplierInfoChangeHead changeHead = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        SupplierInfoChangeItem changeItem = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId()).get(0);
        String afterData = changeItem.getUpdateAfterData();
        changeHead.setStatus("4");
        this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)afterData, SupplierMasterDataVO.class));
        masterDataVO.setEnterpriseInfoRecordId("");
        this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
    }

    @Override
    public void rejectedById(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
            supplierInfoChangeHead.setId(id);
            supplierInfoChangeHead.setStatus("5");
            this.supplierInfoChangeHeadMapper.updateById((Object)supplierInfoChangeHead);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierInfoChangeItemMapper.deleteByMainId(serializable.toString());
            this.supplierInfoChangeHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public boolean isHaveNewAndWaitConfirm(String supplierId) {
        ArrayList<String> status = new ArrayList<String>();
        status.add("0");
        status.add("3");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.in((Object)"status", status);
        Integer count = this.supplierInfoChangeHeadMapper.selectCount((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public List<SupplierInfoChangeHead> getEffectiveListBySupplierId(String supplierId) {
        ArrayList<String> status = new ArrayList<String>();
        status.add("1");
        status.add("4");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.in((Object)"status", status);
        List list = this.supplierInfoChangeHeadMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String insertPurchaseInfoChang(SupplierMasterDataVO newMasterDataVO, SupplierMasterDataVO oldMasterDataVO) {
        List<SupplierAddressInfo> addressInfoList = newMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> bankInfoList = newMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> contactsInfoList = newMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> orgInfoList = newMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> custom1List = newMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> custom2List = newMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> custom3List = newMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> custom4List = newMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> custom5List = newMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> custom6List = newMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> custom7List = newMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> custom8List = newMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> custom9List = newMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> custom10List = newMasterDataVO.getSupplierMasterCustom10List();
        SupplierMasterData oldMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)oldMasterData));
        List<SupplierAddressInfo> oldAddressInfoList = oldMasterDataVO.getSupplierAddressInfoList();
        List<SupplierBankInfo> oldBankInfoList = oldMasterDataVO.getSupplierBankInfoList();
        List<SupplierContactsInfo> oldContactsInfoList = oldMasterDataVO.getSupplierContactsInfoList();
        List<SupplierOrgInfo> oldOrgInfoList = oldMasterDataVO.getSupplierOrgInfoList();
        List<SupplierMasterCustom1> oldCustom1List = oldMasterDataVO.getSupplierMasterCustom1List();
        List<SupplierMasterCustom2> oldCustom2List = oldMasterDataVO.getSupplierMasterCustom2List();
        List<SupplierMasterCustom3> oldCustom3List = oldMasterDataVO.getSupplierMasterCustom3List();
        List<SupplierMasterCustom4> oldCustom4List = oldMasterDataVO.getSupplierMasterCustom4List();
        List<SupplierMasterCustom5> oldCustom5List = oldMasterDataVO.getSupplierMasterCustom5List();
        List<SupplierMasterCustom6> oldCustom6List = oldMasterDataVO.getSupplierMasterCustom6List();
        List<SupplierMasterCustom7> oldCustom7List = oldMasterDataVO.getSupplierMasterCustom7List();
        List<SupplierMasterCustom8> oldCustom8List = oldMasterDataVO.getSupplierMasterCustom8List();
        List<SupplierMasterCustom9> oldCustom9List = oldMasterDataVO.getSupplierMasterCustom9List();
        List<SupplierMasterCustom10> oldCustom10List = oldMasterDataVO.getSupplierMasterCustom10List();
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)oldMasterDataVO), (Object)((Object)masterData));
        SupplierInfoChangeHead supplierInfoChangeHead = new SupplierInfoChangeHead();
        String changeNumber = this.invokeBaseRpcService.getNextCode("supplierInfoChangeNumber", (Object)supplierInfoChangeHead);
        supplierInfoChangeHead.setChangeNumber(changeNumber);
        supplierInfoChangeHead.setSupplierId(masterData.getId());
        supplierInfoChangeHead.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeHead.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeHead.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeHead.setSupplierName(masterData.getSupplierName());
        supplierInfoChangeHead.setTemplateAccount(masterData.getTemplateAccount());
        supplierInfoChangeHead.setTemplateName(masterData.getTemplateName());
        supplierInfoChangeHead.setTemplateNumber(masterData.getTemplateNumber());
        supplierInfoChangeHead.setTemplateVersion(masterData.getTemplateVersion());
        supplierInfoChangeHead.setSupplierCode(masterData.getSupplierCode());
        supplierInfoChangeHead.setFile(JSONObject.toJSONString(newMasterDataVO.getSupplierInfoChangeAttachmentList()));
        supplierInfoChangeHead.setStatus("0");
        supplierInfoChangeHead.setPublishStatus("0");
        this.supplierInfoChangeHeadMapper.insert((Object)supplierInfoChangeHead);
        SupplierInfoChangeItem supplierInfoChangeItem = new SupplierInfoChangeItem();
        supplierInfoChangeItem.setHeadId(supplierInfoChangeHead.getId());
        supplierInfoChangeItem.setChangeNumber(supplierInfoChangeHead.getChangeNumber());
        supplierInfoChangeItem.setInitiatorElsAccount(elsAccount);
        supplierInfoChangeItem.setElsAccount(masterData.getElsAccount());
        supplierInfoChangeItem.setToElsAccount(masterData.getToElsAccount());
        supplierInfoChangeItem.setUpdateAfterData(JSONObject.toJSONString((Object)((Object)newMasterDataVO)));
        supplierInfoChangeItem.setUpdateBeforeData(JSONObject.toJSONString((Object)((Object)oldMasterDataVO)));
        String accessCategroy = "";
        for (SupplierOrgInfo entity : orgInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)entity.getAccessCategory())) continue;
            accessCategroy = accessCategroy + entity.getAccessCategory() + ";";
        }
        newMasterDataVO.setAccessCategory(accessCategroy);
        Map masterDataMap = BeanComparatorUtils.compareBeanToMap((Object)oldMasterDataVO, (Object)newMasterDataVO);
        List<FieldRecordVo> list = this.getComparatorField(masterDataMap, "headData", oldMasterData.getId(), "1");
        list.addAll(SupplierFiledRecordAssist.getSupplierAddressInfoFiledRecord("supplierAddressInfoList", addressInfoList, oldAddressInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierBankInfoFiledRecord("supplierBankInfoList", bankInfoList, oldBankInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierContactsInfoFiledRecord("supplierContactsInfoList", contactsInfoList, oldContactsInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierOrgInfoFiledRecord("supplierOrgInfoList", orgInfoList, oldOrgInfoList));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom1FiledRecord("supplierMasterCustom1List", custom1List, oldCustom1List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom2FiledRecord("supplierMasterCustom2List", custom2List, oldCustom2List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom3FiledRecord("supplierMasterCustom3List", custom3List, oldCustom3List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom4FiledRecord("supplierMasterCustom4List", custom4List, oldCustom4List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom5FiledRecord("supplierMasterCustom5List", custom5List, oldCustom5List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom6FiledRecord("supplierMasterCustom6List", custom6List, oldCustom6List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom7FiledRecord("supplierMasterCustom7List", custom7List, oldCustom7List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom8FiledRecord("supplierMasterCustom8List", custom8List, oldCustom8List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom9FiledRecord("supplierMasterCustom9List", custom9List, oldCustom9List));
        list.addAll(SupplierFiledRecordAssist.getSupplierMasterCustom10FiledRecord("supplierMasterCustom10List", custom10List, oldCustom10List));
        if (!list.isEmpty() && list.size() > 0) {
            supplierInfoChangeItem.setUpdateFieldData(JSONObject.toJSONString(list));
        }
        this.supplierInfoChangeItemMapper.insert((Object)supplierInfoChangeItem);
        return supplierInfoChangeHead.getId();
    }

    private List<FieldRecordVo> getComparatorField(Map<String, Object> map, String group, String itemId, String updateType) {
        ArrayList<FieldRecordVo> list = new ArrayList<FieldRecordVo>();
        FieldRecordVo recordVo = null;
        Set<String> keys = map.keySet();
        for (String key : keys) {
            recordVo = new FieldRecordVo();
            recordVo.setGroup(group);
            recordVo.setItemId(itemId);
            recordVo.setUpdateType(updateType);
            recordVo.setField(key);
            recordVo.setFieldValue(map.get(key).toString());
            list.add(recordVo);
        }
        return list;
    }

    private JSONObject getDateTypeToString(JSONObject jsonObject) {
        if (jsonObject.getDate("fromTime") != null) {
            jsonObject.put("fromTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(jsonObject.getDate("fromTime")));
        }
        if (jsonObject.getDate("approvedTime") != null) {
            jsonObject.put("approvedTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("approvedTime")));
        }
        if (jsonObject.getDate("updateTimes") != null) {
            jsonObject.put("updateTimes", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTimes")));
        }
        if (jsonObject.getDate("establishTime") != null) {
            jsonObject.put("establishTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("establishTime")));
        }
        if (jsonObject.getDate("toTime") != null) {
            jsonObject.put("toTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("toTime")));
        }
        if (jsonObject.getDate("revokeDate") != null) {
            jsonObject.put("revokeDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("revokeDate")));
        }
        if (jsonObject.getDate("cancelDate") != null) {
            jsonObject.put("cancelDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("cancelDate")));
        }
        if (jsonObject.getDate("registerDate") != null) {
            jsonObject.put("registerDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("registerDate")));
        }
        if (jsonObject.getDate("createTime") != null) {
            jsonObject.put("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("createTime")));
        }
        if (jsonObject.getDate("updateTime") != null) {
            jsonObject.put("updateTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jsonObject.getDate("updateTime")));
        }
        return jsonObject;
    }

    private SupplierMasterDataVO setPropertiesByEnterpriseInfo(SupplierMasterDataVO supplierMasterDataVO, ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2) {
        supplierMasterDataVO.setName(ElsEnterpriseInfoDTO2.getName());
        supplierMasterDataVO.setPercentileScore(ElsEnterpriseInfoDTO2.getPercentileScore());
        supplierMasterDataVO.setStaffNumRange(ElsEnterpriseInfoDTO2.getStaffNumRange());
        supplierMasterDataVO.setFromTime(ElsEnterpriseInfoDTO2.getFromTime());
        supplierMasterDataVO.setType(ElsEnterpriseInfoDTO2.getType());
        supplierMasterDataVO.setBondBame(ElsEnterpriseInfoDTO2.getBondBame());
        supplierMasterDataVO.setMicroEnt(ElsEnterpriseInfoDTO2.getMicroEnt());
        supplierMasterDataVO.setUsedBondName(ElsEnterpriseInfoDTO2.getUsedBondName());
        supplierMasterDataVO.setRegNumber(ElsEnterpriseInfoDTO2.getRegNumber());
        supplierMasterDataVO.setRegCapital(ElsEnterpriseInfoDTO2.getRegCapital());
        supplierMasterDataVO.setRegInstitute(ElsEnterpriseInfoDTO2.getRegInstitute());
        supplierMasterDataVO.setRegLocation(ElsEnterpriseInfoDTO2.getRegLocation());
        supplierMasterDataVO.setIndustry(ElsEnterpriseInfoDTO2.getIndustry());
        supplierMasterDataVO.setApprovedTime(ElsEnterpriseInfoDTO2.getApprovedTime());
        supplierMasterDataVO.setUpdateTimes(ElsEnterpriseInfoDTO2.getUpdateTimes());
        supplierMasterDataVO.setSocialStaffNum(ElsEnterpriseInfoDTO2.getSocialStaffNum());
        supplierMasterDataVO.setTags(ElsEnterpriseInfoDTO2.getTags());
        supplierMasterDataVO.setTaxNumber(ElsEnterpriseInfoDTO2.getTaxNumber());
        supplierMasterDataVO.setBusinessScope(ElsEnterpriseInfoDTO2.getBusinessScope());
        supplierMasterDataVO.setProperty3(ElsEnterpriseInfoDTO2.getProperty3());
        supplierMasterDataVO.setAlias(ElsEnterpriseInfoDTO2.getAlias());
        supplierMasterDataVO.setOrgNumber(ElsEnterpriseInfoDTO2.getOrgNumber());
        supplierMasterDataVO.setRegStatus(ElsEnterpriseInfoDTO2.getRegStatus());
        supplierMasterDataVO.setEstablishTime(ElsEnterpriseInfoDTO2.getEstablishTime());
        supplierMasterDataVO.setBondType(ElsEnterpriseInfoDTO2.getBondType());
        supplierMasterDataVO.setLegalPersonName(ElsEnterpriseInfoDTO2.getLegalPersonName());
        supplierMasterDataVO.setToTime(ElsEnterpriseInfoDTO2.getToTime());
        supplierMasterDataVO.setActualCapital(ElsEnterpriseInfoDTO2.getActualCapital());
        supplierMasterDataVO.setCompanyOrgType(ElsEnterpriseInfoDTO2.getCompanyOrgType());
        supplierMasterDataVO.setBase(ElsEnterpriseInfoDTO2.getBase());
        supplierMasterDataVO.setArea(ElsEnterpriseInfoDTO2.getArea());
        supplierMasterDataVO.setCountry(ElsEnterpriseInfoDTO2.getCountry());
        supplierMasterDataVO.setCreditCode(ElsEnterpriseInfoDTO2.getCreditCode());
        supplierMasterDataVO.setHistoryNames(ElsEnterpriseInfoDTO2.getHistoryNames());
        supplierMasterDataVO.setHistoryNameList(ElsEnterpriseInfoDTO2.getHistoryNameList());
        supplierMasterDataVO.setBondNum(ElsEnterpriseInfoDTO2.getBondNum());
        supplierMasterDataVO.setRegCapitalCurrency(ElsEnterpriseInfoDTO2.getRegCapitalCurrency());
        supplierMasterDataVO.setActualCapitalCurrency(ElsEnterpriseInfoDTO2.getActualCapitalCurrency());
        supplierMasterDataVO.setEmail(ElsEnterpriseInfoDTO2.getEmail());
        supplierMasterDataVO.setWebsiteList(ElsEnterpriseInfoDTO2.getWebsiteList());
        supplierMasterDataVO.setPhoneNumber(ElsEnterpriseInfoDTO2.getPhoneNumber());
        supplierMasterDataVO.setRevokeDate(ElsEnterpriseInfoDTO2.getRevokeDate());
        supplierMasterDataVO.setRevokeReason(ElsEnterpriseInfoDTO2.getRevokeReason());
        supplierMasterDataVO.setCancelDate(ElsEnterpriseInfoDTO2.getCancelDate());
        supplierMasterDataVO.setCancelReason(ElsEnterpriseInfoDTO2.getCancelReason());
        supplierMasterDataVO.setCity(ElsEnterpriseInfoDTO2.getCity());
        supplierMasterDataVO.setDistrict(ElsEnterpriseInfoDTO2.getDistrict());
        supplierMasterDataVO.setCategory(ElsEnterpriseInfoDTO2.getCategory());
        supplierMasterDataVO.setCategoryBig(ElsEnterpriseInfoDTO2.getCategoryBig());
        supplierMasterDataVO.setCategoryMiddle(ElsEnterpriseInfoDTO2.getCategoryMiddle());
        supplierMasterDataVO.setCategorySmall(ElsEnterpriseInfoDTO2.getCategorySmall());
        supplierMasterDataVO.setRegisterDate(ElsEnterpriseInfoDTO2.getRegisterDate());
        supplierMasterDataVO.setBusinessLicense(ElsEnterpriseInfoDTO2.getBusinessLicense());
        supplierMasterDataVO.setStaging(ElsEnterpriseInfoDTO2.getStaging());
        supplierMasterDataVO.setStagingReason(ElsEnterpriseInfoDTO2.getStagingReason());
        return supplierMasterDataVO;
    }
}

