/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class BeanComparatorUtils {
    private static final Set<Class<?>> primitiveWrapperSet = new HashSet(10);

    public static String compareBean(Object source, Object target) {
        return BeanComparatorUtils.compareBean(source, target, null);
    }

    public static Map compareBeanToMap(Object source, Object target) {
        return BeanComparatorUtils.compareBeanToMap(source, target, null);
    }

    public static String compareBean(Object source, Object target, Map<String, String> propertyTranslationMap) {
        if (source == null) {
            throw new RuntimeException("source is null.");
        }
        if (target == null) {
            throw new RuntimeException("target is null.");
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new RuntimeException("source.class and target.class is not same.");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        if (fieldList.isEmpty() || fieldList.size() == 0) {
            throw new RuntimeException("source.class has no property.");
        }
        return BeanComparatorUtils.compareProperty(source, target, source.getClass(), fieldList, propertyTranslationMap);
    }

    public static Map compareBeanToMap(Object source, Object target, Map<String, String> propertyTranslationMap) {
        if (source == null) {
            throw new RuntimeException("source is null.");
        }
        if (target == null) {
            throw new RuntimeException("target is null.");
        }
        if (!source.getClass().equals(target.getClass())) {
            throw new RuntimeException("source.class and target.class is not same.");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = source.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        if (fieldList.isEmpty() || fieldList.size() == 0) {
            throw new RuntimeException("source.class has no property.");
        }
        return BeanComparatorUtils.comparePropertyToMap(source, target, source.getClass(), fieldList, propertyTranslationMap);
    }

    private static String compareProperty(Object source, Object target, Class<?> clazz, List<Field> fields, Map<String, String> propertyTranslationMap) {
        StringBuilder sBuilder = new StringBuilder();
        for (Field field : fields) {
            if (!BeanComparatorUtils.isSampleProperty(field.getType())) continue;
            String name = field.getName();
            String nameMapped = null;
            if (propertyTranslationMap != null && !propertyTranslationMap.isEmpty()) {
                if (!propertyTranslationMap.containsKey(name)) continue;
                nameMapped = propertyTranslationMap.get(name);
            }
            Class<?> propertyClazz = field.getClass();
            Object sourcePropertyValue = BeanComparatorUtils.getValueByField(source, clazz, field);
            Object targetPropertyValue = BeanComparatorUtils.getValueByField(target, clazz, field);
            if (nameMapped != null) {
                name = nameMapped;
            }
            BeanComparatorUtils.comparePropertyValue(sBuilder, name, propertyClazz, sourcePropertyValue, targetPropertyValue);
        }
        return sBuilder.toString();
    }

    private static Map<String, Object> comparePropertyToMap(Object source, Object target, Class<?> clazz, List<Field> fields, Map<String, String> propertyTranslationMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            if (!BeanComparatorUtils.isSampleProperty(field.getType())) continue;
            String name = field.getName();
            String nameMapped = null;
            if (propertyTranslationMap != null && !propertyTranslationMap.isEmpty()) {
                if (!propertyTranslationMap.containsKey(name)) continue;
                nameMapped = propertyTranslationMap.get(name);
            }
            Class<?> propertyClazz = field.getClass();
            Object sourcePropertyValue = BeanComparatorUtils.getValueByField(source, clazz, field);
            Object targetPropertyValue = BeanComparatorUtils.getValueByField(target, clazz, field);
            if (nameMapped != null) {
                name = nameMapped;
            }
            BeanComparatorUtils.comparePropertyValue(map, name, propertyClazz, sourcePropertyValue, targetPropertyValue);
        }
        return map;
    }

    private static Object getValueByField(Object obj, Class<?> clazz, Field field) {
        Object result = null;
        if (field.getGenericType().toString().equals("boolean")) {
            String methodName = field.getName();
            if (!methodName.startsWith("is")) {
                methodName = "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
            }
            Method method = null;
            try {
                method = clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            try {
                result = method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                PropertyDescriptor descriptor;
                if (clazz != null && (descriptor = BeanUtils.getPropertyDescriptor(clazz, (String)field.getName())) != null) {
                    Method method = descriptor.getReadMethod();
                    result = method.invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    private static void comparePropertyValue(StringBuilder sBuilder, String name, Class<?> propertyClazz, Object sourcePropertyValue, Object targetPropertyValue) {
        if (!Objects.equals(sourcePropertyValue, targetPropertyValue)) {
            String sourcePropertyValueStr = BeanComparatorUtils.getFormatStr(sourcePropertyValue);
            String targetPropertyValueStr = BeanComparatorUtils.getFormatStr(targetPropertyValue);
            sBuilder.append(name + ":" + sourcePropertyValueStr + "->" + targetPropertyValueStr + ",");
        }
    }

    private static void comparePropertyValue(Map<String, Object> map, String name, Class<?> propertyClazz, Object sourcePropertyValue, Object targetPropertyValue) {
        String targetPropertyValueStr;
        String sourcePropertyValueStr = BeanComparatorUtils.getFormatStr(sourcePropertyValue);
        if (!Objects.equals(sourcePropertyValueStr, targetPropertyValueStr = BeanComparatorUtils.getFormatStr(targetPropertyValue))) {
            map.put(name, targetPropertyValueStr);
        }
    }

    private static String getFormatStr(Object propertyValue) {
        if (propertyValue == null) {
            return "";
        }
        if (propertyValue instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)propertyValue);
        }
        return propertyValue.toString();
    }

    private static boolean isSampleProperty(Class<?> clazz) {
        if (clazz == null) {
            throw new RuntimeException("class is null");
        }
        return clazz.isPrimitive() || primitiveWrapperSet.contains(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    static {
        primitiveWrapperSet.add(Boolean.class);
        primitiveWrapperSet.add(Byte.class);
        primitiveWrapperSet.add(Character.class);
        primitiveWrapperSet.add(Double.class);
        primitiveWrapperSet.add(Float.class);
        primitiveWrapperSet.add(Integer.class);
        primitiveWrapperSet.add(Long.class);
        primitiveWrapperSet.add(Short.class);
    }
}

