/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.vmi.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.vmi.entity.VmiWaterLine;
import com.els.modules.vmi.service.VmiWaterLineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"VMI\u6c34\u4f4d\u7ebf"})
@RestController
@RequestMapping(value={"/vmi/vmiWaterLine"})
public class VmiWaterLineController
extends BaseController<VmiWaterLine, VmiWaterLineService> {
    @Autowired
    private VmiWaterLineService vmiWaterLineService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="vmiWaterLine")
    public Result<?> queryPageList(VmiWaterLine vmiWaterLine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)vmiWaterLine), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.vmiWaterLineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"vmiWaterLine:add"})
    @PermissionDataOpt(businessType="vmiWaterLine", beanClass=VmiWaterLineService.class)
    public Result<?> add(@RequestBody VmiWaterLine vmiWaterLine) {
        this.vmiWaterLineService.saveVmiWaterLine(vmiWaterLine);
        return Result.ok((Object)((Object)vmiWaterLine));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"vmiWaterLine:edit"})
    @PermissionDataOpt(businessType="vmiWaterLine", beanClass=VmiWaterLineService.class)
    public Result<?> edit(@RequestBody VmiWaterLine vmiWaterLine) {
        if (StringUtils.isNotBlank((CharSequence)vmiWaterLine.getMaterialNumber()) && StringUtils.isNotBlank((CharSequence)vmiWaterLine.getToElsAccount())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            wrapper.eq((Object)"to_els_account", (Object)vmiWaterLine.getToElsAccount());
            wrapper.eq((Object)"material_number", (Object)vmiWaterLine.getMaterialNumber());
            wrapper.eq((Object)"factory", (Object)vmiWaterLine.getFactory());
            List lines = this.vmiWaterLineService.list((Wrapper)wrapper);
            if (lines != null && lines.size() > 0) {
                for (VmiWaterLine line : lines) {
                    if (line.getId().equals(vmiWaterLine.getId())) continue;
                    return Result.error((String)(vmiWaterLine.getToElsAccount() + "\u4f9b\u5e94\u5546" + vmiWaterLine.getMaterialNumber() + "\u7269\u6599\u7684\u6c34\u4f4d\u7ebf\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u6b21\u65b0\u589e"));
                }
            }
        }
        this.vmiWaterLineService.updateVmiWaterLine(vmiWaterLine);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"vmiWaterLine:delete"})
    @PermissionDataOpt(businessType="vmiWaterLine", beanClass=VmiWaterLineService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.vmiWaterLineService.delVmiWaterLine(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.vmiWaterLineService.delBatchVmiWaterLine(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        VmiWaterLine vmiWaterLine = (VmiWaterLine)((Object)this.vmiWaterLineService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)vmiWaterLine));
    }
}

