/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeCatalogue;
import com.els.modules.knowledge.enumerate.KnowledgeStatusEnum;
import com.els.modules.knowledge.enumerate.KnowledgeVisitorPermEnum;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.service.KnowledgeCatalogueService;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.els.modules.knowledge.service.KnowledgeLikeService;
import com.els.modules.knowledge.util.KnowledgeTreeBuilder;
import com.els.modules.knowledge.vo.KnowledgeBaseVo;
import com.els.modules.knowledge.vo.KnowledgeCatalogueNode;
import com.els.modules.knowledge.vo.KnowledgeCatalogueVo;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6599\u76ee\u5f55"})
@RestController
@RequestMapping(value={"/knowledge/purchaseKnowledgeCatalogue"})
public class PurchaseKnowledgeCatalogueController
extends BaseController<KnowledgeCatalogue, KnowledgeCatalogueService> {
    @Autowired
    private KnowledgeCatalogueService knowledgeCatalogueService;
    @Autowired
    private KnowledgeBaseService purchaseKnowledgeBaseService;
    @Autowired
    private KnowledgeCollectService knowledgeCollectService;
    @Autowired
    private KnowledgeLikeService knowledgeLikeService;
    @Autowired
    private BaseRpcService baseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @ApiOperation(value="\u91c7\u8d2d\u8d44\u6599\u76ee\u5f55", notes="\u91c7\u8d2d\u8d44\u6599\u76ee\u5f55")
    @GetMapping(value={"/init-list"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:initList"})
    public Result<?> initList() {
        KnowledgeCatalogue catalogue = this.knowledgeCatalogueService.catalogueInit();
        List<KnowledgeCatalogue> childList = this.knowledgeCatalogueService.queryChildList(catalogue.getId());
        KnowledgeCatalogueVo result = new KnowledgeCatalogueVo();
        result.setKey(catalogue.getId());
        result.setTitle(catalogue.getCatalogueName());
        result.setIsLeaf(false);
        List<KnowledgeCatalogueVo> children = KnowledgeTreeBuilder.treeBuild(childList);
        result.setChildren(children);
        return Result.ok((Object)Lists.newArrayList((Object[])new KnowledgeCatalogueVo[]{result}));
    }

    @Deprecated
    private List<KnowledgeCatalogueVo> buildAnyAllFileCatalogue(List<String> exitsParentIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{KnowledgeBase::getKnowledgeCatalogue});
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeBase::getStatus, (Object)KnowledgeStatusEnum.PUBLISH.getValue())).eq(KnowledgeBase::getVisitorPerm, (Object)KnowledgeVisitorPermEnum.ANY_ALL.getValue());
        List knowledgeBases = this.purchaseKnowledgeBaseService.list((Wrapper)wrapper);
        List ids = knowledgeBases.stream().map(KnowledgeBase::getKnowledgeCatalogue).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper catalogueWrapper = Wrappers.lambdaQuery();
        catalogueWrapper.select(new SFunction[]{KnowledgeCatalogue::getAllParentId, KnowledgeCatalogue::getParentId, BaseEntity::getId, BaseEntity::getElsAccount});
        ((LambdaQueryWrapper)catalogueWrapper.in(BaseEntity::getId, ids)).isNotNull(KnowledgeCatalogue::getAllParentId);
        List catalogueList = this.knowledgeCatalogueService.list((Wrapper)catalogueWrapper);
        List leve0Ids = catalogueList.stream().filter(x -> "0".equals(x.getParentId())).map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List parentIds = catalogueList.stream().filter(x -> !"0".equals(x.getParentId()) && CharSequenceUtil.isNotEmpty((CharSequence)x.getAllParentId())).map(x -> x.getAllParentId().split(",")[0]).collect(Collectors.toList());
        leve0Ids.addAll(parentIds);
        leve0Ids.removeAll(exitsParentIds);
        if (CollUtil.isEmpty(leve0Ids)) {
            return Lists.newArrayList();
        }
        catalogueWrapper.clear();
        catalogueList = this.knowledgeCatalogueService.listByIds(leve0Ids);
        Map<String, String> accountMap = catalogueList.stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getElsAccount, (v, v1) -> v1));
        List<KnowledgeCatalogueVo> childList = KnowledgeTreeBuilder.treeBuild(catalogueList);
        List elsAccountList = childList.stream().map(KnowledgeCatalogueVo::getElsAccount).distinct().collect(Collectors.toList());
        List tenantList = this.invokeAccountRpcService.getTenantList(elsAccountList);
        Map<String, String> accountNameMap = tenantList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsTenantDTO::getCompanyName));
        for (KnowledgeCatalogueVo vo : childList) {
            String account = accountMap.get(vo.getKey());
            String dir = accountNameMap.get(account);
            if (!CharSequenceUtil.isNotEmpty((CharSequence)dir)) continue;
            vo.setTitle(dir + vo.getTitle());
        }
        return childList;
    }

    @ApiOperation(value="\u91c7\u8d2d\u76ee\u5f55\u7ba1\u7406\u521d\u59cb\u5316", notes="\u91c7\u8d2d\u76ee\u5f55\u7ba1\u7406\u521d\u59cb\u5316")
    @GetMapping(value={"/init-manager-list"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:initManagerList"})
    public Result<?> initManagerList() {
        this.knowledgeCatalogueService.catalogueInit();
        QueryWrapper queryWrapper = new QueryWrapper();
        List<KnowledgeCatalogueNode> treeList = this.knowledgeCatalogueService.loadKnowledgeCatalogueTree((QueryWrapper<KnowledgeCatalogue>)queryWrapper);
        return Result.ok(treeList);
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u76ee\u5f55-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:add"})
    public Result<?> add(@RequestBody KnowledgeCatalogue catalogue) {
        if (null == catalogue.getSortOrder()) {
            catalogue.setSortOrder(0);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)catalogue.getParentId())) {
            KnowledgeCatalogue init = this.knowledgeCatalogueService.catalogueInit();
            catalogue.setParentId(init.getId());
            catalogue.setAllParentId(catalogue.getParentId());
        }
        if (CharSequenceUtil.isEmpty((CharSequence)catalogue.getAllParentId())) {
            catalogue.setAllParentId(catalogue.getAllParentId());
        }
        catalogue.setElsAccount(TenantContext.getTenant());
        this.knowledgeCatalogueService.savePurchaseKnowledgeCatalogue(catalogue);
        return Result.ok((Object)((Object)catalogue));
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u76ee\u5f55-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:edit"})
    public Result<?> edit(@RequestBody KnowledgeCatalogue catalogue) {
        if (null == catalogue.getSortOrder()) {
            catalogue.setSortOrder(0);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)catalogue.getParentId())) {
            KnowledgeCatalogue init = this.knowledgeCatalogueService.catalogueInit();
            catalogue.setParentId(init.getId());
            catalogue.setAllParentId(catalogue.getParentId());
        }
        catalogue.setElsAccount(TenantContext.getTenant());
        this.knowledgeCatalogueService.updatePurchaseKnowledgeCatalogue(catalogue);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d44\u6599\u76ee\u5f55-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.knowledgeCatalogueService.delPurchaseKnowledgeCatalogue(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        KnowledgeCatalogue purchaseKnowledgeCatalogue = (KnowledgeCatalogue)((Object)this.knowledgeCatalogueService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseKnowledgeCatalogue));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b50\u8282\u70b9", notes="\u901a\u8fc7id\u67e5\u8be2\u5b50\u8282\u70b9")
    @GetMapping(value={"/childCatalogList/{id}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:childCatalogList"})
    public Result<?> queryChildList(@PathVariable(name="id") String id) {
        List<KnowledgeCatalogue> childList = this.knowledgeCatalogueService.queryChildListWithPerms(id);
        KnowledgeCatalogueVo result = new KnowledgeCatalogueVo();
        List<KnowledgeCatalogueVo> children = KnowledgeTreeBuilder.treeBuild(childList);
        result.setChildren(children);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5206\u9875\u67e5\u8be2\u6587\u4ef6", notes="\u901a\u8fc7id\u5206\u9875\u67e5\u8be2\u6587\u4ef6")
    @GetMapping(value={"/childFileList"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:childFileList"})
    public Result<?> childFileList(KnowledgeBase base, HttpServletRequest req, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        if (CharSequenceUtil.isEmpty((CharSequence)base.getKnowledgeCatalogue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ViFQIuIH_5f88d09a", (String)"\u8bf7\u9009\u62e9\u6587\u4ef6\u5939\u76ee\u5f55"));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)base), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page<KnowledgeBaseVo> fileList = this.purchaseKnowledgeBaseService.pagePurchaseKnowledgeByCatalogue((Page<KnowledgeBase>)page, (QueryWrapper<KnowledgeBase>)queryWrapper, base);
        List<String> ids = fileList.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollUtil.isEmpty(ids)) {
            return Result.ok(fileList);
        }
        List<String> collectExitsIds = this.knowledgeCollectService.check(ids);
        List<String> likeExitsIds = this.knowledgeLikeService.check(ids);
        Map fileMap = this.baseRpcService.listPurchaseAttachmentListByMainId(ids);
        for (KnowledgeBaseVo vo : fileList.getRecords()) {
            vo.setLike(likeExitsIds.contains(vo.getId()));
            vo.setCollect(collectExitsIds.contains(vo.getId()));
            vo.setAttachmentList((List)fileMap.get(vo.getId()));
        }
        return Result.ok(fileList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6811\u5f62\u8d44\u6599\u76ee\u5f55", notes="\u83b7\u53d6\u6811\u5f62\u8d44\u6599\u76ee\u5f55")
    @GetMapping(value={"/loadKnowledgeCatalogueTree"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCatalogue:loadKnowledgeCatalogueTree"})
    public Result<?> loadKnowledgeCatalogueTree() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List<KnowledgeCatalogueNode> treeList = this.knowledgeCatalogueService.loadKnowledgeCatalogueTree((QueryWrapper<KnowledgeCatalogue>)queryWrapper);
        return Result.ok(treeList);
    }
}

