/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.event.AsyncEventNotifier;
import com.els.common.event.AsyncEventType;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeCollect;
import com.els.modules.knowledge.entity.KnowledgeComment;
import com.els.modules.knowledge.entity.KnowledgeInteract;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.service.KnowledgeAccountPermService;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.vo.KnowledgeBaseVo;
import com.els.modules.knowledge.vo.KnowledgeCommentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u8d44\u6599\u5e93"})
@RestController
@RequestMapping(value={"/knowledge/knowledgeCollect"})
public class PurchaseKnowledgeCollectController
extends BaseController<KnowledgeBase, KnowledgeBaseService> {
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private KnowledgeAccountPermService knowledgeAccountPermService;
    @Autowired
    private KnowledgeCommentService knowledgeCommentService;
    @Autowired
    private KnowledgeCollectService knowledgeCollectService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u8d44\u6599\u6536\u85cf", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u8d44\u6599\u6536\u85cf")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCollect:list"})
    public Result<?> queryPurchasePageList(KnowledgeCollect collect, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)collect, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<KnowledgeCollect> pageList = this.knowledgeCollectService.collectPage((Page<KnowledgeCollect>)page, (QueryWrapper<KnowledgeCollect>)queryWrapper, SysUtil.getLoginUser().getId());
        return Result.ok(pageList);
    }

    @AutoLog(value="\u6536\u85cf\u5217\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCollect:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        KnowledgeCollect collect = (KnowledgeCollect)this.knowledgeCollectService.getById((Serializable)((Object)id));
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.eq(KnowledgeInteract::getAccountId, (Object)SysUtil.getLoginUser().getId())).eq(KnowledgeInteract::getId, (Object)id);
        this.knowledgeCollectService.remove((Wrapper)updateWrapper);
        AsyncEventNotifier.notify((String)collect.getKnowledgeId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCollect:queryById"})
    public Result<?> queryDetailById(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getById((Serializable)((Object)id)));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        List<String> elsSubAccountList = this.knowledgeAccountPermService.listAccount(id);
        purchaseKnowledgeBase.setVisitorPermElsAccount(elsSubAccountList);
        IPage<KnowledgeCommentVo> commentList = this.knowledgeCommentService.pageRootTreeCommentByKnowledgeId(id, (Page<KnowledgeComment>)new Page(0L, 10L));
        KnowledgeBaseVo result = (KnowledgeBaseVo)((Object)Convert.convert(KnowledgeBaseVo.class, (Object)((Object)purchaseKnowledgeBase)));
        result.setCommentList(commentList);
        return Result.ok((Object)((Object)purchaseKnowledgeBase));
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @PostMapping(value={"/purchaseCollect/{knowledgeId}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCollect:purchaseCollect"})
    public Result<?> purchaseCollect(@PathVariable(value="knowledgeId") String knowledgeId) {
        KnowledgeBase base = (KnowledgeBase)((Object)this.knowledgeBaseService.getById((Serializable)((Object)knowledgeId)));
        return this.doCollect(base);
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @PostMapping(value={"/saleCollect/{knowledgeId}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeCollect:saleCollect"})
    public Result<?> saleCollect(@PathVariable(value="knowledgeId") String knowledgeId) {
        KnowledgeBase base = this.knowledgeBaseService.querySaleById(knowledgeId);
        return this.doCollect(base);
    }

    private Result<?> doCollect(KnowledgeBase base) {
        if (null == base) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        boolean exists = this.knowledgeCollectService.checkIfExists(base.getId(), loginUser.getId());
        if (exists) {
            this.knowledgeCollectService.removeCollect(base.getId(), loginUser.getId());
            AsyncEventNotifier.notify((String)base.getId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
            return Result.ok();
        }
        KnowledgeCollect collect = new KnowledgeCollect();
        collect.setKnowledgeId(base.getId());
        collect.setKnowledgeThumbnail(base.getKnowledgeThumbnail());
        collect.setCreateTime(new Date());
        collect.setKnowledgeId(base.getId());
        collect.setKnowledgeTitle(base.getKnowledgeTitle());
        collect.setAccountId(loginUser.getId());
        collect.setCreateBy(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
        this.knowledgeCollectService.save(collect);
        AsyncEventNotifier.notify((String)base.getId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return Result.ok((String)collect.getId());
    }
}

