/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.event.AsyncEventNotifier;
import com.els.common.event.AsyncEventType;
import com.els.common.system.base.controller.BaseController;
import com.els.config.mybatis.TenantContext;
import com.els.modules.knowledge.entity.KnowledgeComment;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.vo.KnowledgeCommentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u8d44\u6599\u5e93"})
@RestController
@RequestMapping(value={"/knowledge/knowledgeComment"})
public class PurchaseKnowledgeCommentController
extends BaseController<KnowledgeComment, KnowledgeCommentService> {
    @Autowired
    private KnowledgeCommentService knowledgeCommentService;

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u8bc4\u8bba-\u6dfb\u52a0")
    @ApiOperation(value="\u8bc4\u8bba", notes="\u8bc4\u8bba")
    @PostMapping(value={"/comment"})
    @RequiresPermissions(value={"knowledge#knowledgeComment:comment"})
    public Result<?> comment(@RequestBody KnowledgeComment comment) {
        comment.setId(IdWorker.getIdStr());
        if (CharSequenceUtil.isEmpty((CharSequence)comment.getParentId())) {
            comment.setParentId("0");
            comment.setRootId(comment.getId());
        }
        comment.setElsAccount(TenantContext.getTenant());
        if (CharSequenceUtil.isNotEmpty((CharSequence)comment.getParentId()) && CharSequenceUtil.isEmpty((CharSequence)comment.getRootId())) {
            comment.setParentId("0");
            comment.setRootId(comment.getId());
        }
        this.knowledgeCommentService.save((Object)comment);
        AsyncEventNotifier.notify((String)comment.getKnowledgeId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return Result.ok((Object)((Object)comment));
    }

    @AutoLog(value="\u8d44\u6599\u8bc4\u8bba-\u5217\u51fa\u8d44\u6599\u6240\u6709\u8bc4\u8bba")
    @ApiOperation(value="\u5217\u51fa\u8d44\u6599\u6240\u6709\u8bc4\u8bba", notes="\u5217\u51fa\u8d44\u6599\u6240\u6709\u8bc4\u8bba")
    @PostMapping(value={"/list/{knowledgeId}"})
    @RequiresPermissions(value={"knowledge#knowledgeComment:list"})
    public Result<?> listComment(@PathVariable(value="knowledgeId") String knowledgeId) {
        List<KnowledgeCommentVo> commentList = this.knowledgeCommentService.listCommentByKnowledgeId(knowledgeId);
        return Result.ok(commentList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u91c7\u8d2d\u8d44\u6599\u5e93", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u91c7\u8d2d\u8d44\u6599\u5e93")
    @GetMapping(value={"/page/{knowledgeId}"})
    @RequiresPermissions(value={"knowledge#knowledgeComment:list"})
    public Result<?> queryPurchasePageList(@PathVariable(value="knowledgeId") String knowledgeId, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<KnowledgeCommentVo> pageList = this.knowledgeCommentService.pageRootTreeCommentByKnowledgeId(knowledgeId, (Page<KnowledgeComment>)page);
        return Result.ok(pageList);
    }
}

