/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeCatalogue;
import com.els.modules.knowledge.mapper.KnowledgeBaseMapper;
import com.els.modules.knowledge.mapper.KnowledgeCatalogueMapper;
import com.els.modules.knowledge.service.KnowledgeCatalogueService;
import com.els.modules.knowledge.vo.KnowledgeCatalogueNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KnowledgeCatalogueServiceImpl
extends BaseServiceImpl<KnowledgeCatalogueMapper, KnowledgeCatalogue>
implements KnowledgeCatalogueService {
    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePurchaseKnowledgeCatalogue(KnowledgeCatalogue catalogue) {
        catalogue.setLeaf(true);
        catalogue.setStatus("1");
        ((KnowledgeCatalogueMapper)this.baseMapper).insert((Object)catalogue);
        this.resetParent(catalogue.getParentId());
    }

    private void resetParent(String parentId) {
        KnowledgeCatalogue catalogue = new KnowledgeCatalogue();
        catalogue.setId(parentId);
        catalogue.setLeaf(false);
        int count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    private void resetOldParent(String parentId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(KnowledgeCatalogue::getParentId, (Object)parentId);
        Integer count = ((KnowledgeCatalogueMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        KnowledgeCatalogue catalogue = new KnowledgeCatalogue();
        catalogue.setId(parentId);
        catalogue.setLeaf(count <= 0);
        count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePurchaseKnowledgeCatalogue(KnowledgeCatalogue catalogue) {
        int count;
        KnowledgeCatalogue old = (KnowledgeCatalogue)((Object)((KnowledgeCatalogueMapper)this.baseMapper).selectById((Serializable)((Object)catalogue.getId())));
        if (!CharSequenceUtil.equals((CharSequence)old.getParentId(), (CharSequence)catalogue.getParentId())) {
            this.resetParent(catalogue.getParentId());
        } else {
            this.resetOldParent(old.getParentId());
        }
        if (CharSequenceUtil.isEmpty((CharSequence)catalogue.getAllParentId())) {
            catalogue.setAllParentId(old.getAllParentId());
        }
        if ((count = ((KnowledgeCatalogueMapper)this.baseMapper).updateById((Object)catalogue)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void delPurchaseKnowledgeCatalogue(String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeCatalogue::getParentId, (Object)id);
        Integer count = ((KnowledgeCatalogueMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIHMKJIHWxiTQG_738e14e2", (String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u5b50\u76ee\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(KnowledgeBase::getKnowledgeCatalogue, (Object)id);
        count = this.knowledgeBaseMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIHMKJLQIWxiTQG_9a704651", (String)"\u5f53\u524d\u76ee\u5f55\u5b58\u5728\u8d44\u6599\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        ((KnowledgeCatalogueMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseKnowledgeCatalogue(List<String> idList) {
        ((KnowledgeCatalogueMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<KnowledgeCatalogue> queryChildList(String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{KnowledgeCatalogue::getParentId, KnowledgeCatalogue::getCatalogueName, KnowledgeCatalogue::getSortOrder, BaseEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeCatalogue::getStatus, (Object)"1")).eq(KnowledgeCatalogue::getParentId, (Object)id);
        wrapper.orderByAsc(KnowledgeCatalogue::getSortOrder);
        return ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public KnowledgeCatalogue catalogueInit() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(KnowledgeCatalogue::getParentId, (Object)"0")).last(" limit 1");
        KnowledgeCatalogue catalogue = (KnowledgeCatalogue)((Object)((KnowledgeCatalogueMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == catalogue) {
            catalogue = new KnowledgeCatalogue();
            catalogue.setSortOrder(0);
            catalogue.setCatalogueName("/");
            catalogue.setParentId("0");
            catalogue.setAllParentId("0");
            catalogue.setLeaf(true);
            catalogue.setElsAccount(TenantContext.getTenant());
            catalogue.setDeleted(0);
            catalogue.setDataVersion(0);
            catalogue.setStatus("1");
            catalogue.setId(IdWorker.getIdStr());
            ((KnowledgeCatalogueMapper)this.baseMapper).insert((Object)catalogue);
        }
        return catalogue;
    }

    @Override
    public List<KnowledgeCatalogue> querySaleChildList(String parentId) {
        return ((KnowledgeCatalogueMapper)this.baseMapper).querySaleChildList(SysUtil.getLoginUser().getElsAccount(), parentId);
    }

    @Override
    public List<KnowledgeCatalogue> queryChildListWithPerms(String parentId) {
        return ((KnowledgeCatalogueMapper)this.baseMapper).queryChildListWithPerms(parentId);
    }

    private List<KnowledgeCatalogueNode> buildTree(List<KnowledgeCatalogueNode> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (KnowledgeCatalogueNode catalogue : all) {
            catalogue.setChildren(this.getChildren(catalogue, all));
            if (!rootId.equals(catalogue.getParentId()) || catalogue.getId().equals(catalogue.getParentId())) continue;
            parent.add(catalogue);
        }
        return parent;
    }

    private List<KnowledgeCatalogueNode> getChildren(KnowledgeCatalogueNode catalogueNode, List<KnowledgeCatalogueNode> all) {
        ArrayList<KnowledgeCatalogueNode> childList = new ArrayList<KnowledgeCatalogueNode>(8);
        for (KnowledgeCatalogueNode child : all) {
            if (!catalogueNode.getId().equals(child.getParentId()) || catalogueNode.getId().equals(catalogueNode.getParentId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public List<KnowledgeCatalogueNode> loadKnowledgeCatalogueTree(QueryWrapper<KnowledgeCatalogue> queryWrapper) {
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(KnowledgeCatalogue::getStatus, new Object[]{"1"})).orderByAsc(KnowledgeCatalogue::getSortOrder)).orderByAsc(BaseEntity::getCreateTime);
        List list = ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        List<KnowledgeCatalogueNode> nodes = list.stream().map(x -> {
            KnowledgeCatalogueNode node = new KnowledgeCatalogueNode();
            node.setId(x.getId());
            node.setKey(x.getId());
            node.setName(x.getCatalogueName());
            node.setOrder(x.getSortOrder());
            node.setParentId(x.getParentId());
            node.setTitle(x.getCatalogueName());
            return node;
        }).collect(Collectors.toList());
        return this.buildTree(nodes, "0");
    }

    @Override
    public List<KnowledgeCatalogueNode> loadKnowledgeCatalogueList(QueryWrapper<KnowledgeCatalogue> queryWrapper) {
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(KnowledgeCatalogue::getStatus, new Object[]{"1"});
        List list = ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list.stream().map(x -> {
            KnowledgeCatalogueNode node = new KnowledgeCatalogueNode();
            node.setId(x.getId());
            node.setKey(x.getId());
            node.setName(x.getCatalogueName());
            node.setOrder(x.getSortOrder());
            node.setParentId(x.getParentId());
            node.setTitle(x.getCatalogueName());
            return node;
        }).collect(Collectors.toList());
    }

    public List<KnowledgeCatalogue> querySaleChildList(String parentId, List<String> purchaseList) {
        if (CollectionUtil.isEmpty(purchaseList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, KnowledgeCatalogue::getParentId, KnowledgeCatalogue::getCatalogueName, KnowledgeCatalogue::getSortOrder, KnowledgeCatalogue::getVisitorPerm});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(KnowledgeCatalogue::getStatus, (Object)"1")).eq(KnowledgeCatalogue::getParentId, (Object)parentId)).in(BaseEntity::getElsAccount, purchaseList);
        wrapper.orderByAsc(KnowledgeCatalogue::getSortOrder);
        return ((KnowledgeCatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }
}

