/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.myschedule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.mapper.MyScheduleMapper;
import com.els.modules.myschedule.service.MyScheduleService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class MyScheduleServiceImpl
extends BaseServiceImpl<MyScheduleMapper, MySchedule>
implements MyScheduleService {
    @Override
    public void add(MySchedule mySchedule) {
        if (ObjectUtils.isEmpty((Object)mySchedule.getBeginTime())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vKKIxiTLVW_9cc437a6", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String beginDate = dateFormat.format(mySchedule.getBeginTime());
        mySchedule.setScheduleYear(beginDate.substring(0, 4));
        mySchedule.setScheduleMonth(beginDate.substring(4, 6));
        mySchedule.setScheduleDay(beginDate.substring(6, 8));
        ((MyScheduleMapper)this.baseMapper).insert((Object)mySchedule);
    }

    @Override
    public void edit(MySchedule mySchedule) {
        int count = ((MyScheduleMapper)this.baseMapper).updateById((Object)mySchedule);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MyScheduleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MyScheduleMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, List> queryMySchedule(String queryDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
        String currentYear = null;
        String currentMonth = null;
        if (queryDate == null) {
            Date nowDate = new Date();
            currentYear = dateFormat.format(nowDate).substring(0, 4);
            currentMonth = dateFormat.format(nowDate).substring(4, 6);
        } else {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Date parseDate = simpleDateFormat.parse(queryDate);
                currentYear = dateFormat.format(parseDate).substring(0, 4);
                currentMonth = dateFormat.format(parseDate).substring(4, 6);
            }
            catch (ParseException simpleDateFormat) {
                // empty catch block
            }
        }
        HashMap<String, List> returnMap = new HashMap<String, List>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"schedule_year", (Object)currentYear);
        queryWrapper.eq((Object)"schedule_month", (Object)currentMonth);
        queryWrapper.eq((Object)"sub_account", (Object)SysUtil.getLoginUser().getSubAccount());
        List myScheduleList = ((MyScheduleMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        int monthDays = this.getMonthDays(Integer.valueOf(currentYear), Integer.valueOf(currentMonth.replaceAll("^(0+)", "")));
        for (int i = 1; i <= monthDays; ++i) {
            ArrayList returnList = new ArrayList();
            String tmpDay = this.addZeroForNum(String.valueOf(i), 2);
            List tmpList = myScheduleList.stream().filter(o -> o.getScheduleDay().equals(tmpDay)).collect(Collectors.toList());
            for (MySchedule mySchedule : tmpList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("type", "warning");
                tmpMap.put("content", mySchedule.getContent());
                returnList.add(tmpMap);
            }
            returnMap.put(String.valueOf(i), returnList);
        }
        return returnMap;
    }

    private int getMonthDays(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getActualMaximum(5);
    }

    private String addZeroForNum(String str, int strLength) {
        int strLen = str.length();
        StringBuffer sb = null;
        while (strLen < strLength) {
            sb = new StringBuffer();
            sb.append("0").append(str);
            str = sb.toString();
            strLen = str.length();
        }
        return str;
    }
}

