/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePerformanceTemplateJob")
public class PurchasePerformanceTemplateJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceTemplateJob.class);
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;
    @Autowired
    private RedisUtil redisUtil;

    public void execute(String parameter) {
        block6: {
            String requestId = "purchasePerformanceTemplateJob";
            String LOCK_PREFIX = "PurchasePerformanceTemplate_schedule_purchasePerformanceTemplateJob";
            try {
                long EXPIRE_TIME = 50000L;
                if (this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, requestId, EXPIRE_TIME)) {
                    log.info("purchasePerformanceTemplateJob start");
                    this.purchasePerformanceTemplateHeadService.changeStatusForJob();
                    log.info("purchasePerformanceTemplateJob end");
                    break block6;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.redisUtil.releaseDistributedLock(LOCK_PREFIX, requestId);
            }
        }
    }
}

