/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.SqlRunnerExecuteService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.performance.dto.PurchasePerformanceReportItemDto;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceReportItem;
import com.els.modules.performance.entity.PurchasePerformanceReportItemFormula;
import com.els.modules.performance.entity.PurchasePerformanceReportItemGrad;
import com.els.modules.performance.entity.PurchasePerformanceReportNormWeight;
import com.els.modules.performance.entity.PurchasePerformanceReportSupplier;
import com.els.modules.performance.entity.PurchasePerformanceReportTemplateHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateGrad;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemFormula;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemGrad;
import com.els.modules.performance.entity.SalePerformanceReportHead;
import com.els.modules.performance.entity.SalePerformanceReportItem;
import com.els.modules.performance.entity.SalePerformanceReportNormWeight;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceEvaluationTypeEnum;
import com.els.modules.performance.enumerate.PerformanceQuarterEnum;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.enumerate.PerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateStatusEnum;
import com.els.modules.performance.enumerate.PurchasePerformanceReportStatusEnum;
import com.els.modules.performance.enumerate.ScoreMethodEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportItemMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportNormWeightMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportSupplierMapper;
import com.els.modules.performance.mapper.PurchasePerformanceReportTemplateHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemGradMapper;
import com.els.modules.performance.service.PurchasePerformanceReportGradService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceReportItemFormulaService;
import com.els.modules.performance.service.PurchasePerformanceReportItemGradService;
import com.els.modules.performance.service.PurchasePerformanceReportItemService;
import com.els.modules.performance.service.PurchasePerformanceReportNormWeightService;
import com.els.modules.performance.service.PurchasePerformanceReportSupplierService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.performance.utils.PurchasePerformanceReportJobUtil;
import com.els.modules.performance.vo.PurchasePerformanceReportHeadVO;
import com.els.modules.performance.vo.ReportComputeScoreVO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePerformanceReportHeadServiceImpl
extends BaseServiceImpl<PurchasePerformanceReportHeadMapper, PurchasePerformanceReportHead>
implements PurchasePerformanceReportHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReportHeadServiceImpl.class);
    @Resource
    private PurchasePerformanceReportHeadMapper purchasePerformanceReportHeadMapper;
    @Resource
    private PurchasePerformanceReportItemMapper purchasePerformanceReportItemMapper;
    @Resource
    private PurchasePerformanceReportNormWeightMapper purchasePerformanceReportNormWeightMapper;
    @Resource
    private PurchasePerformanceReportSupplierMapper purchasePerformanceReportSupplierMapper;
    @Resource
    private PurchasePerformanceTemplateGradMapper purchasePerformanceTemplateGradMapper;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Resource
    private SalePerformanceReportHeadService salePerformanceReportHeadService;
    @Resource
    private PurchasePerformanceReportGradMapper purchasePerformanceReportGradMapper;
    @Resource
    private PurchasePerformanceReportItemFormulaMapper purchasePerformanceReportItemFormulaMapper;
    @Resource
    private PurchasePerformanceReportItemGradMapper purchasePerformanceReportItemGradMapper;
    @Resource
    private PurchasePerformanceReportTemplateHeadMapper purchasePerformanceReportTemplateHeadMapper;
    @Resource
    private PurchasePerformanceTemplateHeadMapper purchasePerformanceTemplateHeadMapper;
    @Resource
    private PurchasePerformanceTemplateItemGradMapper purchasePerformanceTemplateItemGradMapper;
    @Resource
    private PurchasePerformanceTemplateItemFormulaMapper purchasePerformanceTemplateItemFormulaMapper;
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SqlRunnerExecuteService sqlRunnerExecuteService;
    @Autowired
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;

    private void buildReportTime(PurchasePerformanceReportHead head) {
        DateTime currentYear = DateUtil.beginOfYear((Date)DateUtil.date());
        PerformanceEvaluationTypeEnum cycle = PerformanceEvaluationTypeEnum.builder(head.getAssessmentCycle());
        String assessmentTimeRange = head.getAssessmentTimeRange();
        if (null == cycle || CharSequenceUtil.isBlank((CharSequence)assessmentTimeRange)) {
            return;
        }
        switch (cycle) {
            case YEAR: {
                DateTime year = DateUtil.parseDate((CharSequence)String.format("%s-01-01", assessmentTimeRange));
                head.setReportStartTime((Date)year);
                head.setReportEndTime((Date)DateUtil.endOfYear((Date)year));
                break;
            }
            case MONTH: {
                DateTime month = DateUtil.parseDate((CharSequence)String.format("%s-01", assessmentTimeRange));
                head.setReportStartTime((Date)month);
                head.setReportEndTime((Date)this.buildEndTime((Date)month));
                break;
            }
            case QUARTER: {
                DateTime[] dateTimes = this.buildTime(assessmentTimeRange);
                if (dateTimes.length != 2) {
                    return;
                }
                head.setReportStartTime((Date)dateTimes[0]);
                head.setReportEndTime((Date)dateTimes[1]);
                break;
            }
        }
    }

    private DateTime buildEndTime(Date month) {
        DateTime dateTime = DateUtil.endOfMonth((Date)month);
        return DateUtil.offsetMillisecond((Date)dateTime, (int)(-DateUtil.millisecond((Date)dateTime)));
    }

    private DateTime[] buildTime(String assessmentTimeRange) {
        String[] dates = assessmentTimeRange.split("~");
        String[] startStr = dates[0].split("-");
        PerformanceQuarterEnum start = PerformanceQuarterEnum.builderValue(dates[0]);
        if (null == start) {
            return new DateTime[0];
        }
        String format = "%s-%s-01";
        DateTime startTime = DateUtil.parseDate((CharSequence)String.format(format, startStr[0], start.getStart()));
        DateTime endTime = null;
        if (dates.length > 1) {
            String[] endStr = dates[1].split("-");
            PerformanceQuarterEnum end = PerformanceQuarterEnum.builderValue(dates[1]);
            if (null == end) {
                return new DateTime[0];
            }
            if (Integer.parseInt(startStr[0].trim()) > Integer.parseInt(endStr[0].trim())) {
                return new DateTime[0];
            }
            endTime = this.buildEndTime((Date)DateUtil.parseDate((CharSequence)String.format(format, endStr[0], end.getEnd())));
        }
        if (null == endTime) {
            endTime = this.buildEndTime((Date)DateUtil.parseDate((CharSequence)String.format(format, startStr[0], start.getEnd())));
        }
        return new DateTime[]{startTime, endTime};
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        if (CollUtil.isNotEmpty(purchasePerformanceReportItemList)) {
            for (PurchasePerformanceReportItemDto item : purchasePerformanceReportItemList) {
                if (!CharSequenceUtil.isNotEmpty((CharSequence)item.getSubAccount()) || !ScoreMethodEnum.isScoreByManual(item.getScoringMethod())) continue;
                item.setScorer(item.getSubAccount().split("_")[0]);
            }
        }
        ArrayList<PurchasePerformanceReportHead> performanceReportHeadList = new ArrayList<PurchasePerformanceReportHead>();
        if (StrUtil.isNotBlank((CharSequence)head.getToElsAccount())) {
            if (StringUtils.isBlank((CharSequence)head.getReportNumber())) {
                head.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)head));
            }
            performanceReportHeadList.add(head);
        } else {
            com.els.common.util.Assert.isNotBlank((String)head.getAccountGroup(), (String)I18nUtil.translate((String)"i18n_alert_RdXeyVxOLV_a6779136", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u7ec4\u4e0d\u80fd\u4e3a\u7a7a!"));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"account_group", (Object)head.getAccountGroup());
            queryWrapper.eq((Object)"els_account", (Object)head.getElsAccount());
            List supplierMasterDataList = this.supplierMasterDataMapper.selectList((Wrapper)queryWrapper);
            com.els.common.util.Assert.isNotEmpty((Collection)supplierMasterDataList, (String)I18nUtil.translate((String)"i18n_alert_rRdXeyVLYuRdX_94b20c7c", (String)"\u8be5\u4f9b\u5e94\u5546\u8d26\u53f7\u7ec4\u672a\u627e\u5230\u4f9b\u5e94\u5546!"));
            supplierMasterDataList.stream().forEach(t -> {
                PurchasePerformanceReportHead performanceReportHead = new PurchasePerformanceReportHead();
                BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)performanceReportHead));
                performanceReportHead.setToElsAccount(t.getToElsAccount());
                performanceReportHead.setSupplierCode(t.getSupplierCode());
                performanceReportHead.setSupplierName(t.getSupplierName());
                performanceReportHead.setId(IdWorker.getIdStr());
                if (StringUtils.isBlank((CharSequence)performanceReportHead.getReportNumber())) {
                    performanceReportHead.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)performanceReportHead));
                }
                performanceReportHeadList.add(performanceReportHead);
            });
        }
        for (PurchasePerformanceReportHead purchasePerformanceReportHead : performanceReportHeadList) {
            this.buildReportTime(purchasePerformanceReportHead);
            this.purchasePerformanceReportHeadMapper.insert((Object)purchasePerformanceReportHead);
            purchasePerformanceReportItemList.forEach(t -> t.setId(null));
            this.insertData(purchasePerformanceReportHead, purchasePerformanceReportItemList);
            this.insertItemData(purchasePerformanceReportHead, purchasePerformanceReportItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMainNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemDtoList, List<PurchasePerformanceReportGrad> gradList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (StringUtils.isBlank((CharSequence)head.getReportNumber())) {
            head.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)head));
        }
        this.buildReportTime(head);
        this.purchasePerformanceReportHeadMapper.insert((Object)head);
        itemDtoList.forEach(t -> t.setId(null));
        gradList.forEach(t -> t.setId(null));
        normWeightList.forEach(t -> t.setId(null));
        supplierList.forEach(t -> t.setId(null));
        this.insertDataNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentDTOList);
        this.insertItemDataNew(head, itemDtoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        if (CollUtil.isNotEmpty(purchasePerformanceReportItemList)) {
            for (PurchasePerformanceReportItemDto item : purchasePerformanceReportItemList) {
                if (!CharSequenceUtil.isNotEmpty((CharSequence)item.getSubAccount()) || !ScoreMethodEnum.isScoreByManual(item.getScoringMethod())) continue;
                item.setScorer(item.getSubAccount().split("_")[0]);
            }
        }
        this.buildReportTime(head);
        int count = this.purchasePerformanceReportHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        List<String> existItemIds = purchasePerformanceReportItemList.stream().map(BaseEntity::getId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.purchasePerformanceReportItemMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportItemGradMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceReportItemFormulaMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceReportGradMapper.deleteByMainId(head.getId());
        this.insertData(head, purchasePerformanceReportItemList);
        purchasePerformanceReportItemList = purchasePerformanceReportItemList.stream().filter(x -> !existItemIds.contains(x.getId())).collect(Collectors.toList());
        this.insertItemData(head, purchasePerformanceReportItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMainNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemDtoList, List<PurchasePerformanceReportGrad> gradList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        this.buildReportTime(head);
        int count = this.purchasePerformanceReportHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        List<String> existItemIds = itemDtoList.stream().map(BaseEntity::getId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.purchasePerformanceReportItemMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportNormWeightMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportGradMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportSupplierMapper.deleteByMainId(head.getId());
        ((SupplierInvokeBaseRpcService)SpringContextUtils.getBean(SupplierInvokeBaseRpcService.class)).deletePurchaseAttachment(head.getId());
        this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(head.getId());
        this.purchasePerformanceReportItemGradMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceReportItemFormulaMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.insertDataNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentDTOList);
        itemDtoList = itemDtoList.stream().filter(x -> !existItemIds.contains(x.getId())).collect(Collectors.toList());
        this.insertItemDataNew(head, itemDtoList);
    }

    @Override
    public PurchasePerformanceReportHeadVO queryById(String id) {
        PurchasePerformanceReportHeadVO purchasePerformanceReportHeadVO = new PurchasePerformanceReportHeadVO();
        PurchasePerformanceReportHead purchasePerformanceReportHead = (PurchasePerformanceReportHead)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)purchasePerformanceReportHeadVO));
        List<PurchasePerformanceReportItemDto> itemDtoList = this.purchasePerformanceReportItemMapper.selectItemByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportItemList(itemDtoList);
        List<PurchasePerformanceReportNormWeight> normWeightList = this.purchasePerformanceReportNormWeightMapper.selectByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportNormWeightList(normWeightList);
        if (CharSequenceUtil.isNotBlank((CharSequence)purchasePerformanceReportHead.getPerformanceTemplateId())) {
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(purchasePerformanceReportHead.getId());
            purchasePerformanceReportHeadVO.setPurchasePerformanceNormGradList(gradList);
        }
        List<PurchasePerformanceReportSupplier> supplierList = this.purchasePerformanceReportSupplierMapper.selectByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportSupplierList(supplierList);
        List<PurchaseAttachmentDTO> attachmentDTOList = ((SupplierInvokeBaseRpcService)SpringContextUtils.getBean(SupplierInvokeBaseRpcService.class)).purcahseSelectByMainId(id);
        purchasePerformanceReportHeadVO.setPurchasePerformanceReportAttachmentList(attachmentDTOList);
        return purchasePerformanceReportHeadVO;
    }

    private void insertItemData(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> reportItemList) {
        String performanceTemplateId = head.getPerformanceTemplateId();
        PurchasePerformanceTemplateHead templateHead = (PurchasePerformanceTemplateHead)((Object)this.purchasePerformanceTemplateHeadMapper.selectById((Serializable)((Object)performanceTemplateId)));
        if (null == templateHead) {
            return;
        }
        PurchasePerformanceReportTemplateHead reportTemplateHead = (PurchasePerformanceReportTemplateHead)((Object)Convert.convert(PurchasePerformanceReportTemplateHead.class, (Object)((Object)templateHead)));
        reportTemplateHead.setId(null);
        reportTemplateHead.setHeadId(head.getId());
        SysUtil.setSysParam((BaseEntity)reportTemplateHead, (BaseEntity)head);
        Map<String, List<PurchasePerformanceReportItemDto>> sourceItemMap = reportItemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItemDto::getSourceType));
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        List<PurchasePerformanceReportItemDto> normItemList = sourceItemMap.get("1");
        this.buildNormItemData(itemGradList, itemFormulaList, normItemList);
        List<PurchasePerformanceReportItemDto> templateItemList = sourceItemMap.get("2");
        this.buildTemplateItemData(itemGradList, itemFormulaList, templateItemList, performanceTemplateId);
        List<PurchasePerformanceTemplateGrad> templateGradList = this.purchasePerformanceTemplateGradMapper.selectByMainId(performanceTemplateId);
        List<PurchasePerformanceReportGrad> gradList = this.buildGradData(head, templateGradList);
        this.purchasePerformanceReportTemplateHeadMapper.insert((Object)reportTemplateHead);
        if (CollUtil.isNotEmpty(gradList)) {
            ((PurchasePerformanceReportGradService)SpringContextUtils.getBean(PurchasePerformanceReportGradService.class)).saveBatch(gradList);
        }
        if (CollUtil.isNotEmpty(itemGradList)) {
            ((PurchasePerformanceReportItemGradService)SpringContextUtils.getBean(PurchasePerformanceReportItemGradService.class)).saveBatch(itemGradList);
        }
        if (CollUtil.isNotEmpty(itemFormulaList)) {
            ((PurchasePerformanceReportItemFormulaService)SpringContextUtils.getBean(PurchasePerformanceReportItemFormulaService.class)).saveBatch(itemFormulaList);
        }
    }

    private void insertItemDataNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> reportItemList) {
        String performanceTemplateId = head.getPerformanceTemplateId();
        PurchasePerformanceTemplateHead templateHead = (PurchasePerformanceTemplateHead)((Object)this.purchasePerformanceTemplateHeadMapper.selectById((Serializable)((Object)performanceTemplateId)));
        if (null == templateHead) {
            return;
        }
        PurchasePerformanceReportTemplateHead reportTemplateHead = (PurchasePerformanceReportTemplateHead)((Object)Convert.convert(PurchasePerformanceReportTemplateHead.class, (Object)((Object)templateHead)));
        reportTemplateHead.setId(null);
        reportTemplateHead.setHeadId(head.getId());
        SysUtil.setSysParam((BaseEntity)reportTemplateHead, (BaseEntity)head);
        this.purchasePerformanceReportTemplateHeadMapper.insert((Object)reportTemplateHead);
        Map<String, List<PurchasePerformanceReportItemDto>> sourceItemMap = reportItemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItemDto::getSourceType));
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        List<PurchasePerformanceReportItemDto> normItemList = sourceItemMap.get("1");
        this.buildNormItemData(itemGradList, itemFormulaList, normItemList);
        List<PurchasePerformanceReportItemDto> templateItemList = sourceItemMap.get("2");
        this.buildTemplateItemData(itemGradList, itemFormulaList, templateItemList, performanceTemplateId);
        if (CollUtil.isNotEmpty(itemGradList)) {
            ((PurchasePerformanceReportItemGradService)SpringContextUtils.getBean(PurchasePerformanceReportItemGradService.class)).saveBatch(itemGradList);
        }
        if (CollUtil.isNotEmpty(itemFormulaList)) {
            ((PurchasePerformanceReportItemFormulaService)SpringContextUtils.getBean(PurchasePerformanceReportItemFormulaService.class)).saveBatch(itemFormulaList);
        }
    }

    private List<PurchasePerformanceReportGrad> buildGradData(PurchasePerformanceReportHead head, List<PurchasePerformanceTemplateGrad> templateGradList) {
        if (CollUtil.isEmpty(templateGradList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportGrad> gradList = new ArrayList<PurchasePerformanceReportGrad>();
        for (PurchasePerformanceTemplateGrad grad : templateGradList) {
            PurchasePerformanceReportGrad tem = (PurchasePerformanceReportGrad)((Object)Convert.convert(PurchasePerformanceReportGrad.class, (Object)((Object)grad)));
            tem.setHeadId(head.getId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)head);
            tem.setId(null);
            gradList.add(tem);
        }
        return gradList;
    }

    private void buildNormItemData(List<PurchasePerformanceReportItemGrad> gradList, List<PurchasePerformanceReportItemFormula> formulaList, List<PurchasePerformanceReportItemDto> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<String> normIds = itemList.stream().map(PurchasePerformanceReportItem::getNormId).collect(Collectors.toList());
        if (CollUtil.isEmpty(normIds)) {
            return;
        }
        Map<String, List<PurchasePerformanceNormGrad>> normGradMap = this.queryNormGradMap(normIds);
        Map<String, List<PurchasePerformanceNormFormula>> normFormulaMap = this.queryNormFormulaMap(normIds);
        for (PurchasePerformanceReportItemDto entity : itemList) {
            List<PurchasePerformanceNormFormula> formulas;
            List<PurchasePerformanceNormGrad> grads = normGradMap.get(entity.getNormId());
            if (CollUtil.isNotEmpty(grads)) {
                List<PurchasePerformanceReportItemGrad> itemGrads = this.normConvertToItemGrad(grads, entity);
                gradList.addAll(itemGrads);
            }
            if (!CollUtil.isNotEmpty(formulas = normFormulaMap.get(entity.getNormId()))) continue;
            List<PurchasePerformanceReportItemFormula> itemGrads = this.normConvertToItemFormula(formulas, entity);
            formulaList.addAll(itemGrads);
        }
    }

    private void buildTemplateItemData(List<PurchasePerformanceReportItemGrad> gradList, List<PurchasePerformanceReportItemFormula> formulaList, List<PurchasePerformanceReportItemDto> itemList, String performanceTemplateId) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<String> templateItemIds = itemList.stream().map(PurchasePerformanceReportItemDto::getTemplateItemId).collect(Collectors.toList());
        if (CollUtil.isEmpty(templateItemIds)) {
            return;
        }
        Map<String, List<PurchasePerformanceTemplateItemGrad>> templateItemGradMap = this.queryTemplateGradMap(templateItemIds, performanceTemplateId);
        Map<String, List<PurchasePerformanceTemplateItemFormula>> templateIteFormulaMap = this.queryTemplateFormulaMap(templateItemIds, performanceTemplateId);
        for (PurchasePerformanceReportItemDto entity : itemList) {
            List<PurchasePerformanceTemplateItemFormula> formulas;
            List<PurchasePerformanceTemplateItemGrad> grads = templateItemGradMap.get(entity.getTemplateItemId());
            if (CollUtil.isNotEmpty(grads)) {
                List<PurchasePerformanceReportItemGrad> itemGrads = this.templateConvertToItemGrad(grads, entity);
                gradList.addAll(itemGrads);
            }
            if (!CollUtil.isNotEmpty(formulas = templateIteFormulaMap.get(entity.getTemplateItemId()))) continue;
            List<PurchasePerformanceReportItemFormula> itemGrads = this.templateConvertToItemFormula(formulas, entity);
            formulaList.addAll(itemGrads);
        }
    }

    private List<PurchasePerformanceReportItemGrad> normConvertToItemGrad(List<PurchasePerformanceNormGrad> grads, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(grads)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        for (PurchasePerformanceNormGrad grad : grads) {
            PurchasePerformanceReportItemGrad tem = (PurchasePerformanceReportItemGrad)((Object)Convert.convert(PurchasePerformanceReportItemGrad.class, (Object)((Object)grad)));
            tem.setPerformanceTemplateId(item.getTemplateItemId());
            tem.setPerformanceReportItemId(item.getId());
            tem.setHeadId(item.getHeadId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)item);
            tem.setId(null);
            itemGradList.add(tem);
        }
        return itemGradList;
    }

    private List<PurchasePerformanceReportItemFormula> normConvertToItemFormula(List<PurchasePerformanceNormFormula> formulaList, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(formulaList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        for (PurchasePerformanceNormFormula formula : formulaList) {
            PurchasePerformanceReportItemFormula tem = (PurchasePerformanceReportItemFormula)((Object)Convert.convert(PurchasePerformanceReportItemFormula.class, (Object)((Object)formula)));
            tem.setPerformanceTemplateId(item.getTemplateItemId());
            tem.setHeadId(item.getHeadId());
            tem.setPerformanceReportItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)formula, (BaseEntity)item);
            tem.setId(null);
            itemFormulaList.add(tem);
        }
        return itemFormulaList;
    }

    private Map<String, List<PurchasePerformanceNormGrad>> queryNormGradMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormGrad::getHeadId, normIds);
        List list = this.purchasePerformanceNormGradMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormGrad::getHeadId));
    }

    private Map<String, List<PurchasePerformanceNormFormula>> queryNormFormulaMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormFormula::getHeadId, normIds);
        List list = this.purchasePerformanceNormFormulaMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormFormula::getHeadId));
    }

    private List<PurchasePerformanceReportItemGrad> templateConvertToItemGrad(List<PurchasePerformanceTemplateItemGrad> grads, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(grads)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemGrad> itemGradList = new ArrayList<PurchasePerformanceReportItemGrad>();
        for (PurchasePerformanceTemplateItemGrad grad : grads) {
            PurchasePerformanceReportItemGrad tem = (PurchasePerformanceReportItemGrad)((Object)Convert.convert(PurchasePerformanceReportItemGrad.class, (Object)((Object)grad)));
            tem.setPerformanceReportItemId(item.getId());
            tem.setHeadId(item.getHeadId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)item);
            tem.setId(null);
            itemGradList.add(tem);
        }
        return itemGradList;
    }

    private List<PurchasePerformanceReportItemFormula> templateConvertToItemFormula(List<PurchasePerformanceTemplateItemFormula> formulaList, PurchasePerformanceReportItemDto item) {
        if (CollUtil.isEmpty(formulaList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceReportItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceReportItemFormula>();
        for (PurchasePerformanceTemplateItemFormula formula : formulaList) {
            PurchasePerformanceReportItemFormula tem = (PurchasePerformanceReportItemFormula)((Object)Convert.convert(PurchasePerformanceReportItemFormula.class, (Object)((Object)formula)));
            tem.setHeadId(item.getHeadId());
            tem.setPerformanceReportItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)formula, (BaseEntity)item);
            tem.setId(null);
            itemFormulaList.add(tem);
        }
        return itemFormulaList;
    }

    private Map<String, List<PurchasePerformanceTemplateItemGrad>> queryTemplateGradMap(List<String> templateItemIds, String performanceTemplateId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateItemId, templateItemIds)).eq(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateId, (Object)performanceTemplateId);
        List list = this.purchasePerformanceTemplateItemGradMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceTemplateItemGrad::getPerformanceTemplateItemId));
    }

    private Map<String, List<PurchasePerformanceTemplateItemFormula>> queryTemplateFormulaMap(List<String> templateItemIds, String performanceTemplateId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateItemId, templateItemIds)).eq(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateId, (Object)performanceTemplateId);
        List list = this.purchasePerformanceTemplateItemFormulaMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceTemplateItemFormula::getPerformanceTemplateItemId));
    }

    private void insertData(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            int itemNumber = 1;
            for (PurchasePerformanceReportItemDto entity : dtoList) {
                entity.setHeadId(purchasePerformanceReportHead.getId());
                entity.setItemNumber(String.valueOf(itemNumber++));
                entity.setId(StrUtil.isEmpty((CharSequence)entity.getId()) ? IdWorker.getIdStr() : entity.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePerformanceReportHead);
            }
            List purchasePerformanceReportItemList = Convert.toList(PurchasePerformanceReportItem.class, dtoList);
            ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).saveBatch(purchasePerformanceReportItemList);
        }
    }

    private void insertDataNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> dtoList, List<PurchasePerformanceReportGrad> gradList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        int itemNumber;
        if (CollectionUtils.isNotEmpty(dtoList)) {
            itemNumber = 1;
            for (PurchasePerformanceReportItemDto purchasePerformanceReportItemDto : dtoList) {
                purchasePerformanceReportItemDto.setHeadId(head.getId());
                purchasePerformanceReportItemDto.setItemNumber(String.valueOf(itemNumber++));
                purchasePerformanceReportItemDto.setId(StrUtil.isEmpty((CharSequence)purchasePerformanceReportItemDto.getId()) ? IdWorker.getIdStr() : purchasePerformanceReportItemDto.getId());
                SysUtil.setSysParam((BaseEntity)purchasePerformanceReportItemDto, (BaseEntity)head);
            }
            List list = Convert.toList(PurchasePerformanceReportItem.class, dtoList);
            ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).saveBatch(list);
        }
        if (CollectionUtils.isNotEmpty(gradList)) {
            for (PurchasePerformanceReportGrad purchasePerformanceReportGrad : gradList) {
                PurchasePerformanceReportGrad grad = new PurchasePerformanceReportGrad();
                BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportGrad), (Object)((Object)grad));
                purchasePerformanceReportGrad.setHeadId(head.getId());
                purchasePerformanceReportGrad.setId(IdWorker.getIdStr());
                SysUtil.setSysParam((BaseEntity)purchasePerformanceReportGrad, (BaseEntity)head);
            }
            ((PurchasePerformanceReportGradService)SpringContextUtils.getBean(PurchasePerformanceReportGradService.class)).saveBatch(gradList);
        }
        if (CollectionUtils.isNotEmpty(normWeightList)) {
            itemNumber = 1;
            for (PurchasePerformanceReportNormWeight purchasePerformanceReportNormWeight : normWeightList) {
                purchasePerformanceReportNormWeight.setHeadId(head.getId());
                purchasePerformanceReportNormWeight.setItemNumber(String.valueOf(itemNumber++));
                purchasePerformanceReportNormWeight.setId(null);
                SysUtil.setSysParam((BaseEntity)purchasePerformanceReportNormWeight, (BaseEntity)head);
            }
            ((PurchasePerformanceReportNormWeightService)SpringContextUtils.getBean(PurchasePerformanceReportNormWeightService.class)).saveBatch(normWeightList);
        }
        if (CollectionUtils.isNotEmpty(supplierList)) {
            for (PurchasePerformanceReportSupplier purchasePerformanceReportSupplier : supplierList) {
                purchasePerformanceReportSupplier.setId(null);
                purchasePerformanceReportSupplier.setHeadId(head.getId());
                SysUtil.setSysParam((BaseEntity)purchasePerformanceReportSupplier, (BaseEntity)head);
            }
            ((PurchasePerformanceReportSupplierService)SpringContextUtils.getBean(PurchasePerformanceReportSupplierService.class)).saveBatch(supplierList);
        }
        if (CollectionUtils.isNotEmpty(attachmentDTOList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : attachmentDTOList) {
                purchaseAttachmentDTO.setHeadId(head.getId());
                purchaseAttachmentDTO.setId(null);
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)head);
            }
            ((SupplierInvokeBaseRpcService)SpringContextUtils.getBean(SupplierInvokeBaseRpcService.class)).insertPurchaseBatchSomeColumn(attachmentDTOList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceReportItemMapper.deleteByMainId(id);
        this.purchasePerformanceReportGradMapper.deleteByMainId(id);
        this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(id);
        this.purchasePerformanceReportItemFormulaMapper.deleteByMainId(id);
        this.purchasePerformanceReportItemGradMapper.deleteByMainId(id);
        this.purchasePerformanceReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.purchasePerformanceReportItemMapper.deleteByMainId(id);
            this.purchasePerformanceReportGradMapper.deleteByMainId(id);
            this.purchasePerformanceReportTemplateHeadMapper.deleteByMainId(id);
            this.purchasePerformanceReportItemFormulaMapper.deleteByMainId(id);
            this.purchasePerformanceReportItemGradMapper.deleteByMainId(id);
            this.purchasePerformanceReportHeadMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishReport(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        com.els.common.util.Assert.isNotEmpty(purchasePerformanceReportItemList, (String)I18nUtil.translate((String)"i18n_alert_VSMsBcWF_a9fada62", (String)"\u8bf7\u586b\u5199\u62a5\u8868\u884c\u6570\u636e"));
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.EVA.getValue());
        if (purchasePerformanceReportHead.getExecuteTime() != null) {
            if (System.currentTimeMillis() >= purchasePerformanceReportHead.getExecuteTime().getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RcKIxOXUAPKI_88f4244a", (String)"\u6267\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4"));
            }
            PurchasePerformanceReportJobUtil.updateOrCreateJob(purchasePerformanceReportHead, purchasePerformanceReportHead.getExecuteTime());
            ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)purchasePerformanceReportHead);
            return;
        }
        String toElsAccount = purchasePerformanceReportHead.getToElsAccount();
        String accountGroup = purchasePerformanceReportHead.getAccountGroup();
        String orgType = purchasePerformanceReportHead.getOrgType();
        String orgCode = purchasePerformanceReportHead.getOrgCode();
        BigDecimal performanceScore = BigDecimal.ZERO;
        List<PurchasePerformanceReportItem> itemList = purchasePerformanceReportItemList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod())).collect(Collectors.toList());
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            if (!ScoreMethodEnum.isScoreBySystem(purchasePerformanceReportItem.getScoringMethod())) continue;
            ReportComputeScoreVO scoreVO = new ReportComputeScoreVO();
            scoreVO.setReportItemId(purchasePerformanceReportItem.getId());
            scoreVO.setAccountGroup(accountGroup);
            scoreVO.setHeadId(purchasePerformanceReportItem.getHeadId());
            scoreVO.setToElsAccount(toElsAccount);
            scoreVO.setAssessmentCycle(purchasePerformanceReportHead.getAssessmentCycle());
            scoreVO.setAssessmentTimeRange(purchasePerformanceReportHead.getAssessmentTimeRange());
            if ("factory".equals(orgType)) {
                scoreVO.setFactor(orgCode);
            } else if ("purchaseGroup".equals(orgType)) {
                scoreVO.setPurchaseOrg(orgCode);
            } else if ("purchaseOrganization".equals(orgType)) {
                scoreVO.setPurchaseGroup(orgCode);
            }
            Map<String, String> map = this.computeScore(scoreVO);
            String computeValue = map.get("computeValue");
            String score = map.get("score");
            if (StrUtil.isNotBlank((CharSequence)computeValue)) {
                purchasePerformanceReportItem.setNormValue(new BigDecimal(computeValue));
            } else {
                purchasePerformanceReportItem.setNormValue(BigDecimal.ZERO);
            }
            purchasePerformanceReportItem.setScoreTime(new Date());
            purchasePerformanceReportItem.setSubAccount(null);
            if (StrUtil.isNotBlank((CharSequence)score)) {
                purchasePerformanceReportItem.setScore(new BigDecimal(score));
            } else {
                purchasePerformanceReportItem.setScore(BigDecimal.ZERO);
            }
            purchasePerformanceReportItem.setSubAccount("system");
            purchasePerformanceReportItem.setScorer("system");
            if (!itemList.isEmpty()) continue;
            BigDecimal itemScore = StringUtils.isNotBlank((CharSequence)score) ? new BigDecimal(score) : BigDecimal.ZERO;
            BigDecimal fullScore = null == purchasePerformanceReportItem.getFullScore() ? BigDecimal.ONE : purchasePerformanceReportItem.getFullScore();
            BigDecimal result = itemScore.divide(fullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
            performanceScore = performanceScore.add(result);
            purchasePerformanceReportHead.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
        }
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            if (CharSequenceUtil.isNotEmpty((CharSequence)purchasePerformanceReportItem.getSubAccount()) && ScoreMethodEnum.isScoreByManual(purchasePerformanceReportItem.getScoringMethod())) {
                purchasePerformanceReportItem.setScorer(purchasePerformanceReportItem.getSubAccount().split("_")[0]);
            }
            this.purchasePerformanceReportItemMapper.updateById((Object)purchasePerformanceReportItem);
        }
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)purchasePerformanceReportHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (itemList.isEmpty()) {
            PurchasePerformanceReportGrad maxGrad;
            Object var10_14 = null;
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(purchasePerformanceReportHead.getId());
            Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
            if (max.isPresent() && performanceScore.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                String string = maxGrad.getGradingScore();
                purchasePerformanceReportHead.setPerformanceRate(string);
                this.reportPerformanceResultToSupplier(purchasePerformanceReportHead);
                return;
            }
            purchasePerformanceReportHead.setPerformanceScore(performanceScore);
            if (CollUtil.isNotEmpty(gradList)) {
                BigDecimal finalPerformanceScore = performanceScore;
                Optional<PurchasePerformanceReportGrad> any = gradList.stream().filter(x -> finalPerformanceScore.compareTo(x.getStartInterval()) >= 0 && finalPerformanceScore.compareTo(x.getEndInterval()) < 0).findAny();
                any.ifPresent(x -> purchasePerformanceReportHead.setPerformanceRate(x.getGradingScore()));
            }
            this.reportPerformanceResultToSupplier(purchasePerformanceReportHead);
        } else {
            this.sendScoreMsg(itemList, purchasePerformanceReportHead);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishReportNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemDtoList, List<PurchasePerformanceReportGrad> gradList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList) {
        int n;
        com.els.common.util.Assert.isNotEmpty(itemDtoList, (String)I18nUtil.translate((String)"i18n_alert_VSMsBcWF_a9fada62", (String)"\u8bf7\u586b\u5199\u62a5\u8868\u884c\u6570\u636e"));
        com.els.common.util.Assert.isNotEmpty(gradList, (String)I18nUtil.translate((String)"i18n_alert_VSMUzHFcWF_2b88a70", (String)"\u8bf7\u586b\u5199\u8bc4\u5206\u7ec6\u5219\u884c\u6570\u636e"));
        com.els.common.util.Assert.isNotEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_VSMKdRdXEWF_401ca134", (String)"\u8bf7\u586b\u5199\u9002\u5e94\u4f9b\u5e94\u5546\u884c\u6570\u636e"));
        head.setReportStatus(PerformanceReportStatusEnum.EVA.getValue());
        if (head.getExecuteTime() != null) {
            if (System.currentTimeMillis() >= head.getExecuteTime().getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RcKIxOXUAPKI_88f4244a", (String)"\u6267\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4"));
            }
            PurchasePerformanceReportJobUtil.updateOrCreateJob(head, head.getExecuteTime());
            ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
            return;
        }
        String orgType = head.getOrgType();
        String orgCode = head.getOrgCode();
        List<PurchasePerformanceReportItem> itemList = itemDtoList.stream().filter(o -> ScoreMethodEnum.isScoreByManual(o.getScoringMethod())).collect(Collectors.toList());
        for (PurchasePerformanceReportSupplier purchasePerformanceReportSupplier : supplierList) {
            ArrayList<PurchasePerformanceReportItem> reportItemList = new ArrayList<PurchasePerformanceReportItem>();
            for (PurchasePerformanceReportItem purchasePerformanceReportItem : itemDtoList) {
                purchasePerformanceReportItem.setToElsAccount(purchasePerformanceReportSupplier.getToElsAccount());
                purchasePerformanceReportItem.setSupplierCode(purchasePerformanceReportSupplier.getSupplierCode());
                purchasePerformanceReportItem.setSupplierName(purchasePerformanceReportSupplier.getSupplierName());
                purchasePerformanceReportItem.setSupplierClassify(purchasePerformanceReportSupplier.getSupplierClassify());
                purchasePerformanceReportItem.setSupplierStatus(purchasePerformanceReportSupplier.getSupplierStatus());
                purchasePerformanceReportItem.setLastId(purchasePerformanceReportItem.getId());
                if (ScoreMethodEnum.isScoreBySystem(purchasePerformanceReportItem.getScoringMethod())) {
                    BigDecimal result;
                    BigDecimal normWeight;
                    ReportComputeScoreVO scoreVO = new ReportComputeScoreVO();
                    scoreVO.setReportItemId(purchasePerformanceReportItem.getId());
                    scoreVO.setHeadId(purchasePerformanceReportItem.getHeadId());
                    scoreVO.setToElsAccount(purchasePerformanceReportSupplier.getToElsAccount());
                    scoreVO.setAssessmentCycle(head.getAssessmentCycle());
                    scoreVO.setAssessmentTimeRange(head.getAssessmentTimeRange());
                    if ("factory".equals(orgType)) {
                        scoreVO.setFactor(orgCode);
                    } else if ("purchaseGroup".equals(orgType)) {
                        scoreVO.setPurchaseOrg(orgCode);
                    } else if ("purchaseOrganization".equals(orgType)) {
                        scoreVO.setPurchaseGroup(orgCode);
                    }
                    Map<String, String> map = this.computeScore(scoreVO);
                    String computeValue = (String)map.get("computeValue");
                    String score = (String)map.get("score");
                    if (StrUtil.isNotBlank((CharSequence)computeValue)) {
                        if ("1".equals(head.getIsWeightStrategy())) {
                            purchasePerformanceReportItem.setNormValue(new BigDecimal(computeValue));
                            if ("1".equals(purchasePerformanceReportItem.getAttachNorm())) {
                                purchasePerformanceReportItem.setWeightScore(new BigDecimal(computeValue));
                            } else {
                                BigDecimal normValue = new BigDecimal(computeValue);
                                normWeight = purchasePerformanceReportItem.getNormWeight();
                                result = normValue.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                                purchasePerformanceReportItem.setWeightScore(result);
                            }
                        } else {
                            purchasePerformanceReportItem.setNormValue(new BigDecimal(computeValue));
                            purchasePerformanceReportItem.setWeightScore(new BigDecimal(computeValue));
                        }
                    } else {
                        purchasePerformanceReportItem.setNormValue(BigDecimal.ZERO);
                        purchasePerformanceReportItem.setWeightScore(BigDecimal.ZERO);
                    }
                    purchasePerformanceReportItem.setScoreTime(new Date());
                    purchasePerformanceReportItem.setSubAccount(null);
                    if (StrUtil.isNotBlank((CharSequence)score)) {
                        if ("1".equals(head.getIsWeightStrategy())) {
                            purchasePerformanceReportItem.setScore(new BigDecimal(score));
                            if ("1".equals(purchasePerformanceReportItem.getAttachNorm())) {
                                purchasePerformanceReportItem.setWeightScore(new BigDecimal(score));
                            } else {
                                BigDecimal itemScore = new BigDecimal(score);
                                normWeight = purchasePerformanceReportItem.getNormWeight();
                                result = itemScore.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                                purchasePerformanceReportItem.setWeightScore(result);
                            }
                        } else {
                            purchasePerformanceReportItem.setScore(new BigDecimal(score));
                            purchasePerformanceReportItem.setWeightScore(new BigDecimal(score));
                        }
                    } else {
                        purchasePerformanceReportItem.setScore(BigDecimal.ZERO);
                        purchasePerformanceReportItem.setWeightScore(BigDecimal.ZERO);
                    }
                    purchasePerformanceReportItem.setSubAccount("system");
                    purchasePerformanceReportItem.setScorer("system");
                }
                PurchasePerformanceReportItem purchasePerformanceReportItem2 = new PurchasePerformanceReportItem();
                BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportItem), (Object)((Object)purchasePerformanceReportItem2));
                reportItemList.add(purchasePerformanceReportItem2);
            }
            purchasePerformanceReportSupplier.setItemList(reportItemList);
        }
        ArrayList<PurchasePerformanceReportItem> newReportItemList = new ArrayList<PurchasePerformanceReportItem>();
        for (PurchasePerformanceReportSupplier purchasePerformanceReportSupplier : supplierList) {
            List<PurchasePerformanceReportItem> supplierItemList = purchasePerformanceReportSupplier.getItemList();
            for (PurchasePerformanceReportItem x2 : supplierItemList) {
                List collect;
                PurchasePerformanceReportItem purchasePerformanceReportItem = new PurchasePerformanceReportItem();
                BeanUtils.copyProperties((Object)((Object)x2), (Object)((Object)purchasePerformanceReportItem));
                purchasePerformanceReportItem.setId(IdWorker.getIdStr());
                purchasePerformanceReportItem.setCreateBy(null);
                purchasePerformanceReportItem.setCreateTime(null);
                purchasePerformanceReportItem.setUpdateBy(null);
                purchasePerformanceReportItem.setUpdateTime(null);
                if (CollUtil.isNotEmpty(normWeightList) && CollUtil.isNotEmpty(collect = normWeightList.stream().filter(o -> x2.getNormType().equals(o.getNormType())).collect(Collectors.toList()))) {
                    purchasePerformanceReportItem.setNormTypeWeight(((PurchasePerformanceReportNormWeight)((Object)collect.get(0))).getNormWeight());
                    purchasePerformanceReportItem.setNormTypeSort(((PurchasePerformanceReportNormWeight)((Object)collect.get(0))).getNormSort());
                }
                if (CharSequenceUtil.isNotEmpty((CharSequence)x2.getSubAccount()) && ScoreMethodEnum.isScoreByManual(x2.getScoringMethod())) {
                    purchasePerformanceReportItem.setScorer(x2.getSubAccount().split("_")[0]);
                }
                newReportItemList.add(purchasePerformanceReportItem);
            }
        }
        if (CollUtil.isNotEmpty(newReportItemList)) {
            this.purchasePerformanceReportItemMapper.deleteByMainId(head.getId());
            ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).saveBatch(newReportItemList, 2000);
        }
        if (itemList.isEmpty()) {
            boolean bl;
            head.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
            for (PurchasePerformanceReportSupplier supplier : supplierList) {
                PurchasePerformanceReportGrad maxGrad;
                void var11_19;
                supplier.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
                BigDecimal bigDecimal = BigDecimal.ZERO;
                List<PurchasePerformanceReportItem> list = supplier.getItemList();
                if ("1".equals(head.getIsWeightStrategy())) {
                    LinkedHashMap normTypeMap = list.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItem::getNormType, LinkedHashMap::new, Collectors.toList()));
                    for (String key : normTypeMap.keySet()) {
                        void var11_15;
                        List collect = normWeightList.stream().filter(o -> key.equals(o.getNormType())).collect(Collectors.toList());
                        BigDecimal normWeight = new BigDecimal(100);
                        if (!collect.isEmpty() && collect.size() > 0) {
                            normWeight = ((PurchasePerformanceReportNormWeight)((Object)collect.get(0))).getNormWeight();
                        }
                        BigDecimal normTypeScore = BigDecimal.ZERO;
                        List typeItemList = (List)normTypeMap.get(key);
                        for (PurchasePerformanceReportItem item : typeItemList) {
                            if ("1".equals(item.getAttachNorm())) {
                                normTypeScore = normTypeScore.add(item.getWeightScore());
                                continue;
                            }
                            BigDecimal weightScore = item.getWeightScore();
                            BigDecimal result = weightScore.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                            normTypeScore = normTypeScore.add(result);
                        }
                        BigDecimal bigDecimal2 = var11_15.add(normTypeScore);
                    }
                } else {
                    for (PurchasePerformanceReportItem item : list) {
                        void var11_17;
                        BigDecimal itemScore = item.getScore();
                        BigDecimal fullScore = null == item.getFullScore() ? BigDecimal.ONE : item.getFullScore();
                        BigDecimal result = itemScore.divide(fullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
                        BigDecimal bigDecimal3 = var11_17.add(result);
                    }
                }
                supplier.setScore((BigDecimal)var11_19);
                String level = null;
                Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
                if (max.isPresent() && var11_19.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                    level = maxGrad.getGradingScore();
                    supplier.setGradingScore(level);
                    this.reportPerformanceResultToSupplierNew(head, supplier);
                    continue;
                }
                if (CollUtil.isNotEmpty(gradList)) {
                    void finalPerformanceScore = var11_19;
                    Optional<PurchasePerformanceReportGrad> any = gradList.stream().filter(arg_0 -> PurchasePerformanceReportHeadServiceImpl.lambda$publishReportNew$14((BigDecimal)finalPerformanceScore, arg_0)).findAny();
                    any.ifPresent(x -> supplier.setGradingScore(x.getGradingScore()));
                }
                this.reportPerformanceResultToSupplierNew(head, supplier);
            }
            ((PurchasePerformanceReportSupplierService)SpringContextUtils.getBean(PurchasePerformanceReportSupplierService.class)).updateBatchById(supplierList);
            boolean bl2 = bl = "1".equals(head.getRequiredSend()) && PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue().equals(head.getSendStatus());
            if (bl) {
                head.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            }
        }
        if ((n = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (!itemList.isEmpty()) {
            this.sendScoreMsg(itemList, head);
        }
    }

    private void sendScoreMsg(List<PurchasePerformanceReportItem> itemList, PurchasePerformanceReportHead purchasePerformanceReportHead) {
        List scorerSubAccount = itemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getScorer())).map(x -> x.getScorer().split("_")[0]).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(scorerSubAccount)) {
            return;
        }
        HashMap subAccountMap = new HashMap();
        subAccountMap.put(TenantContext.getTenant(), scorerSubAccount);
        this.sendMsgToSubAccount(TenantContext.getTenant(), subAccountMap, (Object)purchasePerformanceReportHead, "pageShow=true&id=" + purchasePerformanceReportHead.getId(), "performanceReport", "performanceScoreNotify");
    }

    private Map<String, String> computeScore(ReportComputeScoreVO scoreVO) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String reportItemId = scoreVO.getReportItemId();
        PurchasePerformanceReportItem normHead = (PurchasePerformanceReportItem)((Object)this.purchasePerformanceReportItemMapper.selectById((Serializable)((Object)reportItemId)));
        if (ScoreMethodEnum.isScoreBySystem(normHead.getScoringMethod())) {
            List<PurchasePerformanceReportItemFormula> formulaList = this.purchasePerformanceReportItemFormulaMapper.selectByHeadIdAndItemId(scoreVO.getHeadId(), reportItemId);
            Assert.notEmpty(formulaList, (String)I18nUtil.translate((String)"i18n_alert_YxutXsBcWWWWWWWWWWIdjHetdtXRBRK_5caae9db", (String)"\u627e\u4e0d\u5230\u7ee9\u6548\u62a5\u8868\u884cid[ ${0} ]\u5bf9\u5e94\u7684\u7cfb\u7edf\u8ba1\u7b97\u7ee9\u6548\u6307\u6807\u516c\u5f0f", (String[])new String[]{reportItemId}));
            HashMap<String, String> params = new HashMap<String, String>();
            for (PurchasePerformanceReportItemFormula formula : formulaList) {
                String sql = this.appendSql(formula, scoreVO);
                String value = this.sqlRunnerExecuteService.getSqlRunnerRpcService(formula.getSourceTable()).runSql(sql + " limit 1");
                params.put(formula.getNormBase(), value);
            }
            String computeValue = FormulaUtil.convertToFormula((String)normHead.getFormula(), params);
            resultMap.put("computeValue", computeValue);
            if (CharSequenceUtil.isNotBlank((CharSequence)computeValue)) {
                PurchasePerformanceReportItemGrad maxGrad;
                BigDecimal compute = new BigDecimal(computeValue);
                BigDecimal fullScore = (BigDecimal)ObjectUtil.defaultIfNull((Object)normHead.getFullScore(), (Object)BigDecimal.ZERO);
                if (ScoreMethodEnum.SYS_COMPUTE.getValue().equals(normHead.getScoringMethod())) {
                    if (compute.compareTo(fullScore) > 0) {
                        compute = fullScore;
                    }
                    resultMap.put("score", compute.toString());
                    return resultMap;
                }
                List<PurchasePerformanceReportItemGrad> gradList = this.purchasePerformanceReportItemGradMapper.selectByHeadIdAndItemId(scoreVO.getHeadId(), reportItemId);
                Optional<PurchasePerformanceReportItemGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportItemGrad::getEndInterval));
                if (max.isPresent() && compute.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                    resultMap.put("score", StrUtil.toString((Object)maxGrad.getGradingScore()));
                }
                if (!resultMap.containsKey("score")) {
                    for (PurchasePerformanceReportItemGrad grad : gradList) {
                        BigDecimal startInterval = grad.getStartInterval();
                        BigDecimal endInterval = grad.getEndInterval();
                        if (compute.compareTo(startInterval) < 0 || compute.compareTo(endInterval) >= 0) continue;
                        resultMap.put("score", StrUtil.toString((Object)grad.getGradingScore()));
                        return resultMap;
                    }
                }
                return resultMap;
            }
        }
        return resultMap;
    }

    private String appendSql(PurchasePerformanceReportItemFormula formula, ReportComputeScoreVO scoreVO) {
        StringBuilder sql = new StringBuilder("select ");
        String table = formula.getSourceTable();
        String field = formula.getSourceField();
        String normSql = formula.getNormSql();
        sql.append(field).append(" from ").append(table).append(" where 1=1 ");
        if (StrUtil.isNotBlank((CharSequence)normSql)) {
            sql.append("and (").append(normSql).append(") ");
        }
        sql.append("and to_els_account='").append(scoreVO.getToElsAccount()).append("' ");
        PerformanceEvaluationTypeEnum typeEnum = PerformanceEvaluationTypeEnum.builder(scoreVO.getAssessmentCycle());
        if (null != typeEnum && CharSequenceUtil.isNotBlank((CharSequence)scoreVO.getAssessmentTimeRange()) && CharSequenceUtil.isNotBlank((CharSequence)formula.getAssessmentCycleField())) {
            switch (typeEnum) {
                case MONTH: {
                    String value = scoreVO.getAssessmentTimeRange().replace("-", "").trim();
                    sql.append(String.format("and date_format(%s,'%s') = '%s'", formula.getAssessmentCycleField(), "%Y%m", value));
                    break;
                }
                case QUARTER: {
                    DateTime[] dateTimes = this.buildTime(scoreVO.getAssessmentTimeRange());
                    if (dateTimes.length != 2) break;
                    sql.append(String.format("and %s between '%s' and '%s'", formula.getAssessmentCycleField(), dateTimes[0], dateTimes[1]));
                    break;
                }
                case YEAR: {
                    sql.append(String.format("and date_format(%s,'%s') = '%s'", formula.getAssessmentCycleField(), "%Y", scoreVO.getAssessmentTimeRange()));
                    break;
                }
            }
            log.info(":::PurchasePerformance search sql :{}", (Object)sql.toString());
        }
        return sql.toString();
    }

    private String buildMonth(String month) {
        try {
            return Integer.parseInt(month) < 10 ? "0" + month : month;
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXsBBnvLIHWWW_f60a461e", (String)"\u7ee9\u6548\u62a5\u8868\u8003\u6838\u8303\u56f4\u5f02\u5e38:{}", (String[])new String[]{month}));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void reportPerformanceResultToSupplier(PurchasePerformanceReportHead head) {
        boolean requiredSend;
        boolean syncSource;
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        if (!PerformanceReportStatusEnum.EVA_COMPLETED.getValue().equals(head.getReportStatus())) {
            return;
        }
        boolean bl = syncSource = "0".equals(head.getRequiredAudit()) || "1".equals(head.getRequiredAudit()) && AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus());
        if (!syncSource) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SupplierMasterData::getToElsAccount, (Object)head.getToElsAccount())).eq(StrUtil.isNotEmpty((CharSequence)head.getSupplierCode()), SupplierMasterData::getSupplierCode, (Object)head.getSupplierCode())).eq(BaseEntity::getElsAccount, (Object)head.getElsAccount());
        SupplierMasterData supplierMasterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectOne((Wrapper)wrapper));
        if (null == supplierMasterData) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXdWFWWWWWWWWEdxMK_4fa81317", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e[ ${0} ]\u753b\u50cf\u4e0d\u5b58\u5728", (String[])new String[]{head.getToElsAccount()}));
        }
        supplierMasterData.setPerformanceLevel(head.getPerformanceRate());
        this.supplierMasterDataMapper.updateById((Object)supplierMasterData);
        boolean bl2 = requiredSend = "1".equals(head.getRequiredSend()) && PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue().equals(head.getSendStatus());
        if (requiredSend) {
            head.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList = this.purchasePerformanceReportItemMapper.selectItemByMainId(head.getId());
            int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
            this.sendReport(head, purchasePerformanceReportItemList);
            return;
        }
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void reportPerformanceResultToSupplierNew(PurchasePerformanceReportHead head, PurchasePerformanceReportSupplier supplier) {
        boolean requiredSend;
        boolean syncSource;
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        if (!PerformanceReportStatusEnum.EVA_COMPLETED.getValue().equals(head.getReportStatus())) {
            return;
        }
        boolean bl = syncSource = "0".equals(head.getRequiredAudit()) || "1".equals(head.getRequiredAudit()) && AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus());
        if (!syncSource) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SupplierMasterData::getToElsAccount, (Object)supplier.getToElsAccount())).eq(StrUtil.isNotEmpty((CharSequence)supplier.getSupplierCode()), SupplierMasterData::getSupplierCode, (Object)supplier.getSupplierCode())).eq(BaseEntity::getElsAccount, (Object)supplier.getElsAccount());
        SupplierMasterData supplierMasterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectOne((Wrapper)wrapper));
        if (null == supplierMasterData) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXdWFWWWWWWWWEdxMK_4fa81317", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e[ ${0} ]\u753b\u50cf\u4e0d\u5b58\u5728", (String[])new String[]{supplier.getToElsAccount()}));
        }
        supplierMasterData.setPerformanceLevel(supplier.getGradingScore());
        this.supplierMasterDataMapper.updateById((Object)supplierMasterData);
        boolean bl2 = requiredSend = "1".equals(head.getRequiredSend()) && (StringUtils.isBlank((CharSequence)supplier.getSendStatus()) || PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue().equals(supplier.getSendStatus()));
        if (requiredSend) {
            supplier.setSendStatus(PerformanceReportSendStatusEnum.HAS_BEEN_SENT.getValue());
            int count = this.purchasePerformanceReportSupplierMapper.updateById((Object)supplier);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
            this.sendReportNew(head, supplier, supplier.getItemList(), this.purchasePerformanceReportNormWeightMapper.selectByMainId(head.getId()));
        }
    }

    private void beforeUpdate(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        if ("1".equals(purchasePerformanceReportHead.getRequiredAudit())) {
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePerformanceReportHead.setRequiredAudit("0");
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        purchasePerformanceReportHead.setPerformanceRate(null);
        purchasePerformanceReportHead.setPerformanceScore(null);
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            purchasePerformanceReportItem.setScoreTime(null);
            purchasePerformanceReportItem.setScore(purchasePerformanceReportItem.getScore());
            purchasePerformanceReportItem.setNormValue(null);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void performancePublish(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        PurchasePerformanceTemplateHead head = new PurchasePerformanceTemplateHead();
        head.setId(purchasePerformanceReportHead.getPerformanceTemplateId());
        head.setPerformanceTemplateStatus(PerformanceTemplateStatusEnum.USED.getValue());
        int count = this.purchasePerformanceTemplateHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)purchasePerformanceReportHead.getId())) {
            if (StringUtils.isBlank((CharSequence)purchasePerformanceReportHead.getReportNumber())) {
                purchasePerformanceReportHead.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)purchasePerformanceReportHead));
            }
            purchasePerformanceReportHead.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            purchasePerformanceReportHead.setRequiredSend("0");
            purchasePerformanceReportHead.setRequiredAudit("1");
            purchasePerformanceReportHead.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
            purchasePerformanceReportHead.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
            purchasePerformanceReportHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            this.saveMain(purchasePerformanceReportHead, purchasePerformanceReportItemList);
        } else {
            this.beforeUpdate(purchasePerformanceReportHead, purchasePerformanceReportItemList);
            this.updateMain(purchasePerformanceReportHead, purchasePerformanceReportItemList);
        }
        this.publishReport(purchasePerformanceReportHead, purchasePerformanceReportItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void performancePublishNew(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemDtoList, List<PurchasePerformanceReportGrad> gradList, List<PurchasePerformanceReportNormWeight> normWeightList, List<PurchasePerformanceReportSupplier> supplierList, List<PurchaseAttachmentDTO> attachmentDTOList) {
        PurchasePerformanceTemplateHead templateHead = new PurchasePerformanceTemplateHead();
        templateHead.setId(head.getPerformanceTemplateId());
        templateHead.setPerformanceTemplateStatus(PerformanceTemplateStatusEnum.USED.getValue());
        int count = this.purchasePerformanceTemplateHeadMapper.updateById((Object)templateHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)head.getId())) {
            if (StringUtils.isBlank((CharSequence)head.getReportNumber())) {
                head.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)head));
            }
            head.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            head.setRequiredSend(StringUtils.isBlank((CharSequence)head.getRequiredSend()) ? "0" : head.getRequiredSend());
            head.setRequiredAudit(StringUtils.isBlank((CharSequence)head.getRequiredAudit()) ? "1" : head.getRequiredAudit());
            head.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
            head.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            this.saveMainNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentDTOList);
        } else {
            this.beforeUpdate(head, itemDtoList);
            this.updateMainNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentDTOList);
        }
        this.publishReportNew(head, itemDtoList, gradList, normWeightList, supplierList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sendReportToSale(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        int count = ((PurchasePerformanceReportHeadMapper)this.baseMapper).updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.sendReport(head, purchasePerformanceReportItemList);
    }

    @Override
    public void sendReport(PurchasePerformanceReportHead purchasePerformanceReportHead, List<PurchasePerformanceReportItemDto> purchasePerformanceReportItemList) {
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        String id = purchasePerformanceReportHead.getId();
        String elsAccount = purchasePerformanceReportHead.getElsAccount();
        String toElsAccount = purchasePerformanceReportHead.getToElsAccount();
        SalePerformanceReportHead salePerformanceReportHead = new SalePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)salePerformanceReportHead));
        salePerformanceReportHead.setId(IdWorker.getIdStr());
        salePerformanceReportHead.setRelationId(id);
        salePerformanceReportHead.setElsAccount(toElsAccount);
        salePerformanceReportHead.setToElsAccount(elsAccount);
        salePerformanceReportHead.setBusAccount(elsAccount);
        ArrayList<SalePerformanceReportItem> salePerformanceReportItemList = new ArrayList<SalePerformanceReportItem>();
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : purchasePerformanceReportItemList) {
            String itemId = purchasePerformanceReportItem.getId();
            SalePerformanceReportItem saleItem = new SalePerformanceReportItem();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(toElsAccount);
            saleItem.setHeadId(purchasePerformanceReportHead.getId());
            saleItem.setRelationId(itemId);
            salePerformanceReportItemList.add(saleItem);
        }
        this.salePerformanceReportHeadService.saveMain(salePerformanceReportHead, salePerformanceReportItemList);
        this.sendAsyncReportResultMsg(salePerformanceReportHead);
    }

    @Override
    public void sendReportNew(PurchasePerformanceReportHead purchasePerformanceReportHead, PurchasePerformanceReportSupplier supplier, List<PurchasePerformanceReportItem> purchasePerformanceReportItemList, List<PurchasePerformanceReportNormWeight> normWeightList) {
        log.info("::: \u53d1\u9001\u7ee9\u6548\u62a5\u8868\u8bc4\u5206\u7ed3\u679c:::");
        String id = purchasePerformanceReportHead.getId();
        String elsAccount = supplier.getElsAccount();
        String toElsAccount = supplier.getToElsAccount();
        SalePerformanceReportHead salePerformanceReportHead = new SalePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReportHead), (Object)((Object)salePerformanceReportHead));
        salePerformanceReportHead.setId(IdWorker.getIdStr());
        salePerformanceReportHead.setRelationId(id);
        salePerformanceReportHead.setElsAccount(toElsAccount);
        salePerformanceReportHead.setToElsAccount(elsAccount);
        salePerformanceReportHead.setBusAccount(elsAccount);
        salePerformanceReportHead.setPerformanceScore(supplier.getScore());
        salePerformanceReportHead.setPerformanceRate(supplier.getGradingScore());
        ArrayList<SalePerformanceReportItem> salePerformanceReportItemList = new ArrayList<SalePerformanceReportItem>();
        for (PurchasePerformanceReportItem item : purchasePerformanceReportItemList) {
            String itemId = item.getId();
            SalePerformanceReportItem saleItem = new SalePerformanceReportItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(toElsAccount);
            saleItem.setHeadId(purchasePerformanceReportHead.getId());
            saleItem.setRelationId(itemId);
            salePerformanceReportItemList.add(saleItem);
        }
        ArrayList<SalePerformanceReportNormWeight> salePerformanceReportNormWeightList = new ArrayList<SalePerformanceReportNormWeight>();
        for (PurchasePerformanceReportNormWeight item : normWeightList) {
            String itemId = item.getId();
            SalePerformanceReportNormWeight saleItem = new SalePerformanceReportNormWeight();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            saleItem.setElsAccount(toElsAccount);
            saleItem.setHeadId(purchasePerformanceReportHead.getId());
            saleItem.setRelationId(itemId);
            salePerformanceReportNormWeightList.add(saleItem);
        }
        this.salePerformanceReportHeadService.saveMainNew(salePerformanceReportHead, salePerformanceReportItemList, salePerformanceReportNormWeightList);
        this.sendAsyncReportResultMsg(salePerformanceReportHead);
    }

    @Override
    public void sendAsyncReportResultMsg(SalePerformanceReportHead head) {
        this.sendMsg(head.getToElsAccount(), head.getElsAccount(), (Object)head, "id=" + head.getId(), "performanceReport", "performanceSendNotify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgParamsVO sendReportParameterAssemble(SalePerformanceReportHead head) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        HashMap<String, ArrayList> receiverMap = new HashMap<String, ArrayList>();
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)head.getElsAccount());
            ElsSubAccountDTO account = this.supplierInvokeAccountRpcService.getAccount(head.getElsAccount(), "1001");
            receiverMap.put(TenantContext.getTenant(), Lists.newArrayList((Object[])new ElsSubAccountDTO[]{account}));
            msgParamsVO.setReceiverMap(receiverMap);
            msgParamsVO.setParams((Object)head);
            MsgParamsVO msgParamsVO2 = msgParamsVO;
            return msgParamsVO2;
        }
        finally {
            TenantContext.setTenant((String)tenant);
        }
    }

    @Override
    public List<PurchasePerformanceReportItem> getSupplierScore(String toElsAccount) {
        LambdaQueryWrapper supplierLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)supplierLambdaQueryWrapper.eq(PurchasePerformanceReportSupplier::getReportStatus, (Object)PerformanceReportStatusEnum.EVA_COMPLETED.getValue())).eq(PurchasePerformanceReportSupplier::getToElsAccount, (Object)toElsAccount)).orderByDesc(BaseEntity::getUpdateTime)).last("limit 1");
        PurchasePerformanceReportSupplier supplier = (PurchasePerformanceReportSupplier)((Object)this.purchasePerformanceReportSupplierMapper.selectOne((Wrapper)supplierLambdaQueryWrapper));
        if (supplier == null) {
            return Lists.newArrayList();
        }
        QueryWrapper itemQueryWrapper = new QueryWrapper();
        itemQueryWrapper.eq((Object)"head_id", (Object)supplier.getHeadId());
        itemQueryWrapper.eq((Object)"to_els_account", (Object)supplier.getToElsAccount());
        return this.purchasePerformanceReportItemMapper.selectList((Wrapper)itemQueryWrapper);
    }

    public BigDecimal getScore(String headId, String itemId, BigDecimal compute) {
        PurchasePerformanceReportItemGrad maxGrad;
        List<PurchasePerformanceReportItemGrad> gradList = this.purchasePerformanceReportItemGradMapper.selectByHeadIdAndItemId(headId, itemId);
        Optional<PurchasePerformanceReportItemGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportItemGrad::getEndInterval));
        if (max.isPresent() && compute.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
            return maxGrad.getGradingScore();
        }
        for (PurchasePerformanceReportItemGrad grad : gradList) {
            BigDecimal startInterval = grad.getStartInterval();
            BigDecimal endInterval = grad.getEndInterval();
            if (compute.compareTo(startInterval) < 0 || compute.compareTo(endInterval) >= 0) continue;
            return grad.getGradingScore();
        }
        return BigDecimal.ZERO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void evaOpt(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItemDto> itemList) {
        for (PurchasePerformanceReportItem purchasePerformanceReportItem : itemList) {
            if (purchasePerformanceReportItem.getNormValue() == null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RBRxOLVW_57ad7015", (String)"\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (purchasePerformanceReportItem.getScore() == null && ScoreMethodEnum.MANUAL_SCORE.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_score_not_empty", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(purchasePerformanceReportItem.getScoringMethod())) {
                purchasePerformanceReportItem.setScore(this.getScore(purchasePerformanceReportItem.getHeadId(), purchasePerformanceReportItem.getId(), purchasePerformanceReportItem.getNormValue()));
            }
            purchasePerformanceReportItem.setScoreTime(new Date());
            this.purchasePerformanceReportItemMapper.updateById((Object)purchasePerformanceReportItem);
        }
        List<PurchasePerformanceReportItem> items = this.purchasePerformanceReportItemMapper.selectByMainId(head.getId());
        List list = items.stream().filter(o -> o.getScoreTime() == null).collect(Collectors.toList());
        if (list.isEmpty()) {
            int count;
            Optional<PurchasePerformanceReportGrad> any;
            PurchasePerformanceReportGrad maxGrad;
            BigDecimal totalSocre = BigDecimal.ZERO;
            BigDecimal totalFullScore = BigDecimal.ZERO;
            for (PurchasePerformanceReportItem item : items) {
                BigDecimal itemScore = item.getScore();
                BigDecimal fullScore = null == item.getFullScore() ? BigDecimal.ONE : item.getFullScore();
                totalFullScore = totalFullScore.add(fullScore);
                totalSocre = totalSocre.add(itemScore);
            }
            BigDecimal resultSocre = totalSocre.divide(totalFullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
            head.setId(head.getId());
            head.setPerformanceScore(resultSocre);
            head.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
            String level = null;
            List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(head.getId());
            Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
            if (max.isPresent() && resultSocre.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                level = maxGrad.getGradingScore();
            }
            if (CharSequenceUtil.isBlank(level) && (any = gradList.stream().filter(x -> resultSocre.compareTo(x.getStartInterval()) >= 0 && resultSocre.compareTo(x.getEndInterval()) < 0).findAny()).isPresent()) {
                level = any.get().getGradingScore();
            }
            head.setPerformanceRate(level);
            this.reportPerformanceResultToSupplier(head);
            if ("1".equals(head.getRequiredAudit())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if ((count = this.purchasePerformanceReportHeadMapper.updateById((Object)head)) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
        }
    }

    @Override
    public void evaOptSave(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItem> itemList) {
        for (PurchasePerformanceReportItem item : itemList) {
            BigDecimal result;
            BigDecimal normWeight;
            BigDecimal itemScore;
            if (item.getNormValue() != null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(item.getScoringMethod())) {
                item.setScore(this.getScore(item.getHeadId(), item.getLastId(), item.getNormValue()));
                if ("1".equals(head.getIsWeightStrategy())) {
                    if ("1".equals(item.getAttachNorm())) {
                        item.setWeightScore(item.getScore());
                    } else {
                        itemScore = item.getScore();
                        normWeight = item.getNormWeight();
                        result = itemScore.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                        item.setWeightScore(result);
                    }
                }
                item.setScoreTime(new Date());
            }
            if (item.getScore() == null || !ScoreMethodEnum.MANUAL_SCORE.getValue().equals(item.getScoringMethod())) continue;
            if ("1".equals(head.getIsWeightStrategy())) {
                if ("1".equals(item.getAttachNorm())) {
                    item.setWeightScore(item.getScore());
                } else {
                    itemScore = item.getScore();
                    normWeight = item.getNormWeight();
                    result = itemScore.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                    item.setWeightScore(result);
                }
            }
            item.setScoreTime(new Date());
        }
        ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).updateBatchById(itemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void evaOptSubmit(PurchasePerformanceReportHead head, List<PurchasePerformanceReportItem> itemList) {
        for (PurchasePerformanceReportItem item : itemList) {
            if (item.getNormValue() == null && ScoreMethodEnum.MANUAL_SCORE_NORM.getValue().equals(item.getScoringMethod())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RBRxOLVW_57ad7015", (String)"\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (item.getScore() != null || !ScoreMethodEnum.MANUAL_SCORE.getValue().equals(item.getScoringMethod())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_score_not_empty", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.evaOptSave(head, itemList);
        List<PurchasePerformanceReportItem> items = this.purchasePerformanceReportItemMapper.selectByMainId(head.getId());
        List checkList = items.stream().filter(o -> o.getScoreTime() == null).collect(Collectors.toList());
        if (checkList.isEmpty()) {
            int count;
            List<PurchasePerformanceReportNormWeight> normWeightList = this.purchasePerformanceReportNormWeightMapper.selectByMainId(head.getId());
            List<PurchasePerformanceReportSupplier> supplierList = this.purchasePerformanceReportSupplierMapper.selectByMainId(head.getId());
            for (PurchasePerformanceReportSupplier supplier : supplierList) {
                Optional<PurchasePerformanceReportGrad> any;
                PurchasePerformanceReportGrad maxGrad;
                supplier.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
                BigDecimal performanceScore = BigDecimal.ZERO;
                List<PurchasePerformanceReportItem> supplierItemList = items.stream().filter(o -> supplier.getToElsAccount().equals(o.getToElsAccount())).collect(Collectors.toList());
                supplier.setItemList(supplierItemList);
                if ("1".equals(head.getIsWeightStrategy())) {
                    LinkedHashMap normTypeMap = supplierItemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItem::getNormType, LinkedHashMap::new, Collectors.toList()));
                    for (Object key : normTypeMap.keySet()) {
                        List collect = normWeightList.stream().filter(arg_0 -> PurchasePerformanceReportHeadServiceImpl.lambda$evaOptSubmit$22((String)key, arg_0)).collect(Collectors.toList());
                        BigDecimal normWeight = new BigDecimal(100);
                        if (!collect.isEmpty() && collect.size() > 0) {
                            normWeight = ((PurchasePerformanceReportNormWeight)((Object)collect.get(0))).getNormWeight();
                        }
                        BigDecimal normTypeScore = BigDecimal.ZERO;
                        List typeItemList = (List)normTypeMap.get(key);
                        for (PurchasePerformanceReportItem item : typeItemList) {
                            if ("1".equals(item.getAttachNorm())) {
                                normTypeScore = normTypeScore.add(item.getWeightScore());
                                continue;
                            }
                            BigDecimal weightScore = item.getWeightScore();
                            BigDecimal result = weightScore.multiply(normWeight).divide(BigDecimal.valueOf(100L), 4, 4);
                            normTypeScore = normTypeScore.add(result);
                        }
                        performanceScore = performanceScore.add(normTypeScore);
                    }
                } else {
                    Object key;
                    BigDecimal totalSocre = BigDecimal.ZERO;
                    BigDecimal totalFullScore = BigDecimal.ZERO;
                    key = supplierItemList.iterator();
                    while (key.hasNext()) {
                        PurchasePerformanceReportItem item = key.next();
                        BigDecimal itemScore = item.getScore();
                        BigDecimal fullScore = null == item.getFullScore() ? BigDecimal.ONE : item.getFullScore();
                        totalFullScore = totalFullScore.add(fullScore);
                        totalSocre = totalSocre.add(itemScore);
                    }
                    performanceScore = totalSocre.divide(totalFullScore, 4, 4).multiply(BigDecimal.valueOf(100L));
                }
                BigDecimal resultSocre = performanceScore;
                String level = null;
                List<PurchasePerformanceReportGrad> gradList = this.purchasePerformanceReportGradMapper.selectByMainId(head.getId());
                Optional<PurchasePerformanceReportGrad> max = gradList.stream().max(Comparator.comparing(PurchasePerformanceReportGrad::getEndInterval));
                if (max.isPresent() && resultSocre.compareTo((maxGrad = max.get()).getEndInterval()) >= 0) {
                    level = maxGrad.getGradingScore();
                }
                if (CharSequenceUtil.isBlank(level) && (any = gradList.stream().filter(x -> resultSocre.compareTo(x.getStartInterval()) >= 0 && resultSocre.compareTo(x.getEndInterval()) < 0).findAny()).isPresent()) {
                    level = any.get().getGradingScore();
                }
                supplier.setScore(resultSocre);
                supplier.setGradingScore(level);
            }
            ((PurchasePerformanceReportSupplierService)SpringContextUtils.getBean(PurchasePerformanceReportSupplierService.class)).updateBatchById(supplierList);
            head.setReportStatus(PurchasePerformanceReportStatusEnum.COMPLETED.getValue());
            if ("1".equals(head.getRequiredAudit())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if ((count = this.purchasePerformanceReportHeadMapper.updateById((Object)head)) == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
            for (PurchasePerformanceReportSupplier supplier : supplierList) {
                this.reportPerformanceResultToSupplierNew(head, supplier);
            }
        }
    }

    @Override
    public PurchasePerformanceReportHead copy(String id) {
        PurchasePerformanceReportHeadVO headVO = this.queryById(id);
        PurchasePerformanceReportHead head = new PurchasePerformanceReportHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setId(IdWorker.getIdStr());
        head.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
        head.setRequiredSend(StrUtil.blankToDefault((CharSequence)head.getRequiredSend(), (String)"0"));
        SysUtil.setNullCreate((BaseEntity)head);
        head.setUpdateTime(null);
        head.setUpdateBy(null);
        head.setRequiredAudit(StrUtil.blankToDefault((CharSequence)head.getRequiredAudit(), (String)"1"));
        head.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
        head.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
        head.setReportNumber(this.invokeBaseRpcService.getNextCode("srmPerformanceReportNumber", (Object)head));
        if ("1".equals(head.getRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        List<PurchasePerformanceReportItemDto> itemList = headVO.getPurchasePerformanceReportItemList();
        List<PurchasePerformanceReportGrad> gradList = headVO.getPurchasePerformanceNormGradList();
        List<PurchasePerformanceReportNormWeight> normWeightList = headVO.getPurchasePerformanceReportNormWeightList();
        List<PurchasePerformanceReportSupplier> supplierList = headVO.getPurchasePerformanceReportSupplierList();
        List<PurchaseAttachmentDTO> attachmentList = headVO.getPurchasePerformanceReportAttachmentList();
        List<Object> itemDtoList = new ArrayList();
        List supplierItemList = itemList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getToElsAccount())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(supplierItemList)) {
            Map<String, List<PurchasePerformanceReportItemDto>> mapItemList = itemList.stream().collect(Collectors.groupingBy(PurchasePerformanceReportItem::getToElsAccount));
            Iterator<String> iterator = mapItemList.keySet().iterator();
            if (iterator.hasNext()) {
                String key = iterator.next();
                itemDtoList = mapItemList.get(key);
            }
        } else {
            itemDtoList = itemList;
        }
        for (PurchasePerformanceReportItemDto itemDto : itemDtoList) {
            itemDto.setId(null);
            itemDto.setHeadId(null);
            itemDto.setNormValue(null);
            itemDto.setScore(null);
            itemDto.setScoreTime(null);
            itemDto.setNormTypeSort(null);
            itemDto.setNormTypeWeight(null);
            itemDto.setWeightScore(null);
            itemDto.setToElsAccount(null);
            itemDto.setSupplierCode(null);
            itemDto.setSupplierName(null);
            itemDto.setSupplierClassify(null);
            itemDto.setSupplierStatus(null);
            itemDto.setCreateBy(null);
            itemDto.setCreateTime(null);
            itemDto.setUpdateTime(null);
            itemDto.setUpdateBy(null);
        }
        for (PurchasePerformanceReportSupplier supplier : supplierList) {
            supplier.setId(null);
            supplier.setHeadId(null);
            supplier.setSendStatus(null);
            supplier.setGradingScore(null);
            supplier.setReportStatus(null);
            supplier.setScore(null);
            supplier.setCreateBy(null);
            supplier.setCreateTime(null);
            supplier.setUpdateTime(null);
            supplier.setUpdateBy(null);
        }
        this.saveMainNew(head, itemDtoList, gradList, normWeightList, supplierList, attachmentList);
        return head;
    }

    @Override
    public void evaTransfer(List<String> ids, String transferAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceReportItem::getScoringMethod, (Collection)Lists.newArrayList((Object[])new String[]{ScoreMethodEnum.MANUAL_SCORE.getValue(), ScoreMethodEnum.MANUAL_SCORE_NORM.getValue()}));
        ((LambdaQueryWrapper)wrapper.eq(PurchasePerformanceReportItem::getScorer, (Object)SysUtil.getLoginUser().getSubAccount())).in(BaseEntity::getId, ids);
        List itemList = this.purchasePerformanceReportItemMapper.selectList((Wrapper)wrapper);
        if (CollUtil.isNotEmpty((Collection)itemList)) {
            for (PurchasePerformanceReportItem item : itemList) {
                item.setScorer(transferAccount.split("_")[0]);
                item.setSubAccount(transferAccount);
            }
            ((PurchasePerformanceReportItemService)SpringContextUtils.getBean(PurchasePerformanceReportItemService.class)).updateBatchById(itemList);
            String headId = ((PurchasePerformanceReportItem)((Object)itemList.get(0))).getHeadId();
            PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)this.getById((Serializable)((Object)headId)));
            this.sendScoreMsg(itemList, head);
        }
    }

    private static /* synthetic */ boolean lambda$evaOptSubmit$22(String key, PurchasePerformanceReportNormWeight o) {
        return key.equals(o.getNormType());
    }
}

