/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.rpc.service.PurchasePerformanceJobRpcService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchasePerformanceReportJobUtil {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReportJobUtil.class);
    private static PurchasePerformanceJobRpcService performanceReportJobRpcService = (PurchasePerformanceJobRpcService)SpringContextUtils.getBean(PurchasePerformanceJobRpcService.class);
    private static final String PERFORMANCE_REPORT_JOB = "generatePurchasePerformanceJob";

    public static void updateOrCreateJob(PurchasePerformanceReportHead head, Date time) {
        String elsAccount = TenantContext.getTenant();
        String jobNameKey = "generatePurchasePerformanceJob_" + head.getReportNumber() + "_" + elsAccount;
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobNameKey);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)head.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)TenantContext.getTenant());
        paramObj.put("jobImplName", (Object)PERFORMANCE_REPORT_JOB);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        List<QuartzJobDTO> jobList = performanceReportJobRpcService.findJobList(jobNameKey);
        try {
            if (jobList.isEmpty()) {
                performanceReportJobRpcService.createJob(job);
            } else {
                job.setId(jobList.get(0).getId());
                performanceReportJobRpcService.updateJob(job);
            }
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = performanceReportJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            performanceReportJobRpcService.deleteJob(jobList.get(0));
        }
    }
}

