/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterDataAuditInfo;
import com.els.modules.supplier.mapper.SupplierMasterDataAuditInfoMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterModifyAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SupplierMasterDataAuditInfoMapper supplierMasterDataAuditInfoMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        SupplierMasterDataAuditInfo auditInfo = (SupplierMasterDataAuditInfo)((Object)JSONObject.parseObject((String)inputParamVO.getParams(), SupplierMasterDataAuditInfo.class));
        SupplierMasterData masterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectById((Serializable)((Object)auditInfo.getRelationId())));
        if (masterData != null) {
            masterData.setAuditStatus(outputParamVO.getAuditStatus());
            this.supplierMasterDataMapper.updateById((Object)masterData);
        }
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            SupplierMasterDataAuditInfo auditInfo = (SupplierMasterDataAuditInfo)((Object)JSONObject.parseObject((String)inputParamVO.getParams(), SupplierMasterDataAuditInfo.class));
            if (auditInfo == null) {
                auditInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
            }
            SupplierMasterData masterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectById((Serializable)((Object)auditInfo.getRelationId())));
            SupplierMasterData supplierMasterData = new SupplierMasterData();
            BeanUtils.copyProperties((Object)((Object)auditInfo), (Object)((Object)supplierMasterData));
            supplierMasterData.setId(masterData.getId());
            this.supplierMasterDataMapper.updateById((Object)supplierMasterData);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SupplierMasterData masterData;
        this.updateStatus(inputParamVO, outputParamVO);
        SupplierMasterDataAuditInfo auditInfo = (SupplierMasterDataAuditInfo)((Object)JSONObject.parseObject((String)inputParamVO.getParams(), SupplierMasterDataAuditInfo.class));
        if (auditInfo == null) {
            auditInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        }
        if ((masterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectById((Serializable)((Object)auditInfo.getRelationId())))) != null) {
            masterData.setAuditStatus(outputParamVO.getAuditStatus());
            this.supplierMasterDataMapper.updateById((Object)masterData);
        }
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        SupplierMasterDataAuditInfo auditInfo = (SupplierMasterDataAuditInfo)((Object)JSONObject.parseObject((String)inputParamVO.getParams(), SupplierMasterDataAuditInfo.class));
        if (auditInfo == null) {
            auditInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        }
        SupplierMasterData masterData = (SupplierMasterData)((Object)this.supplierMasterDataMapper.selectById((Serializable)((Object)auditInfo.getRelationId())));
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        supplierMasterData.setId(masterData.getId());
        supplierMasterData.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.supplierMasterDataMapper.updateById((Object)supplierMasterData);
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SupplierMasterDataAuditInfo auditInfo = new SupplierMasterDataAuditInfo();
        auditInfo.setId(inputParamVO.getBusinessId());
        auditInfo.setAuditStatus(outputParamVO.getAuditStatus());
        auditInfo.setFlowId(outputParamVO.getProcessRootId());
        auditInfo.setWorkFlowType(outputParamVO.getBpmnType());
        this.supplierMasterDataAuditInfoMapper.updateById((Object)auditInfo);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

