/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.PurchaseStandardItem;
import com.els.modules.supplier.entity.SupplierAccessPolicy;
import com.els.modules.supplier.enumerate.ItemizedCheckStatusEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.PurchaseStandardItemService;
import com.els.modules.supplier.service.SupplierAccessPolicyService;
import com.els.modules.supplier.vo.PurchaseStandardHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/purchaseStandardHead"})
@Api(tags={"\u91c7\u8d2d\u51c6\u5165\u5934"})
public class PurchaseStandardHeadController
extends BaseController<PurchaseStandardHead, PurchaseStandardHeadService> {
    @Autowired
    private PurchaseStandardHeadService purchaseStandardHeadService;
    @Autowired
    private PurchaseStandardItemService purchaseStandardItemService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierInvokeBaseRpcService;
    @Autowired
    private SupplierAccessPolicyService supplierAccessPolicyService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:list"})
    @PermissionDataView(businessType="purchase_standard")
    public Result<?> queryPageList(PurchaseStandardHead purchaseStandardHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="myToDo", defaultValue="0") Boolean myToDo, HttpServletRequest req) {
        SupplierAccessPolicy accessPolicy;
        String accessCateCode = req.getParameter("accessCateCode");
        String accessPurchaseOrg = req.getParameter("accessPurchaseOrg");
        String accessLowestMark = req.getParameter("accessLowestMark");
        String accessToElsAccount = req.getParameter("accessToElsAccount");
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String policyId = null;
        for (String string : keys) {
            if (!"policyId".equals(string) || parameters.get(string) == null) continue;
            policyId = ((String[])parameters.get(string))[0];
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseStandardHead), (Map)parameters);
        if (myToDo.booleanValue()) {
            LoginUser loginUser = SysUtil.getLoginUser();
            if (ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(purchaseStandardHead.getStandardStatus())) {
                queryWrapper.gt((Object)("INSTR(respondents_list, 'purchase_" + loginUser.getSubAccount() + "_')"), (Object)0);
            } else if (ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(purchaseStandardHead.getStandardStatus())) {
                queryWrapper.gt((Object)("INSTR(scorer_list, '" + loginUser.getSubAccount() + "_')"), (Object)0);
            }
        }
        if (policyId != null && (accessPolicy = (SupplierAccessPolicy)((Object)this.supplierAccessPolicyService.getById((Serializable)((Object)policyId)))) != null && accessPolicy.getLowestMark() != null) {
            queryWrapper.ge((Object)"total_score", (Object)accessPolicy.getLowestMark());
        }
        queryWrapper.orderByDesc((Object)"update_time");
        if (StringUtils.isNotBlank((CharSequence)accessCateCode)) {
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(PurchaseStandardHead::getCateCode)).or()).eq(PurchaseStandardHead::getCateCode, (Object)accessCateCode)).or()).eq(PurchaseStandardHead::getCateCode, (Object)"");
            });
        }
        if (StringUtils.isNotBlank((CharSequence)accessPurchaseOrg)) {
            queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(PurchaseStandardHead::getPurchaseOrg)).or()).eq(PurchaseStandardHead::getPurchaseOrg, (Object)accessPurchaseOrg)).or()).eq(PurchaseStandardHead::getPurchaseOrg, (Object)"");
            });
        }
        if (StringUtils.isNotBlank((CharSequence)accessLowestMark)) {
            queryWrapper.lambda().gt(PurchaseStandardHead::getTotalScore, (Object)accessLowestMark);
        }
        if (StringUtils.isNotBlank((CharSequence)accessToElsAccount)) {
            queryWrapper.lambda().eq(PurchaseStandardHead::getToElsAccount, (Object)accessToElsAccount);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseStandardHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:add"})
    @PermissionDataOpt(businessType="purchase_standard", beanClass=PurchaseStandardHeadService.class)
    @FormCommit
    public Result<?> add(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.saveMain(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList(), purchaseStandardHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseStandardHead));
    }

    @ApiOperation(value="\u5206\u9879\u51c6\u5165\u5355-\u590d\u5236", notes="\u5206\u9879\u51c6\u5165\u5355-\u590d\u5236")
    @GetMapping(value={"/copyById"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:copy"})
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.purchaseStandardHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:edit"})
    @PermissionDataOpt(businessType="purchase_standard", beanClass=PurchaseStandardHeadService.class)
    @FormCommit
    public Result<?> edit(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.updateMain(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList(), purchaseStandardHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u68c0\u67e5\u7f16\u8f91")
    @ApiOperation(value="\u68c0\u67e5\u7f16\u8f91", notes="\u68c0\u67e5\u7f16\u8f91")
    @PostMapping(value={"/checkEdit"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:edit"})
    @PermissionDataOpt(businessType="purchase_standard", beanClass=PurchaseStandardHeadService.class)
    public Result<?> checkEdit(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.updateMainByCheck(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList(), purchaseStandardHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:delete"})
    @PermissionDataOpt(businessType="purchase_standard", beanClass=PurchaseStandardHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseStandardHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseStandardHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseStandardHead purchaseStandardHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadService.getById((Serializable)((Object)id)));
        PurchaseStandardHeadVO purchaseStandardHeadVO = new PurchaseStandardHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHead), (Object)((Object)purchaseStandardHeadVO));
        List<PurchaseStandardItem> purchaseStandardItemList = this.purchaseStandardItemService.selectByMainId(id);
        purchaseStandardHeadVO.setPurchaseStandardItemList(purchaseStandardItemList);
        List<PurchaseAttachmentDTO> purchaseAttachmentList = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseStandardHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        ArrayList<PurchaseAttachmentDTO> modelList = null;
        if (purchaseStandardItemList != null) {
            modelList = new ArrayList<PurchaseAttachmentDTO>();
            for (PurchaseStandardItem item : purchaseStandardItemList) {
                List<PurchaseAttachmentDTO> attachments = this.supplierInvokeBaseRpcService.purcahseSelectByMainId(item.getStandardId());
                modelList.addAll(attachments);
            }
            purchaseStandardHeadVO.setModelAttachmentList(modelList);
        }
        return Result.ok((Object)((Object)purchaseStandardHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u51c6\u5165\u5934id\u67e5\u8be2\u91c7\u8d2d\u51c6\u5165\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u51c6\u5165\u5934id\u67e5\u8be2\u91c7\u8d2d\u51c6\u5165\u884c")
    @GetMapping(value={"/querypurchaseStandardItemByMainId"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:view"})
    public Result<?> querypurchaseStandardItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseStandardItem> purchaseStandardItemList = this.purchaseStandardItemService.selectByMainId(id);
        return Result.ok(purchaseStandardItemList);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03/\u53d1\u9001", notes="\u53d1\u5e03/\u53d1\u9001")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:add"})
    public Result<?> publish(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.publish(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList(), purchaseStandardHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u7b54\u9898\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:add"})
    public Result<?> submit(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.submit(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList(), purchaseStandardHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u8bc4\u5206\u63d0\u4ea4")
    @ApiOperation(value="\u8bc4\u5206", notes="\u8bc4\u5206")
    @PostMapping(value={"/grade"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:scoret"})
    public Result<?> grade(@RequestBody PurchaseStandardHeadVO purchaseStandardHeadPage) {
        PurchaseStandardHead purchaseStandardHead = new PurchaseStandardHead();
        BeanUtils.copyProperties((Object)((Object)purchaseStandardHeadPage), (Object)((Object)purchaseStandardHead));
        this.purchaseStandardHeadService.grade(purchaseStandardHead, purchaseStandardHeadPage.getPurchaseStandardItemList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7headId\u67e5\u8be2", notes="\u901a\u8fc7headId\u67e5\u8be2")
    @GetMapping(value={"/queryItemById"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:view"})
    public Result<?> queryItemById(@RequestParam(name="id", required=true) String id) {
        PurchaseStandardHeadVO purchaseStandardHeadVO = new PurchaseStandardHeadVO();
        List<PurchaseStandardItem> purchaseStandardItemList = this.purchaseStandardItemService.selectByMainId(id);
        purchaseStandardHeadVO.setPurchaseStandardItemList(purchaseStandardItemList);
        return Result.ok((Object)((Object)purchaseStandardHeadVO));
    }

    @AutoLog(busModule="\u5206\u9879\u51c6\u5165\u5355", value="\u8f6c\u5165\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599")
    @ApiOperation(value="\u8f6c\u5165\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599", notes="\u8f6c\u5165\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599")
    @GetMapping(value={"/shiftTo"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:shiftTo"})
    @PermissionDataOpt(businessType="purchase_standard", beanClass=PurchaseStandardHeadService.class)
    public Result<?> shiftTo(@RequestParam(name="id", required=true) String id, @RequestParam(name="templateNumber", required=true) String templateNumber, @RequestParam(name="templateVersion", required=true) String templateVersion, @RequestParam(name="templateName", required=true) String templateName, @RequestParam(name="templateAccount", required=true) String templateAccount) {
        return this.purchaseStandardHeadService.shiftTo(id, templateNumber, templateVersion, templateName, templateAccount);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"purchase_standard#purchaseStandardHead:list"})
    public Result<?> queryTabsCount(PurchaseStandardHead standardHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)standardHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"standard_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"standard_status");
        List list = ((PurchaseStandardHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseStandardHead::getStandardStatus, PurchaseStandardHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "standardStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmStandardStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            if ("4".equals(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "standardStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

