/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.supplier.entity.PurchaseVisitHead;
import com.els.modules.supplier.entity.PurchaseVisitItem;
import com.els.modules.supplier.service.PurchaseVisitHeadService;
import com.els.modules.supplier.service.PurchaseVisitItemService;
import com.els.modules.supplier.vo.PurchaseVisitHeadTransferVO;
import com.els.modules.supplier.vo.PurchaseVisitHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/purchaseVisitHead"})
@Api(tags={"\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f"})
public class PurchaseVisitHeadController
extends BaseController<PurchaseVisitHead, PurchaseVisitHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseVisitHeadController.class);
    @Autowired
    private PurchaseVisitHeadService purchaseVisitHeadService;
    @Autowired
    private PurchaseVisitItemService purchaseVisitItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:list"})
    @PermissionDataView(businessType="bookVisit")
    public Result<?> queryPageList(PurchaseVisitHead purchaseVisitHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseVisitHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseVisitHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:add"})
    public Result<?> add(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.saveMain(purchaseVisitHead, purchaseVisitHeadPage.getPurchaseVisitItemList(), purchaseVisitHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)this.purchaseVisitHeadService.queryById(purchaseVisitHead.getId())));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:edit"})
    public Result<?> edit(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.updateMain(purchaseVisitHead, purchaseVisitHeadPage.getPurchaseVisitItemList(), purchaseVisitHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)this.purchaseVisitHeadService.queryById(purchaseVisitHead.getId())));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseVisitHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseVisitHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.purchaseVisitHeadService.queryById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606fid\u67e5\u8be2\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606fid\u67e5\u8be2\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseVisitItemByMainId"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:view"})
    public Result<?> queryPurchaseVisitItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseVisitItem> purchaseVisitItemList = this.purchaseVisitItemService.selectByMainId(id);
        return Result.ok(purchaseVisitItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:list"})
    @PermissionDataView(businessType="bookVisit")
    public Result<?> queryTabsCount(PurchaseVisitHead purchaseVisitHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseVisitHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"visit_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"visit_status");
        List list = ((PurchaseVisitHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseVisitHead::getVisitStatus, PurchaseVisitHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "visitStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmVisitStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "visitStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:submit", "visit#purchaseVisitHead:publish"}, logical=Logical.OR)
    public Result<?> publish(@RequestBody PurchaseVisitHeadVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.purchaseVisitHeadService.publish(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publishAudit"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:publishAudit"})
    public Result<?> publishAudit(@RequestBody PurchaseVisitHeadVO headVO) {
        this.purchaseVisitHeadService.publishAudit(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934-\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:invalid"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseVisitHeadService.cancel(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"visit#purchaseVisitHead:copy"})
    public Result<?> copy(@RequestParam(name="id") String id) {
        PurchaseVisitHeadVO purchaseVisitHeadVO = this.purchaseVisitHeadService.queryById(id);
        if (purchaseVisitHeadVO == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01"));
        }
        this.purchaseVisitHeadService.copy(purchaseVisitHeadVO);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934-\u8f6c\u529e")
    @ApiOperation(value="\u8f6c\u529e", notes="\u8f6c\u529e")
    @PostMapping(value={"/tacticsTransfer"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:tacticsTransfer"})
    public Result<?> tacticsTransfer(@RequestBody PurchaseVisitHeadTransferVO purchaseVisitHeadTransferVO) {
        this.purchaseVisitHeadService.tacticsTransfer(purchaseVisitHeadTransferVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:confirm"})
    public Result<?> confirm(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.confirm(purchaseVisitHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/refuse"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:rejected"})
    public Result<?> refuse(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.refuse(purchaseVisitHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u603b\u7ed3\u62dc\u8bbf\u9884\u7ea6")
    @ApiOperation(value="\u603b\u7ed3\u62dc\u8bbf\u9884\u7ea6", notes="\u603b\u7ed3\u62dc\u8bbf\u9884\u7ea6")
    @PostMapping(value={"/summaryVisit"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:visitSummary"})
    public Result<?> summaryVisit(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.summary(purchaseVisitHead, purchaseVisitHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9884\u7ea6\u62dc\u8bbf\u5934\u4fe1\u606f", value="\u8bc4\u4ef7\u62dc\u8bbf\u9884\u7ea6")
    @ApiOperation(value="\u8bc4\u4ef7\u62dc\u8bbf\u9884\u7ea6", notes="\u8bc4\u4ef7\u62dc\u8bbf\u9884\u7ea6")
    @PostMapping(value={"/evaluationVisit"})
    @SrmValidated
    @RequiresPermissions(value={"visit#purchaseVisitHead:visitEvaluation"})
    public Result<?> evaluationVisit(@RequestBody PurchaseVisitHeadVO purchaseVisitHeadPage) {
        PurchaseVisitHead purchaseVisitHead = new PurchaseVisitHead();
        BeanUtils.copyProperties((Object)((Object)purchaseVisitHeadPage), (Object)((Object)purchaseVisitHead));
        this.purchaseVisitHeadService.evaluation(purchaseVisitHead, purchaseVisitHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }
}

