/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierAccessItem;
import com.els.modules.supplier.enumerate.SupplierAccessStatusEnum;
import com.els.modules.supplier.service.SupplierAccessHeadService;
import com.els.modules.supplier.service.SupplierAccessItemService;
import com.els.modules.supplier.service.SupplierDevDemandHeadService;
import com.els.modules.supplier.vo.SupplierAccessHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supplier/supplierAccessHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165\u5934"})
public class SupplierAccessHeadController
extends BaseController<SupplierAccessHead, SupplierAccessHeadService> {
    @Autowired
    private SupplierAccessHeadService supplierAccessHeadService;
    @Autowired
    private SupplierAccessItemService supplierAccessItemService;
    @Autowired
    private SupplierDevDemandHeadService supplierDevDemandHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="supplierAccess")
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:list"})
    public Result<?> queryPageList(SupplierAccessHead supplierAccessHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.supplierAccessHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:add"})
    @PermissionDataOpt(businessType="supplierAccess", beanClass=SupplierAccessHeadService.class)
    @FormCommit
    public Result<?> add(@RequestBody SupplierAccessHeadVO supplierAccessHeadPage) {
        SupplierAccessHead supplierAccessHead = new SupplierAccessHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessHeadPage), (Object)((Object)supplierAccessHead));
        this.supplierAccessHeadService.saveMain(supplierAccessHead, supplierAccessHeadPage.getSupplierAccessItemList());
        return Result.ok((Object)((Object)supplierAccessHead));
    }

    @ApiOperation(value="\u51c6\u5165\u7ba1\u7406-\u590d\u5236", notes="\u51c6\u5165\u7ba1\u7406-\u590d\u5236")
    @GetMapping(value={"/copyById"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:copy"})
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.supplierAccessHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:edit"})
    @PermissionDataOpt(businessType="supplierAccess", beanClass=SupplierAccessHeadService.class)
    @FormCommit
    public Result<?> edit(@RequestBody SupplierAccessHeadVO supplierAccessHeadPage) {
        SupplierAccessHead supplierAccessHead = new SupplierAccessHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessHeadPage), (Object)((Object)supplierAccessHead));
        if ("1".equals(supplierAccessHead.getRequiredAudit())) {
            supplierAccessHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else if ("0".equals(supplierAccessHead.getRequiredAudit())) {
            supplierAccessHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.supplierAccessHeadService.updateMain(supplierAccessHead, supplierAccessHeadPage.getSupplierAccessItemList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u4f9b\u5e94\u5546\u51c6\u5165\u5934\u4fe1\u606f", value="\u53d1\u5e03")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:submit"})
    @PermissionDataOpt(businessType="supplierAccess", beanClass=SupplierAccessHeadService.class)
    public Result<?> submit(@RequestBody SupplierAccessHeadVO supplierAccessHeadPage) {
        SupplierAccessHead supplierAccessHead = new SupplierAccessHead();
        BeanUtils.copyProperties((Object)((Object)supplierAccessHeadPage), (Object)((Object)supplierAccessHead));
        supplierAccessHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        supplierAccessHead.setAccessStatus(SupplierAccessStatusEnum.PUBLISH.getValue());
        this.supplierAccessHeadService.updateMain(supplierAccessHead, supplierAccessHeadPage.getSupplierAccessItemList());
        this.supplierDevDemandHeadService.updDevDemandItemAccess(supplierAccessHead, null);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:delete"})
    @PermissionDataOpt(businessType="supplierAccess", beanClass=SupplierAccessHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.supplierAccessHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.supplierAccessHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SupplierAccessHead supplierAccessHead = (SupplierAccessHead)((Object)this.supplierAccessHeadService.getById((Serializable)((Object)id)));
        SupplierAccessHeadVO supplierAccessHeadVO = new SupplierAccessHeadVO();
        BeanUtils.copyProperties((Object)((Object)supplierAccessHead), (Object)((Object)supplierAccessHeadVO));
        List<SupplierAccessItem> supplierAccessItemList = this.supplierAccessItemService.selectByMainId(id);
        supplierAccessHeadVO.setSupplierAccessItemList(supplierAccessItemList);
        return Result.ok((Object)((Object)supplierAccessHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u51c6\u5165\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u884c")
    @GetMapping(value={"/querySupplierAccessItemByMainId"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:view"})
    public Result<?> querySupplierAccessItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SupplierAccessItem> supplierAccessItemList = this.supplierAccessItemService.selectByMainId(id);
        return Result.ok(supplierAccessItemList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:list"})
    public Result<?> queryTabsCount(SupplierAccessHead standardHead, HttpServletRequest req) {
        String[] statuses;
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)standardHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"audit_status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"audit_status");
        List list = ((SupplierAccessHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierAccessHead::getAuditStatus, SupplierAccessHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "auditStatus", null, all));
        for (String status : statuses = new String[]{"0", "1", "2", "3"}) {
            Integer total = countMap.get(status) == null ? Integer.valueOf(0) : countMap.get(status);
            result.add(new CountVO(AuditStatusEnum.getByValue((String)status), "auditStatus", status, total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u81ea\u5b9a\u4e49", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u81ea\u5b9a\u4e49")
    @GetMapping(value={"/customlist"})
    @PermissionDataView(businessType="supplierAccess")
    @RequiresPermissions(value={"supplierAccess#supplierAccessHead:list"})
    public Result<?> selectCustomPage(SupplierAccessHead supplierAccessHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierAccessHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SupplierAccessHead> pageList = this.supplierAccessHeadService.selectCustomPage((Page<SupplierAccessHead>)page, (QueryWrapper<SupplierAccessHead>)queryWrapper);
        return Result.ok(pageList);
    }
}

