/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierCertificatedInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterFrozen;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.excel.SupplierMasterDataExportServiceImpl;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierCertificatedInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.service.SupplierMasterFrozenService;
import com.els.modules.supplier.service.SupplierOrgInfoService;
import com.els.modules.supplier.vo.EnterpriseInfoVo;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.modules.supplier.vo.RiskVO;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.supplier.vo.SupplierMasterFrozenVO;
import com.els.modules.supplier.vo.SupplierSearchVO;
import com.els.modules.supplier.vo.SupplyExtendVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/supplier/supplierMaster"})
@Api(tags={"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e"})
public class SupplierMasterDataController
extends BaseController<SupplierMasterData, SupplierMasterDataService> {
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierAddressInfoService supplierAddressInfoService;
    @Autowired
    private SupplierBankInfoService supplierBankInfoService;
    @Autowired
    private SupplierCertificatedInfoService supplierCertificatedInfoService;
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Autowired
    private SupplierOrgInfoService supplierOrgInfoService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierInvokeEnterpriseRpcService;
    @Autowired
    private SupplierMasterFrozenService supplierMasterFrozenService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RiskService riskService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> queryPageList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<String> idList;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Map parameters = req.getParameterMap();
        Set keys = parameters.keySet();
        String frozenFunctionValue = null;
        String purchaseOrg = null;
        String companyOrg = null;
        String purchaseOrgItemList = null;
        String accessCategoryFilter = null;
        String purchaseOrganization = null;
        String accessCategoryList = null;
        ArrayList ignoreSupplierStatusList = null;
        for (String string : keys) {
            if ("frozenFunctionValue".equals(string) && parameters.get(string) != null) {
                frozenFunctionValue = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrg".equals(string) && parameters.get(string) != null) {
                purchaseOrg = ((String[])parameters.get(string))[0];
            }
            if ("companyOrg".equals(string) && parameters.get(string) != null) {
                companyOrg = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrgItemList".equals(string) && parameters.get(string) != null) {
                purchaseOrgItemList = ((String[])parameters.get(string))[0];
            }
            if ("accessCategoryFilter".equals(string) && parameters.get(string) != null) {
                accessCategoryFilter = ((String[])parameters.get(string))[0];
            }
            if ("purchaseOrganization".equals(string) && parameters.get(string) != null) {
                purchaseOrganization = ((String[])parameters.get(string))[0];
            }
            if ("accessCategoryList".equals(string) && parameters.get(string) != null) {
                accessCategoryList = ((String[])parameters.get(string))[0];
            }
            if ("accessCategoryList".equals(string) && parameters.get(string) != null) {
                accessCategoryList = ((String[])parameters.get(string))[0];
            }
            if (!"ignoreSupplierStatusList".equals(string) || parameters.get(string) == null) continue;
            ignoreSupplierStatusList = Lists.newArrayList((Object[])((String[])parameters.get(string))[0].split(","));
        }
        if (CollUtil.isNotEmpty(ignoreSupplierStatusList)) {
            queryWrapper.lambda().notIn(SupplierMasterData::getSupplierStatus, ignoreSupplierStatusList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue)) {
            ArrayList<String> supplierStatusList;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)supplierMasterData.getSupplierStatus()) && ("3".equals(supplierMasterData.getSupplierStatus()) || "4".equals(supplierMasterData.getSupplierStatus()))) {
                supplierStatusList = new ArrayList();
                supplierStatusList.add("3");
                supplierStatusList.add("0");
                supplierStatusList.add("1");
                supplierStatusList.add("2");
                supplierStatusList.add("3");
                supplierStatusList.add("4");
                queryWrapper.notIn((Object)"supplier_status", supplierStatusList);
            } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierMasterData.getSupplierStatus())) {
                supplierStatusList = new ArrayList<String>();
                supplierStatusList.add("3");
                supplierStatusList.add("4");
                queryWrapper.notIn((Object)"supplier_status", supplierStatusList);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "0", purchaseOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(companyOrg) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdList(frozenFunctionValue, "1", companyOrg)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(purchaseOrgItemList) && org.apache.commons.lang3.StringUtils.isNotBlank(frozenFunctionValue) && !(idList = this.supplierMasterFrozenService.getFrozenMasterDadaIdListToSource(purchaseOrgItemList)).isEmpty() && idList.size() > 0) {
            queryWrapper.notIn((Object)"id", idList);
        }
        if ("1".equals(accessCategoryFilter)) {
            if (org.apache.commons.lang3.StringUtils.isBlank(purchaseOrganization) || org.apache.commons.lang3.StringUtils.isBlank(accessCategoryList)) {
                return Result.ok((Object)new Page());
            }
            ArrayList<String> categoryList = new ArrayList<String>(Arrays.asList(accessCategoryList.split(",")));
            if (!categoryList.contains("all")) {
                List<String> idList2 = this.supplierOrgInfoService.getMasterDateIdListFromOrgInfo(TenantContext.getTenant(), purchaseOrganization, categoryList);
                if (!idList2.isEmpty()) {
                    queryWrapper.in((Object)"id", idList2);
                } else {
                    return Result.ok((Object)new Page());
                }
            }
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        IPage<SupplierMasterDataVO> result = this.supplierMasterDataService.convertToSupplierMasterDataVO((IPage<SupplierMasterData>)pageList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8ba1\u7b97\u5355\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u9875\u5217\u8868", notes="\u8ba1\u7b97\u5355\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/queryPageListByCalculation"})
    public Result<?> queryPageListByCalculation(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String[] filterPurchaseTypes = (String[])req.getParameterMap().get("ids");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.in((Object)"supplier_status", new Object[]{SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue(), SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue(), SupplierStatusEnum.UNFAMILIAR_SUPPLIER.getValue()});
        if (null != filterPurchaseTypes && filterPurchaseTypes.length > 0 && !StringUtils.isEmpty((String)filterPurchaseTypes[0])) {
            ArrayList filterPurchaseType = Lists.newArrayList((Object[])filterPurchaseTypes[0].split(","));
            queryWrapper.in((Object)"id", (Collection)filterPurchaseType);
        }
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryMasterDataList"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryMasterDataList(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:add"})
    public Result<?> add(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        BeanUtils.copyProperties((Object)((Object)supplierMasterDataPage), (Object)((Object)supplierMasterData));
        this.supplierMasterDataService.saveMain(supplierMasterData, supplierMasterDataPage);
        return Result.ok((Object)((Object)supplierMasterData));
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:edit"})
    public Result<?> edit(@RequestBody SupplierMasterDataVO supplierMasterDataPage) {
        this.supplierMasterDataService.updateMain(supplierMasterDataPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.supplierMasterDataService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.supplierMasterDataService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.supplierMasterDataService.getDataById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/querySupplierAddressInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierAddressInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierAddressInfo> supplierAddressInfoList = this.supplierAddressInfoService.selectByMainId(id);
        return Result.ok(supplierAddressInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/querySupplierBankInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierBankInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierBankInfo> supplierBankInfoList = this.supplierBankInfoService.selectByMainId(id);
        return Result.ok(supplierBankInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba4\u8bc1\u8d44\u6599\u4fe1\u606f")
    @GetMapping(value={"/querySupplierCertificatedInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierCertificatedInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierCertificatedInfo> supplierCertificatedInfoList = this.supplierCertificatedInfoService.selectByMainId(id);
        return Result.ok(supplierCertificatedInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/querySupplierContactsInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierContactsInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierContactsInfo> supplierContactsInfoList = this.supplierContactsInfoService.selectByMainId(id);
        return Result.ok(supplierContactsInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u4e3b\u6570\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/querySupplierOrgInfoByMainId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierOrgInfoListByMainId(@RequestParam(name="id") String id) {
        List<SupplierOrgInfo> supplierOrgInfoList = this.supplierOrgInfoService.selectByMainId(id);
        return Result.ok(supplierOrgInfoList);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:supplierDataExport"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, SupplierMasterDataExportServiceImpl.class);
    }

    public SupplierMasterDataVO queryByElsAccount(String elsAccount) {
        String currentAccount = TenantContext.getTenant();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)elsAccount)) {
            elsAccount = currentAccount;
        }
        SupplierMasterDataVO supplierMasterDataVO = new SupplierMasterDataVO();
        if (!currentAccount.equals("100000") && !currentAccount.equals(elsAccount)) {
            SupplierMasterData supplierMasterData = this.supplierMasterDataService.getByAccount(currentAccount, elsAccount);
            BeanUtils.copyProperties((Object)((Object)supplierMasterData), (Object)((Object)supplierMasterDataVO));
        }
        String toELsAccount = null;
        if (!currentAccount.equals(elsAccount) && !currentAccount.equals("100000")) {
            toELsAccount = currentAccount;
        }
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierAddressInfoList(addressInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierBankInfoList(bankInfo);
        List<SupplierOrgInfo> orgInfo = this.supplierOrgInfoService.getByAccount(elsAccount, toELsAccount);
        supplierMasterDataVO.setSupplierOrgInfoList(orgInfo);
        return supplierMasterDataVO;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryByEnterpriseId"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryByEnterpriseId(@RequestParam(name="id") String id) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getById(id);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n__mhGNWVKHRvjW_638fd67c", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        String elsAccount = elsEnterpriseInfo.getElsAccount();
        SupplierMasterDataVO supplierMasterDataVO = this.queryByElsAccount(elsAccount);
        if (supplierMasterDataVO != null) {
            enterpriseInfoVo.setSupplierAddressInfoList(supplierMasterDataVO.getSupplierAddressInfoList());
            enterpriseInfoVo.setSupplierBankInfoList(supplierMasterDataVO.getSupplierBankInfoList());
            enterpriseInfoVo.setSupplierOrgInfoList(supplierMasterDataVO.getSupplierOrgInfoList());
            enterpriseInfoVo.setSupplierContactsInfoList(supplierMasterDataVO.getSupplierContactsInfoList());
        }
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u4ee3\u6ce8\u518c")
    @ApiOperation(value="\u4ee3\u6ce8\u518c", notes="\u4ee3\u6ce8\u518c")
    @PostMapping(value={"/replaceRegister"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:replaceRegister"})
    public Result<?> replaceRegister(@RequestBody RegisterVO registerVO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_title_enterpriseNameCannotBeEmpty", (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getContactsName())) {
            registerVO.setContactsName(registerVO.getCompanyName());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getPassword())) {
            registerVO.setPassword(null);
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryCurrentEnterprise"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:queryCurrentEnterprise"})
    public Result<?> queryCurrentEnterprise() {
        String currentAccount = TenantContext.getTenant();
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(currentAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_mhGNWVKHRvj_55cacd25", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)elsEnterpriseInfo, (Object)((Object)enterpriseInfoVo));
        List<SupplierContactsInfo> contactsInfo = this.supplierContactsInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierContactsInfoList(contactsInfo);
        List<SupplierAddressInfo> addressInfo = this.supplierAddressInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierAddressInfoList(addressInfo);
        List<SupplierCertificatedInfo> certificatedInfo = this.supplierCertificatedInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierCertificatedInfoList(certificatedInfo);
        List<SupplierBankInfo> bankInfo = this.supplierBankInfoService.getDataOnlyAccount(currentAccount);
        enterpriseInfoVo.setSupplierBankInfoList(bankInfo);
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u67e5\u8be2", notes="\u4f9b\u5e94\u5546\u67e5\u8be2")
    @GetMapping(value={"/supplierlist"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> supplierlist(SupplierMasterData supplierMasterData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u65b9\u4f01\u4e1a\u5bf9\u5e94\u91c7\u8d2d\u65b9\u4fe1\u606f")
    @GetMapping(value={"/querySupplierData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> querySupplierData(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        IPage<SupplierMasterData> pageList = this.supplierMasterDataService.pageSupplierDataByToElsAccount(pageNo, pageSize, TenantContext.getTenant());
        List records = pageList.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return Result.ok(pageList);
        }
        List<String> account = records.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> dtos = this.supplierInvokeEnterpriseRpcService.queryByElsAccountList(account);
        if (CollUtil.isNotEmpty(dtos)) {
            Map<String, String> map = dtos.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsEnterpriseInfoDTO::getName, (v1, v2) -> v2));
            for (SupplierMasterData data : pageList.getRecords()) {
                data.setName(map.get(data.getElsAccount()));
            }
        }
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u6ce8\u518c")
    @ApiOperation(value="\u6ce8\u518c", notes="\u6ce8\u518c")
    @PostMapping(value={"/register"})
    public Result<?> register(@RequestBody RegisterVO registerVO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getCompanyName())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_RCRLxOLV_3f6f291f", (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getPhoneNumber())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_title_mobilePhoneNumberCannotEmpty", (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registerVO.getNoteCode())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltJOoxOLV_980e86b7", (String)"\u624b\u673a\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Object code = this.redisUtil.get(registerVO.getPhoneNumber());
        if (code == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltOioIKX_e2b7cf4c", (String)"\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff01"));
        }
        if (!registerVO.getNoteCode().equals(code)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltOioNSW_e38d976e", (String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01"));
        }
        return this.supplierMasterDataService.register(registerVO);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0", notes="\u4f9b\u5e94\u5546\u53d1\u73b0")
    @GetMapping(value={"/searchSupplier"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> searchSupplier(SupplierSearchVO searchVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.searchSupplier(searchVO, pageNo, pageSize));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6", notes="\u4f9b\u5e94\u5546\u53d1\u73b0--\u67e5\u8be2\u6761\u4ef6")
    @GetMapping(value={"/search"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> search(SupplierSearchVO searchVO) {
        Result result = new Result();
        result.setResult((Object)this.supplierMasterDataService.search(searchVO));
        result.setSuccess(true);
        return result;
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u53d1\u73b0-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/queryEnterprise"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:searchSupplier"})
    public Result<?> queryEnterprise(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="name") String name) {
        return this.supplierMasterDataService.queryEnterpriseNew(elsAccount, name);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u8f6c\u6f5c")
    @ApiOperation(value="\u8f6c\u6f5c", notes="\u8f6c\u6f5c")
    @PostMapping(value={"/unfamiliarToPotential"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:unfamiliarToPotential"})
    public Result<?> unfamiliarToPotential(@RequestBody RegisterVO registerVO) {
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        return this.supplierMasterDataService.unfamiliarToPotential(registerVO);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u53d1\u73b0-\u8f6c\u964c\u751f")
    @ApiOperation(value="\u8f6c\u964c\u751f", notes="\u8f6c\u964c\u751f")
    @PostMapping(value={"/discoverToUnfamiliar"})
    @RequiresPermissions(value={"supplier_master_data#supplierMaster:discoverToUnfamiliar"})
    public Result<?> discoverToUnfamiliar(@RequestBody RegisterVO registerVO) {
        registerVO.setSourceType(SourceTypeEnum.PLATFIRM_SEARCH.getValue());
        registerVO.setPassword("123456");
        return this.supplierMasterDataService.discoverToUnfamiliar(registerVO);
    }

    @GetMapping(value={"/getSubAccounts"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getSubAccounts(@RequestParam(value="elsAccount") String elsAccount) {
        List<ElsSubAccountDTO> subAccounts = this.supplierInvokeAccountRpcService.getAllByAccount(elsAccount);
        return Result.ok(subAccounts.stream().filter(o -> "1001".equals(o.getSubAccount())).collect(Collectors.toList()));
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u8ba4\u8bc1\u8d44\u6599")
    @GetMapping(value={"/certificatedInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage"}, logical=Logical.OR)
    public Result<?> certificatedInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            result.setResult(this.supplierCertificatedInfoService.selectByMainId(masterData.getId()));
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/baseInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage"}, logical=Logical.OR)
    public Result<?> baseInfo(@RequestParam(name="toElsAccount") String toElsAccount) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(toElsAccount);
        return Result.ok((Object)elsEnterpriseInfo);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4", notes="\u4f9b\u5e94\u5546\u753b\u50cf-\u4f9b\u5e94\u8303\u56f4")
    @GetMapping(value={"/supplyExtend"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list", "supplier_master_data#supplierMasterData:picImage"}, logical=Logical.OR)
    public Result<?> supplyExtend(@RequestParam(name="toElsAccount") String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toElsAccount);
        if (masterData != null) {
            Result result = new Result();
            SupplyExtendVO extendVO = new SupplyExtendVO();
            extendVO.setOrgInfos(this.supplierOrgInfoService.selectByMainId(masterData.getId()));
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterData.getAccessCategory())) {
                extendVO.setAccessCategroy(masterData.getAccessCategory().split(";"));
            }
            result.setResult((Object)extendVO);
            result.setSuccess(true);
            return result;
        }
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getContractInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getContractInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)toElsAccount);
        });
        IPage pageList = this.supplierContactsInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getContract"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getContract(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)toElsAccount);
        });
        IPage pageList = this.supplierContactsInfoService.page((IPage)page, (Wrapper)queryWrapper);
        List<Object> elsSubAccountDTOList = null;
        Page pageList2 = new Page();
        ArrayList list = new ArrayList();
        if (pageList.getRecords().size() == 0) {
            elsSubAccountDTOList = this.supplierInvokeAccountRpcService.getAllByAccount(elsAccount);
        } else {
            elsSubAccountDTOList = new ArrayList();
            for (SupplierContactsInfo supplierContactsInfo : pageList.getRecords()) {
                ElsSubAccountDTO elsSubAccountDTO = new ElsSubAccountDTO();
                elsSubAccountDTO.setPost(supplierContactsInfo.getPosition());
                elsSubAccountDTO.setEmail(supplierContactsInfo.getEmail());
                elsSubAccountDTO.setRealname(supplierContactsInfo.getName());
                elsSubAccountDTO.setPhone(supplierContactsInfo.getTelphone());
                elsSubAccountDTOList.add(elsSubAccountDTO);
            }
        }
        BeanUtils.copyProperties((Object)pageList, (Object)pageList2);
        pageList2.setRecords(elsSubAccountDTOList);
        return Result.ok((Object)pageList2);
    }

    @ApiOperation(value="\u83b7\u53d6\u5730\u5740\u4fe1\u606f", notes="\u83b7\u53d6\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/getAddressInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getAddressInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)elsAccount);
        });
        IPage pageList = this.supplierAddressInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f", notes="\u83b7\u53d6\u94f6\u884c\u4fe1\u606f")
    @GetMapping(value={"/getBankInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getBankInfo(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.isNull((Object)"to_els_account")).or()).eq((Object)"to_els_account", (Object)elsAccount);
        });
        IPage pageList = this.supplierBankInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u98ce\u9669\u67e5\u8be2", notes="\u98ce\u9669\u67e5\u8be2")
    @PostMapping(value={"/queryRisk"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:risk"})
    public Result<?> queryRisk(@RequestBody RiskVO riskVO) {
        return this.riskService.queryRisk(riskVO);
    }

    @SrmValidated
    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f", notes="\u66f4\u65b0\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/updateBaseInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:updateBaseInfo"})
    public Result<?> updateBaseInfo(@RequestBody SupplierMasterData supplierMasterData) {
        return this.supplierMasterDataService.updateBaseInfo(supplierMasterData);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    @PermissionDataView(businessType="supplierMasterData")
    public Result<?> queryTabsCount(SupplierMasterData supplierMasterData, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)supplierMasterData), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"supplier_status", "count(0) as participate_quantity"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"supplier_status");
        List list = ((SupplierMasterDataService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SupplierMasterData::getSupplierStatus, SupplierMasterData::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "supplierStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmSupplierStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "supplierStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3", notes="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3")
    @PostMapping(value={"/isExistFrozenStateData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> isExistFrozenStateData(@RequestBody SupplierMasterFrozen frozen) {
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(frozen.getToElsAccount());
        SupplierMasterFrozen data = this.supplierMasterFrozenService.isExistFrozenStateData(toElsAccountList, frozen.getFrozenFunction(), frozen.getOrgType(), frozen.getOrgCode());
        if (data != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data.getId())) {
            String toElsAcount = data.getToElsAccount();
            String orgCodeText = data.getCurrentOrgCodeText();
            String frozenFunctionText = data.getFrozenFunctionText();
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWWKWWWWWWjWWWWWWROIqOy_1d833591", (String)"[${0}]\u5728 [${1}]\u7684[${2}]\u529f\u80fd\u5df2\u88ab\u51bb\u7ed3", (String[])new String[]{toElsAcount, orgCodeText, frozenFunctionText}));
        }
        return Result.ok();
    }

    @ApiOperation(value="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3-\u5bfb\u6e90", notes="\u5224\u65ad\u4f9b\u5e94\u5546\u662f\u5426\u88ab\u51bb\u7ed3-\u5bfb\u6e90")
    @PostMapping(value={"/isExistFrozenSource"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> isExistFrozenSource(@RequestBody SupplierMasterFrozenVO frozen) {
        SupplierMasterFrozen data = this.supplierMasterFrozenService.isExistFrozenSource(frozen);
        if (data != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data.getId())) {
            String toElsAcount = data.getToElsAccount();
            String orgCodeText = data.getCurrentOrgCodeText();
            String frozenFunctionText = data.getFrozenFunctionText();
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWWKWWWWWWjWWWWWWROIqOy_1d833591", (String)"[${0}]\u5728 [${1}]\u7684[${2}]\u529f\u80fd\u5df2\u88ab\u51bb\u7ed3", (String[])new String[]{toElsAcount, orgCodeText, frozenFunctionText}));
        }
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7elsAccount\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7elsAccount\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryEnterpriseByElsAccount"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> queryEnterpriseByElsAccount(@RequestParam(name="elsAccount") String elsAccount) {
        ElsEnterpriseInfoDTO elsEnterpriseInfo = this.supplierInvokeEnterpriseRpcService.getByElsAccount(elsAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_mhGNWVKHRvj_55cacd25", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        return Result.ok((Object)elsEnterpriseInfo);
    }

    @ApiOperation(value="\u901a\u8fc7elsAccount\u83b7\u53d6\u4f9b\u5e94\u5546\u753b\u50cf\u9875\u9762\u4fe1\u606f", notes="\u901a\u8fc7elsAccount\u83b7\u53d6\u4f9b\u5e94\u5546\u753b\u50cf\u9875\u9762\u4fe1\u606f")
    @GetMapping(value={"/getSupplierPortraitInfo"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:list"})
    public Result<?> getSupplierPortraitInfo(@RequestParam(name="elsAccount") String elsAccount) {
        return Result.ok((Object)this.supplierMasterDataService.getSupplierPortraitInfo(elsAccount));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-\u4eceERP\u83b7\u53d6\u6570\u636e")
    @ApiOperation(value="\u4eceERP\u83b7\u53d6\u6570\u636e", notes="\u4eceERP\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:getDataByErp"})
    public Result<?> getDataByErp() {
        this.supplierMasterDataService.getDataByErp();
        return Result.ok();
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e-SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @ApiOperation(value="SRM\u63a8\u9001\u6d88\u606f\u5230ERP", notes="SRM\u63a8\u9001\u6d88\u606f\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:pushDataToErp"})
    @PermissionDataOpt(businessType="supplierMasterData", beanClass=SupplierMasterDataService.class)
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ids)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ViFYdjWF_6327d1b2", (String)"\u8bf7\u9009\u62e9\u63a8\u9001\u7684\u6570\u636e"));
        }
        this.supplierMasterDataService.pushDataToErp(ids);
        return Result.ok();
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa")
    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa", notes="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u591a\u9875\u7b7e\u5bfc\u51fa")
    @GetMapping(value={"/exportDetailData"})
    @RequiresPermissions(value={"supplier_master_data#supplierMasterData:supplierInfoExport"})
    public void exportDetailData(HttpServletRequest request, HttpServletResponse response) {
        String headIds = request.getParameter("headIds");
        Assert.hasText((String)headIds, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        String tabs = request.getParameter("tabs");
        this.supplierMasterDataService.exportDetailData(headIds, tabs, response);
    }

    @ApiOperation(value="\u5929\u773c\u67e5-\u5e55\u540e\u5173\u7cfb\u53d1\u73b0\uff08\u5f02\u6b65\uff09\u6d4b\u8bd5", notes="\u5929\u773c\u67e5-\u5e55\u540e\u5173\u7cfb\u53d1\u73b0\uff08\u5f02\u6b65\uff09\u6d4b\u8bd5")
    @GetMapping(value={"/queryBehindRelationship"})
    public JSONObject queryBehindRelationship() {
        ArrayList<String> supplierNameList = new ArrayList<String>();
        supplierNameList.add("\u5e7f\u5dde\u68b5\u52d2\u58eb\u8d38\u6613\u6709\u9650\u516c\u53f8");
        supplierNameList.add("\u7ebd\u5929\u8d38\u6613\uff08\u6df1\u5733\uff09\u6709\u9650\u516c\u53f8");
        supplierNameList.add("\u5e7f\u5dde\u7ebd\u5929\u8d38\u6613\u6709\u9650\u516c\u53f8");
        return this.riskService.queryBehindRelationship(supplierNameList);
    }
}

