/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierContactsExcelHandler")
public class SupplierContactsExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierContactsExcelHandler.class);
    private static final Pattern CHINA_PATTERN = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");
    private static final String DEFUALT_VALUE = "123456";
    @Autowired
    private SupplierContactsInfoService supplierContactsInfoService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private SupplierInvokeEnterpriseRpcService elsEnterpriseInfoService;
    @Resource
    private ImGroupInvokeRpcService imGroupInvokeRpcService;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<SupplierContactsInfo> contactsInfos = new ArrayList<SupplierContactsInfo>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> roleMaps = new HashMap<String, Map<String, String>>();
        ArrayList eslSubAccount = Lists.newArrayList();
        String errorTitle = this.getErrorTitle();
        for (Map data : dataList) {
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SupplierContactsInfo.class));
            eslSubAccount.add(entity.getElsAccount() + "_" + entity.getSubAccount());
            if (StringUtils.isNotBlank((CharSequence)entity.getTelphone()) && !CHINA_PATTERN.matcher(entity.getTelphone()).matches()) {
                String msg = I18nUtil.translate((String)"i18n_alert_cWFltyomKNS_cbdebcc", (String)"\u884c\u6570\u636e\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            contactsInfos.add(entity);
        }
        List<String> elsAccountList = contactsInfos.stream().map(BaseEntity::getElsAccount).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        List<ElsEnterpriseInfoDTO> accountList = this.elsEnterpriseInfoService.selectWithoutElsAccountByElsAccountList(elsAccountList);
        Map accountMap = accountList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        List<ElsSubAccountDTO> subAccountList = this.supplierInvokeAccountRpcService.getAccountListByElsSubAccountWithoutUser(eslSubAccount);
        Map accountDTOMap = subAccountList.stream().collect(Collectors.toMap(x -> x.getElsAccount() + "_" + x.getSubAccount(), Function.identity(), (v1, v2) -> v1));
        List<RoleDTO> allRoleList = this.supplierInvokeAccountRpcService.selectWithoutElsAccountOfAllRole(elsAccountList);
        Map<String, List<RoleDTO>> roleMap = allRoleList.stream().collect(Collectors.groupingBy(RoleDTO::getElsAccount));
        int size = contactsInfos.size();
        int i = 1;
        for (int j = size - 1; j >= 0; --j) {
            List<RoleDTO> roleList;
            ElsSubAccountDTO subAccount;
            ((SupplierContactsInfo)((Object)contactsInfos.get(i - 1))).setToElsAccount(SysUtil.getLoginUser().getElsAccount());
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)contactsInfos.get(j));
            if (StrUtil.isBlank((CharSequence)entity.getElsAccount()) || StrUtil.isBlank((CharSequence)entity.getName()) || null == accountMap.get(entity.getElsAccount())) {
                contactsInfos.remove(j);
                continue;
            }
            entity.setDeleted(CommonConstant.DEL_FLAG_0);
            String accountKey = entity.getElsAccount() + "_" + entity.getSubAccount();
            if (!map.containsKey(accountKey) && (subAccount = (ElsSubAccountDTO)accountDTOMap.get(accountKey)) == null) {
                map.put(accountKey, (Object)entity);
            }
            if (!roleMaps.containsKey(entity.getElsAccount()) && null != (roleList = roleMap.get(entity.getElsAccount()))) {
                Map<String, String> temRoleMap = roleList.stream().collect(Collectors.toMap(RoleDTO::getRoleCode, RoleDTO::getId));
                roleMaps.put(entity.getElsAccount(), temRoleMap);
            }
            ++i;
        }
        ArrayList<ElsSubAccountDTO> elsSubAccounts = new ArrayList<ElsSubAccountDTO>();
        for (String sub : map.keySet()) {
            String elsAccount = sub.split("_")[0];
            SupplierContactsInfo entity = (SupplierContactsInfo)((Object)map.get(sub));
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(entity.getElsAccount());
            account.setSubAccount(entity.getSubAccount());
            account.setRealname(entity.getName());
            account.setPhone(entity.getTelphone());
            account.setEmail(entity.getEmail());
            account.setStatus(Integer.valueOf(1));
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)(entity.getElsAccount() + "_" + account.getSubAccount()), (String)(StringUtils.isNotBlank((CharSequence)account.getPhone()) ? account.getPhone() : DEFUALT_VALUE), (String)salt);
            account.setPassword(passwordEncode);
            account.setDeleted(CommonConstant.DEL_FLAG_0);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()))), (String)I18nUtil.translate((String)"i18n_alert_WWWWWWRdXjWWWWWWjKyAoxiR_1d59192b", (String)"[${0}]\u4f9b\u5e94\u5546\u7684[${1}]\u7684\u89d2\u8272\u7f16\u7801\u4e0d\u6b63\u786e", (String[])new String[]{entity.getElsAccount(), entity.getSubAccount()}));
            account = this.supplierInvokeAccountRpcService.addUserWithRole(account, (String)((Map)roleMaps.get(elsAccount)).get(entity.getRoleCode()));
            elsSubAccounts.add(account);
        }
        this.supplierContactsInfoService.saveBatch(contactsInfos);
        List userIdList = elsSubAccounts.stream().map(BaseDTO::getId).collect(Collectors.toList());
        String tenant = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        this.srmPoolExecutor.execute(() -> {
            LoginUserContext.setUser((LoginUser)loginUser);
            TenantContext.setTenant((String)tenant);
            try {
                this.imGroupInvokeRpcService.initGroupBatch(userIdList);
            }
            catch (Exception e) {
                log.error(":::\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            finally {
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

