/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.SaleCertificatedInfo;
import com.els.modules.supplier.mapper.PurchaseCertificatedInfoMapper;
import com.els.modules.supplier.mapper.PurchaseStandardHeadMapper;
import com.els.modules.supplier.mapper.SaleCertificatedInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCertificatedInfoServiceImpl
extends BaseServiceImpl<PurchaseCertificatedInfoMapper, PurchaseCertificatedInfo>
implements PurchaseCertificatedInfoService {
    @Autowired
    private PurchaseCertificatedInfoMapper purchaseCertificatedInfoMapper;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private SaleCertificatedInfoMapper saleCertificatedInfoMapper;
    @Autowired
    private PurchaseStandardHeadMapper purchaseStandardHeadMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        purchaseCertificatedInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseCertificatedInfo.setSendStatus("0");
        purchaseCertificatedInfo.setFail("0");
        this.checkCertificationDate(purchaseCertificatedInfo);
        purchaseCertificatedInfo.setCreateAccount(TenantContext.getTenant());
        if (StringUtils.isBlank((CharSequence)purchaseCertificatedInfo.getPurchaseName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            purchaseCertificatedInfo.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)purchaseCertificatedInfo.getSupplierName()) && (enterpriseInfo = this.invokeEnterpriseRpcService.getByElsAccount(purchaseCertificatedInfo.getToElsAccount())) != null) {
            purchaseCertificatedInfo.setSupplierName(enterpriseInfo.getName());
        }
        this.purchaseCertificatedInfoMapper.insert((Object)purchaseCertificatedInfo);
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkCertificationDate(purchaseCertificatedInfo);
        this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseCertificatedInfo.getId());
        this.insertData(purchaseCertificatedInfo, purchaseAttachmentList);
    }

    private void insertData(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setId(null);
                entity.setHeadId(purchaseCertificatedInfo.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseCertificatedInfo);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    private void checkCertificationDate(PurchaseCertificatedInfo entity) {
        long effectiveDate = 0L;
        long expiryDate = 0L;
        long certificationDate = 0L;
        long currentTimeMillis = System.currentTimeMillis();
        if (entity.getEffectiveDate() != null) {
            effectiveDate = entity.getEffectiveDate().getTime();
        }
        if (entity.getExpiryDate() != null) {
            expiryDate = entity.getExpiryDate().getTime();
        }
        if (entity.getCertificationDate() != null) {
            certificationDate = entity.getCertificationDate().getTime();
        }
        if (effectiveDate > 0L && expiryDate == 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBASrWKXBAlSW_45dd225c", (String)"\u751f\u6548\u65e5\u671f\u586b\u4e86\uff0c\u5931\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
        }
        if (effectiveDate == 0L && expiryDate > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBASrWbXBAlSW_5bb2dcf8", (String)"\u5931\u6548\u65e5\u671f\u586b\u4e86\uff0c\u751f\u6548\u65e5\u671f\u5fc5\u586b\uff01"));
        }
        if (effectiveDate > 0L && expiryDate > 0L && (effectiveDate > expiryDate || effectiveDate == expiryDate)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWbXBAW_21db452a", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
        }
        if (certificationDate > 0L && certificationDate > effectiveDate) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LiBAWlTXUSEUWbXBAW_2012a69b", (String)"\u8ba4\u8bc1\u65e5\u671f \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e \u751f\u6548\u65e5\u671f\uff01"));
        }
        if (currentTimeMillis > expiryDate && expiryDate > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KXBAWlTfUWAPKIW_e61819d5", (String)"\u5931\u6548\u65e5\u671f \u5fc5\u987b\u5927\u4e8e \u5f53\u524d\u65f6\u95f4\uff01"));
        }
        if (currentTimeMillis < effectiveDate) {
            entity.setFail("1");
        }
        if (currentTimeMillis > effectiveDate && expiryDate > currentTimeMillis) {
            entity.setFail("0");
        }
        if (currentTimeMillis > expiryDate) {
            entity.setFail("1");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseStandardHead standardHead;
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)certificatedInfo.getShiftToId()) && (standardHead = (PurchaseStandardHead)((Object)this.purchaseStandardHeadMapper.selectById((Serializable)((Object)certificatedInfo.getShiftToId())))) != null) {
            standardHead.setShiftTo("0");
            this.purchaseStandardHeadMapper.updateById((Object)standardHead);
        }
        this.invokeBaseRpcService.deletePurchaseAttachment(id);
        this.purchaseCertificatedInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deletePurchaseAttachment(serializable.toString());
            this.purchaseCertificatedInfoMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> certificatedInfo(String toElsAccount) {
        String elsAccount = TenantContext.getTenant();
        List<PurchaseCertificatedInfo> certificatedInfos = this.purchaseCertificatedInfoMapper.getByAccount(elsAccount, toElsAccount);
        Result result = new Result();
        result.setResult(certificatedInfos);
        result.setSuccess(true);
        return result;
    }

    @Override
    public void send(PurchaseCertificatedInfo purchaseCertificatedInfo, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkCertificationDate(purchaseCertificatedInfo);
        purchaseCertificatedInfo.setSendStatus("1");
        SaleCertificatedInfo certificatedInfo = new SaleCertificatedInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseCertificatedInfo), (Object)((Object)certificatedInfo));
        certificatedInfo.setElsAccount(purchaseCertificatedInfo.getToElsAccount());
        certificatedInfo.setToElsAccount(purchaseCertificatedInfo.getElsAccount());
        certificatedInfo.setRelationId(purchaseCertificatedInfo.getId());
        SaleCertificatedInfo info = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)purchaseCertificatedInfo.getId())));
        if (info == null) {
            this.saleCertificatedInfoMapper.insert((Object)certificatedInfo);
            purchaseCertificatedInfo.setRelationId(certificatedInfo.getId());
            this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
            if (CollUtil.isNotEmpty(purchaseAttachmentList)) {
                AttachmentSendDTO sendDTO = new AttachmentSendDTO();
                sendDTO.setHeadId(purchaseCertificatedInfo.getId());
                sendDTO.setElsAccount(purchaseCertificatedInfo.getElsAccount());
                HashMap<String, String> toSend = new HashMap<String, String>();
                toSend.put(certificatedInfo.getId(), certificatedInfo.getElsAccount());
                sendDTO.setToSend(toSend);
                this.invokeBaseRpcService.sendPurchaseFile(sendDTO, true);
            }
        } else {
            certificatedInfo.setId(info.getId());
            this.saleCertificatedInfoMapper.updateById((Object)certificatedInfo);
            this.purchaseCertificatedInfoMapper.updateById((Object)purchaseCertificatedInfo);
        }
    }

    @Override
    public void loseEfficacy(String id) {
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)((Object)this.purchaseCertificatedInfoMapper.selectById((Serializable)((Object)id)));
        if (certificatedInfo != null) {
            certificatedInfo.setFail("1");
            this.purchaseCertificatedInfoMapper.updateById((Object)certificatedInfo);
            SaleCertificatedInfo saleCertificatedInfo = (SaleCertificatedInfo)((Object)this.saleCertificatedInfoMapper.selectById((Serializable)((Object)certificatedInfo.getRelationId())));
            saleCertificatedInfo.setFail(certificatedInfo.getFail());
            this.saleCertificatedInfoMapper.updateById((Object)saleCertificatedInfo);
        }
    }

    @Override
    public List<PurchaseCertificatedInfo> getPurchaseCertificatedListByToElsAccount(String elsAccount, String toElsAccount) {
        List<PurchaseCertificatedInfo> purchaseCertificatedInfoList = this.purchaseCertificatedInfoMapper.getDuplicatetInfoByElsAccount(elsAccount, toElsAccount);
        return purchaseCertificatedInfoList;
    }
}

