/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.mapper.SupplierAddressInfoMapper;
import com.els.modules.supplier.service.SupplierAddressInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierAddressInfoServiceImpl
extends ServiceImpl<SupplierAddressInfoMapper, SupplierAddressInfo>
implements SupplierAddressInfoService {
    @Autowired
    private SupplierAddressInfoMapper supplierAddressInfoMapper;

    @Override
    public List<SupplierAddressInfo> selectByMainId(String mainId) {
        return this.supplierAddressInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierAddressInfo> getByAccount(String elsAccount, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierAddressInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierAddressInfo> addressInfos = this.supplierAddressInfoMapper.getByAccount(elsAccount, toElsAccount);
        addressInfos.addAll(this.supplierAddressInfoMapper.getByAccount(elsAccount, null));
        return addressInfos;
    }

    @Override
    public List<SupplierAddressInfo> getByAccountAndRecordId(String elsAccount, String toElsAccount, String recordId, List<SupplierAddressInfo> oldAddressInfoList) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"is_deleted", (Object)0);
            return this.supplierAddressInfoMapper.selectList((Wrapper)queryWrapper);
        }
        List<SupplierAddressInfo> addressInfos = this.supplierAddressInfoMapper.getByAccount(elsAccount, toElsAccount);
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            addressInfos.addAll(oldAddressInfoList);
        } else {
            addressInfos.addAll(this.supplierAddressInfoMapper.getByAccount(elsAccount, null));
        }
        return addressInfos;
    }

    @Override
    public List<SupplierAddressInfo> getDataOnlyAccount(String elsAccount) {
        return this.supplierAddressInfoMapper.getByAccount(elsAccount, null);
    }

    @Override
    public void deleteByElsAccount(String elsAccount) {
        this.supplierAddressInfoMapper.deleteByElsAccount(elsAccount);
    }
}

