/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.mapper.SupplierContactsInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierContactsInfoServiceImpl
extends ServiceImpl<SupplierContactsInfoMapper, SupplierContactsInfo>
implements SupplierContactsInfoService {
    @Autowired
    private SupplierContactsInfoMapper supplierContactsInfoMapper;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;

    @Override
    public List<SupplierContactsInfo> selectByMainId(String mainId) {
        return this.supplierContactsInfoMapper.selectByMainId(mainId);
    }

    @Override
    public List<SupplierContactsInfo> getByAccount(String elsAccount, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            return this.supplierContactsInfoMapper.getByElsAccount(elsAccount);
        }
        List<SupplierContactsInfo> contactsInfos = this.supplierContactsInfoMapper.getByAccount(elsAccount, toElsAccount);
        contactsInfos.addAll(this.supplierContactsInfoMapper.getByAccount(elsAccount, null));
        return contactsInfos;
    }

    @Override
    public List<SupplierContactsInfo> getByAccountAndRecordId(String elsAccount, String toElsAccount, String recordId, List<SupplierContactsInfo> oldContactsInfoList) {
        if (StringUtils.isBlank((CharSequence)toElsAccount)) {
            return this.supplierContactsInfoMapper.getByElsAccount(elsAccount);
        }
        List<SupplierContactsInfo> contactsInfos = this.supplierContactsInfoMapper.getByAccount(elsAccount, toElsAccount);
        if (StringUtils.isNotBlank((CharSequence)recordId)) {
            contactsInfos.addAll(oldContactsInfoList);
        } else {
            contactsInfos.addAll(this.supplierContactsInfoMapper.getByAccount(elsAccount, null));
        }
        return contactsInfos;
    }

    @Override
    public Map<String, List<ElsSubAccountDTO>> getSupplierContacts(List<String> toElsAccountList, String businessType, String operateType) {
        return null;
    }

    private List<ElsSubAccountDTO> getSubAccountListByJob(String toElsAccount, String jobFunction) {
        List<SupplierContactsInfo> infoList = ((SupplierContactsInfoMapper)this.baseMapper).getByAccountUNION(toElsAccount, TenantContext.getTenant());
        ArrayList<ElsSubAccountDTO> accountDTOs = null;
        if (infoList.isEmpty()) {
            accountDTOs = new ArrayList<ElsSubAccountDTO>();
            accountDTOs.add(this.supplierInvokeAccountRpcService.getAccount(toElsAccount, "1001"));
            return accountDTOs;
        }
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        for (SupplierContactsInfo contactsInfo : infoList) {
            String subAccount = contactsInfo.getSubAccount();
            if (StrUtil.isNotBlank((CharSequence)subAccount)) {
                accountList.add(this.supplierInvokeAccountRpcService.getAccount(toElsAccount, "1001"));
                continue;
            }
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setEmail(contactsInfo.getEmail());
            account.setPhone(contactsInfo.getTelphone());
            accountList.add(account);
        }
        return accountList;
    }

    @Override
    public List<SupplierContactsInfo> getDataOnlyAccount(String elsAccount) {
        return this.supplierContactsInfoMapper.getByAccount(elsAccount, null);
    }

    @Override
    public void deleteByElsAccount(String elsAccount) {
        this.supplierContactsInfoMapper.deleteByElsAccount(elsAccount);
    }
}

